/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCXid;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReplyXids;
import com.ibm.as400.access.DBXARequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDTransactionManager;
import com.ibm.as400.access.JDUtilities;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class AS400JDBCXAResource
implements XAResource {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static int COUNT_ = 64;
    private static byte[] DEFAULT_XA_INFORMATION_ = new byte[256];
    private static int nextResourceManagerID_ = 49153;
    private static Object nextResourceManagerIDLock_ = new Object();
    private AS400JDBCConnection connection_;
    private int resourceManagerID_ = -1;
    private Xid started_ = null;
    private Vector allXids = new Vector();
    private JDTransactionManager transactionManager_;
    private int transactionTimeout_ = 0;
    private int lockWait_ = -1;
    static /* synthetic */ Class class$java$sql$DriverManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AS400JDBCXAResource(AS400JDBCConnection aS400JDBCConnection) throws XAException {
        this.connection_ = aS400JDBCConnection;
        this.transactionManager_ = this.connection_.getTransactionManager();
        Object object = nextResourceManagerIDLock_;
        synchronized (object) {
            this.resourceManagerID_ = nextResourceManagerID_++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        try {
            if (xid == null) {
                throw new XAException(-5);
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "xa_commit");
            }
            DBXARequestDS dBXARequestDS = null;
            DBReplyRequestedDS dBReplyRequestedDS = null;
            int n = 0;
            try {
                dBXARequestDS = DBDSPool.getDBXARequestDS(6305, 0, Integer.MIN_VALUE, 0);
                dBXARequestDS.setResourceManagerID(this.resourceManagerID_);
                dBXARequestDS.setXid(AS400JDBCXid.xidToBytes(xid));
                dBXARequestDS.setFlags(bl ? 0x40000000 : 0);
                dBReplyRequestedDS = this.connection_.sendAndReceive(dBXARequestDS);
                n = this.processXAReturnCode(dBReplyRequestedDS);
                Object var7_8 = null;
                if (dBXARequestDS != null) {
                    dBXARequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (dBXARequestDS != null) {
                    dBXARequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
                throw throwable;
            }
            this.transactionManager_.markGlobalTransactionBoundary();
            this.transactionManager_.resetXAServer();
            if (this.connection_.transactionManager_.getHoldIndicator() == 0 || this.connection_.checkStatementHoldability_ && this.connection_.getVRM() >= JDUtilities.vrm520) {
                this.connection_.markCursorsClosed(false);
            }
            if (n != 0) {
                throw new XAException(n);
            }
        }
        catch (XAException xAException) {
            throw xAException;
        }
        catch (Exception exception) {
            this.throwXAException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int n) throws XAException {
        try {
            if (xid == null) {
                throw new XAException(-5);
            }
            if (!this.allXids.contains(xid)) {
                throw new XAException(-6);
            }
            if (this.connection_.getServerFunctionalLevel() < 11 && n != 0x4000000 && n != 0x20000000) {
                throw new XAException(-5);
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "xa_end");
            }
            DBXARequestDS dBXARequestDS = null;
            DBReplyRequestedDS dBReplyRequestedDS = null;
            int n2 = 0;
            try {
                dBXARequestDS = DBDSPool.getDBXARequestDS(6307, 0, Integer.MIN_VALUE, 0);
                dBXARequestDS.setResourceManagerID(this.resourceManagerID_);
                dBXARequestDS.setXid(AS400JDBCXid.xidToBytes(xid));
                dBXARequestDS.setFlags(n);
                dBReplyRequestedDS = this.connection_.sendAndReceive(dBXARequestDS);
                n2 = this.processXAReturnCode(dBReplyRequestedDS);
                Object var7_8 = null;
                if (dBXARequestDS != null) {
                    dBXARequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (dBXARequestDS != null) {
                    dBXARequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
                throw throwable;
            }
            this.transactionManager_.setLocalTransaction(true);
            this.started_ = null;
            this.insertRemoveXidByFlag(xid, n);
            if (n2 != 0) {
                throw new XAException(n2);
            }
        }
        catch (XAException xAException) {
            throw xAException;
        }
        catch (Exception exception) {
            this.throwXAException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        try {
            if (xid == null) {
                throw new XAException(-5);
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "xa_forget");
            }
            DBXARequestDS dBXARequestDS = null;
            DBReplyRequestedDS dBReplyRequestedDS = null;
            int n = 0;
            try {
                dBXARequestDS = DBDSPool.getDBXARequestDS(6308, 0, Integer.MIN_VALUE, 0);
                dBXARequestDS.setResourceManagerID(this.resourceManagerID_);
                dBXARequestDS.setXid(AS400JDBCXid.xidToBytes(xid));
                dBXARequestDS.setFlags(0);
                dBReplyRequestedDS = this.connection_.sendAndReceive(dBXARequestDS);
                n = this.processXAReturnCode(dBReplyRequestedDS);
                Object var6_7 = null;
                if (dBXARequestDS != null) {
                    dBXARequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (dBXARequestDS != null) {
                    dBXARequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
                throw throwable;
            }
            if (n < 0) {
                throw new XAException(n);
            }
        }
        catch (XAException xAException) {
            throw xAException;
        }
        catch (Exception exception) {
            this.throwXAException(exception);
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout_;
    }

    private void insertRemoveXidByFlag(Xid xid, int n) {
        if (n == 0) {
            if (!this.allXids.contains(xid)) {
                this.allXids.add(xid);
            }
        } else if ((n & 0x200000) == 0x200000) {
            if (!this.allXids.contains(xid)) {
                this.allXids.add(xid);
            }
        } else if ((n & 0x4000000) == 0x4000000) {
            this.allXids.remove(xid);
        } else if ((n & 0x20000000) == 0x20000000) {
            this.allXids.remove(xid);
        }
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (xAResource == null) {
            return false;
        }
        if (!(xAResource instanceof AS400JDBCXAResource)) {
            return false;
        }
        try {
            return this.connection_.getCatalog().equalsIgnoreCase(((AS400JDBCXAResource)xAResource).connection_.getCatalog());
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        try {
            if (xid == null) {
                throw new XAException(-5);
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "xa_prepare");
            }
            DBXARequestDS dBXARequestDS = null;
            DBReplyRequestedDS dBReplyRequestedDS = null;
            int n = 0;
            try {
                dBXARequestDS = DBDSPool.getDBXARequestDS(6310, 0, Integer.MIN_VALUE, 0);
                dBXARequestDS.setResourceManagerID(this.resourceManagerID_);
                dBXARequestDS.setXid(AS400JDBCXid.xidToBytes(xid));
                dBXARequestDS.setFlags(0);
                dBReplyRequestedDS = this.connection_.sendAndReceive(dBXARequestDS);
                n = this.processXAReturnCode(dBReplyRequestedDS);
                Object var6_7 = null;
                if (dBXARequestDS != null) {
                    dBXARequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (dBXARequestDS != null) {
                    dBXARequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
                throw throwable;
            }
            if (n == 0 || n == 3) {
                return n;
            }
            throw new XAException(n);
        }
        catch (XAException xAException) {
            throw xAException;
        }
        catch (Exception exception) {
            this.throwXAException(exception);
            return -1;
        }
    }

    private int processXAReturnCode(DBReplyRequestedDS dBReplyRequestedDS) throws XAException {
        int n = dBReplyRequestedDS.getErrorClass();
        int n2 = dBReplyRequestedDS.getReturnCode();
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "xa error class = " + n + ", return code = " + n2);
        }
        if (n2 < 0) {
            if (n == 9) {
                throw new XAException(n2);
            }
            if (n != 0) {
                throw new XAException(-7);
            }
            return n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int n) throws XAException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "xa_recover");
        }
        DBXARequestDS dBXARequestDS = null;
        DBReplyRequestedDS dBReplyRequestedDS = null;
        int n2 = 0;
        try {
            Xid[] xidArray;
            block11: {
                dBXARequestDS = DBDSPool.getDBXARequestDS(6311, 0, Integer.MIN_VALUE, 0);
                dBXARequestDS.setResourceManagerID(this.resourceManagerID_);
                dBXARequestDS.setCount(COUNT_);
                dBXARequestDS.setFlags(n);
                dBReplyRequestedDS = this.connection_.sendAndReceive(dBXARequestDS);
                n2 = this.processXAReturnCode(dBReplyRequestedDS);
                DBReplyXids dBReplyXids = dBReplyRequestedDS.getXids();
                if (n2 < 0) {
                    throw new XAException(n2);
                }
                xidArray = dBReplyXids.getXidArray();
                {
                    Object var8_9 = null;
                    if (dBXARequestDS != null) {
                        dBXARequestDS.inUse_ = false;
                    }
                    if (dBReplyRequestedDS == null) break block11;
                    dBReplyRequestedDS.inUse_ = false;
                }
            }
            return xidArray;
        }
        catch (Throwable throwable) {
            try {
                Object var8_10 = null;
                if (dBXARequestDS != null) {
                    dBXARequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
                throw throwable;
            }
            catch (XAException xAException) {
                throw xAException;
            }
            catch (Exception exception) {
                this.throwXAException(exception);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        try {
            if (xid == null) {
                throw new XAException(-5);
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "xa_rollback");
            }
            DBXARequestDS dBXARequestDS = null;
            DBReplyRequestedDS dBReplyRequestedDS = null;
            int n = 0;
            try {
                dBXARequestDS = DBDSPool.getDBXARequestDS(6312, 0, Integer.MIN_VALUE, 0);
                dBXARequestDS.setResourceManagerID(this.resourceManagerID_);
                dBXARequestDS.setXid(AS400JDBCXid.xidToBytes(xid));
                dBXARequestDS.setFlags(0);
                dBReplyRequestedDS = this.connection_.sendAndReceive(dBXARequestDS);
                n = this.processXAReturnCode(dBReplyRequestedDS);
                Object var6_7 = null;
                if (dBXARequestDS != null) {
                    dBXARequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (dBXARequestDS != null) {
                    dBXARequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
                throw throwable;
            }
            this.transactionManager_.markGlobalTransactionBoundary();
            this.transactionManager_.resetXAServer();
            if (n != 0) {
                throw new XAException(n);
            }
        }
        catch (XAException xAException) {
            throw xAException;
        }
        catch (Exception exception) {
            this.throwXAException(exception);
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        try {
            if (this.connection_.getVRM() < JDUtilities.vrm530) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        try {
            if (this.transactionTimeout_ < 0) {
                JDError.throwSQLException("HY024");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.transactionTimeout_ = n;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int n) throws XAException {
        try {
            if (xid == null) {
                throw new XAException(-5);
            }
            if (this.started_ != null) {
                throw new XAException(-6);
            }
            if (n != 0 && n != 0x200000 && this.connection_.getVRM() < JDUtilities.vrm540) {
                throw new XAException(-5);
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "xa_start");
            }
            DBXARequestDS dBXARequestDS = null;
            DBReplyRequestedDS dBReplyRequestedDS = null;
            int n2 = 0;
            try {
                dBXARequestDS = DBDSPool.getDBXARequestDS(6313, 0, Integer.MIN_VALUE, 0);
                dBXARequestDS.setResourceManagerID(this.resourceManagerID_);
                dBXARequestDS.setXid(AS400JDBCXid.xidToBytes(xid));
                dBXARequestDS.setFlags(n);
                if (this.connection_.getServerFunctionalLevel() >= 11) {
                    dBXARequestDS.setCtlTimeout(this.transactionTimeout_);
                    if (this.lockWait_ != -1) {
                        dBXARequestDS.setLockWait(this.lockWait_);
                    }
                }
                if (this.connection_.getVRM() >= JDUtilities.vrm540) {
                    int n3 = this.connection_.getProperties().getInt(70);
                    dBXARequestDS.setXALooselyCoupledSupport(n3);
                }
                dBReplyRequestedDS = this.connection_.sendAndReceive(dBXARequestDS);
                n2 = this.processXAReturnCode(dBReplyRequestedDS);
                Object var8_9 = null;
                if (dBXARequestDS != null) {
                    dBXARequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (dBXARequestDS != null) {
                    dBXARequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
                throw throwable;
            }
            this.transactionManager_.setLocalTransaction(false);
            this.started_ = xid;
            this.insertRemoveXidByFlag(xid, n);
            if (n2 != 0) {
                throw new XAException(n2);
            }
        }
        catch (XAException xAException) {
            throw xAException;
        }
        catch (Exception exception) {
            this.throwXAException(exception);
        }
    }

    public void setLockWait(int n) throws SQLException {
        if (this.connection_.getVRM() < JDUtilities.vrm530) {
            return;
        }
        if (n < 0) {
            JDError.throwSQLException("HY024");
        }
        this.lockWait_ = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throwXAException(Exception exception) throws XAException {
        if (JDTrace.isTraceOn()) {
            Class clazz = class$java$sql$DriverManager == null ? (class$java$sql$DriverManager = AS400JDBCXAResource.class$("java.sql.DriverManager")) : class$java$sql$DriverManager;
            synchronized (clazz) {
                exception.printStackTrace(DriverManager.getLogStream());
            }
        }
        throw new XAException(-7);
    }

    public String toString() {
        return this.connection_.toString() + "-XA:RMID#" + this.resourceManagerID_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

