/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.EventLog;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SecureAS400;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class AS400JDBCDataSource
implements DataSource,
Referenceable,
Serializable,
Cloneable {
    static final long serialVersionUID = 4L;
    private static final String DATABASE_NAME = "databaseName";
    private static final String DATASOURCE_NAME = "dataSourceName";
    private static final String DESCRIPTION = "description";
    private static final String SERVER_NAME = "serverName";
    private static final String USER = "userName";
    private static final String KEY_RING_NAME = "keyring";
    private static final String PASSWORD = "pw";
    private static final String KEY_RING_PASSWORD = "keyringpw";
    private static final String SECURE = "secure";
    private static final String SAVE_PASSWORD = "savepw";
    private static final String PLAIN_TEXT_PASSWORD = "pwd";
    private static final String TRUE_ = "true";
    private static final String FALSE_ = "false";
    private static final String TOOLBOX_DRIVER = "jdbc:as400:";
    private static final int MAX_THRESHOLD = 0x1000000;
    private static final int MAX_SCALE = 63;
    private static final String SOCKET_KEEP_ALIVE = "soKeepAlive";
    private static final String SOCKET_RECEIVE_BUFFER_SIZE = "soReceiveBufferSize";
    private static final String SOCKET_SEND_BUFFER_SIZE = "soSendBufferSize";
    private static final String SOCKET_LINGER = "soLinger";
    private static final String SOCKET_TIMEOUT = "soTimeout";
    private static final String SOCKET_TCP_NO_DELAY = "soTCPNoDelay";
    private transient AS400 as400_;
    private String dataSourceName_;
    private String description_;
    private JDProperties properties_;
    private SocketProperties sockProps_;
    private transient PrintWriter writer_;
    private transient EventLog log_;
    private String serialServerName_;
    private String serialUserName_;
    private String serialKeyRingName_;
    transient PropertyChangeSupport changes_;
    private boolean isSecure_;
    private static ResourceBundleLoader loader_;
    private char[] serialPWBytes_;
    private char[] serialKeyRingPWBytes_;
    private boolean savePasswordWhenSerialized_;
    public static final int MAX_STORAGE_LIMIT = 2147352578;
    static final int TRACE_CLIENT = 1;
    public static final int SERVER_TRACE_START_DATABASE_MONITOR = 2;
    public static final int SERVER_TRACE_DEBUG_SERVER_JOB = 4;
    public static final int SERVER_TRACE_SAVE_SERVER_JOBLOG = 8;
    public static final int SERVER_TRACE_TRACE_SERVER_JOB = 16;
    public static final int SERVER_TRACE_SAVE_SQL_INFORMATION = 32;

    public AS400JDBCDataSource() {
        this.dataSourceName_ = "";
        this.description_ = "";
        this.isSecure_ = false;
        this.serialPWBytes_ = null;
        this.serialKeyRingPWBytes_ = null;
        this.savePasswordWhenSerialized_ = false;
        this.initializeTransient();
        this.properties_ = new JDProperties(null, null);
        this.sockProps_ = new SocketProperties();
    }

    public AS400JDBCDataSource(String string) {
        this();
        this.setServerName(string);
    }

    public AS400JDBCDataSource(String string, String string2, String string3) {
        this();
        this.setServerName(string);
        this.setUser(string2);
        this.setPassword(string3);
    }

    public AS400JDBCDataSource(AS400 aS400) {
        this();
        this.as400_ = aS400;
        if (aS400 instanceof SecureAS400) {
            this.setSecure(true);
        }
    }

    public AS400JDBCDataSource(String string, String string2, String string3, String string4, String string5) {
        this();
        this.setSecure(true);
        try {
            this.as400_ = new SecureAS400(this.as400_);
            ((SecureAS400)this.as400_).setKeyRingName(string4, string5);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.serialKeyRingName_ = string4;
        this.serialKeyRingPWBytes_ = AS400JDBCDataSource.xpwConfuse(string5);
        this.setServerName(string);
        this.setUser(string2);
        this.setPassword(string3);
    }

    AS400JDBCDataSource(Reference reference) {
        Object object;
        block25: {
            this.dataSourceName_ = "";
            this.description_ = "";
            this.isSecure_ = false;
            this.serialPWBytes_ = null;
            this.serialKeyRingPWBytes_ = null;
            this.savePasswordWhenSerialized_ = false;
            if (reference == null) {
                throw new NullPointerException("reference");
            }
            this.changes_ = new PropertyChangeSupport(this);
            if (((String)reference.get(SECURE).getContent()).equalsIgnoreCase(TRUE_)) {
                this.isSecure_ = true;
                this.as400_ = new SecureAS400();
                this.serialKeyRingName_ = (String)reference.get(KEY_RING_NAME).getContent();
                this.serialKeyRingPWBytes_ = (char[])(reference.get(KEY_RING_PASSWORD) != null ? ((String)reference.get(KEY_RING_PASSWORD).getContent()).toCharArray() : null);
                try {
                    if (this.serialKeyRingPWBytes_ != null && this.serialKeyRingPWBytes_.length > 0) {
                        ((SecureAS400)this.as400_).setKeyRingName(this.serialKeyRingName_, AS400JDBCDataSource.xpwDeconfuse(this.serialKeyRingPWBytes_));
                        break block25;
                    }
                    ((SecureAS400)this.as400_).setKeyRingName(this.serialKeyRingName_);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                this.isSecure_ = false;
                this.as400_ = new AS400();
            }
        }
        this.properties_ = new JDProperties(null, null);
        Properties properties = new Properties();
        this.sockProps_ = new SocketProperties();
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            object = (StringRefAddr)enumeration.nextElement();
            String string = ((RefAddr)object).getType();
            String string2 = (String)reference.get(string).getContent();
            if (string.equals(DATABASE_NAME)) {
                this.setDatabaseName(string2);
                continue;
            }
            if (string.equals(DATASOURCE_NAME)) {
                this.setDataSourceName(string2);
                continue;
            }
            if (string.equals(DESCRIPTION)) {
                this.setDescription(string2);
                continue;
            }
            if (string.equals(SERVER_NAME)) {
                this.setServerName(string2);
                continue;
            }
            if (string.equals(USER)) {
                this.setUser(string2);
                continue;
            }
            if (string.equals(PLAIN_TEXT_PASSWORD)) {
                this.setPassword(string2);
                continue;
            }
            if (string.equals(PASSWORD)) {
                if (reference.get(PLAIN_TEXT_PASSWORD) != null) {
                    this.setPassword((String)reference.get(PLAIN_TEXT_PASSWORD).getContent());
                    continue;
                }
                this.serialPWBytes_ = string2.toCharArray();
                this.as400_.setPassword(AS400JDBCDataSource.xpwDeconfuse(this.serialPWBytes_));
                continue;
            }
            if (string.equals(SAVE_PASSWORD)) {
                this.savePasswordWhenSerialized_ = string2.equals(TRUE_);
                continue;
            }
            if (string.equals(SECURE) || string.equals(KEY_RING_NAME) || string.equals(KEY_RING_PASSWORD)) continue;
            if (string.equals(SOCKET_KEEP_ALIVE)) {
                this.sockProps_.setKeepAlive(string2.equals(TRUE_));
                continue;
            }
            if (string.equals(SOCKET_RECEIVE_BUFFER_SIZE)) {
                this.sockProps_.setReceiveBufferSize(Integer.parseInt(string2));
                continue;
            }
            if (string.equals(SOCKET_SEND_BUFFER_SIZE)) {
                this.sockProps_.setSendBufferSize(Integer.parseInt(string2));
                continue;
            }
            if (string.equals(SOCKET_LINGER)) {
                this.sockProps_.setSoLinger(Integer.parseInt(string2));
                continue;
            }
            if (string.equals(SOCKET_TIMEOUT)) {
                this.sockProps_.setSoTimeout(Integer.parseInt(string2));
                continue;
            }
            if (string.equals(SOCKET_TCP_NO_DELAY)) {
                this.sockProps_.setTcpNoDelay(string2.equals(TRUE_));
                continue;
            }
            ((Hashtable)properties).put(string, string2);
        }
        this.properties_ = new JDProperties(properties, null);
        object = this.properties_.getString(18);
        if (object != null && ((String)object).equalsIgnoreCase(FALSE_)) {
            this.setPrompt(false);
        } else if (object != null && ((String)object).equalsIgnoreCase(TRUE_)) {
            this.setPrompt(true);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
        this.as400_.addPropertyChangeListener(propertyChangeListener);
    }

    public Object clone() {
        try {
            AS400JDBCDataSource aS400JDBCDataSource = (AS400JDBCDataSource)super.clone();
            aS400JDBCDataSource.properties_ = (JDProperties)this.properties_.clone();
            return aS400JDBCDataSource;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, cloneNotSupportedException);
            throw new UnsupportedOperationException("clone()");
        }
    }

    public String getAccess() {
        return this.properties_.getString(0);
    }

    public int getBehaviorOverride() {
        return this.properties_.getInt(50);
    }

    public int getBidiStringType() {
        String string = this.properties_.getString(42);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public int getBlockCriteria() {
        return this.properties_.getInt(2);
    }

    public int getBlockSize() {
        return this.properties_.getInt(1);
    }

    public Connection getConnection() throws SQLException {
        if (this.isSecure_ || this.isSecure()) {
            return this.getConnection(new SecureAS400(this.as400_));
        }
        return this.getConnection(new AS400(this.as400_));
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (string == null) {
            throw new NullPointerException("user");
        }
        if (string2 == null) {
            throw new NullPointerException("password");
        }
        AS400 aS400 = this.isSecure_ || this.isSecure() ? new SecureAS400(this.getServerName(), string, string2) : new AS400(this.getServerName(), string, string2);
        try {
            if (!this.as400_.isThreadUsed()) {
                aS400.setThreadUsed(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            if (!this.isPrompt()) {
                aS400.setGuiAvailable(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return this.getConnection(aS400);
    }

    private Connection getConnection(AS400 aS400) throws SQLException {
        if (this.sockProps_ != null) {
            aS400.setSocketProperties(this.sockProps_);
        } else if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "sockProps_:  null");
        }
        AS400JDBCConnection aS400JDBCConnection = null;
        aS400JDBCConnection = new AS400JDBCConnection();
        aS400JDBCConnection.setSystem(aS400);
        aS400JDBCConnection.setProperties(new JDDataSourceURL("jdbc:as400://" + aS400.getSystemName()), this.properties_, aS400);
        this.log(ResourceBundleLoader.getText("AS400_JDBC_DS_CONN_CREATED"));
        return aS400JDBCConnection;
    }

    public String getCursorSensitivity() {
        return this.properties_.getString(49);
    }

    public String getDatabaseName() {
        return this.properties_.getString(47);
    }

    public String getDataSourceName() {
        return this.dataSourceName_;
    }

    public String getDateFormat() {
        return this.properties_.getString(3);
    }

    public String getDateSeparator() {
        return this.properties_.getString(4);
    }

    public String getDecfloatRoundingMode() {
        return this.properties_.getString(74);
    }

    public String getDecimalSeparator() {
        return this.properties_.getString(5);
    }

    public String getDescription() {
        return this.description_;
    }

    public String getDriver() {
        return this.properties_.getString(41);
    }

    public String getErrors() {
        return this.properties_.getString(6);
    }

    public String getLibraries() {
        return this.properties_.getString(8);
    }

    public int getLobThreshold() {
        return this.properties_.getInt(31);
    }

    public int getLoginTimeout() {
        return this.properties_.getInt(58);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.writer_;
    }

    public int getMetaDataSource() {
        return this.properties_.getInt(72);
    }

    public int getMetadataSource() {
        return this.getMetaDataSource();
    }

    public String getNaming() {
        return this.properties_.getString(9);
    }

    public String getPackage() {
        return this.properties_.getString(10);
    }

    public String getPackageCriteria() {
        return this.properties_.getString(30);
    }

    public String getPackageError() {
        return this.properties_.getString(14);
    }

    public String getPackageLibrary() {
        return this.properties_.getString(15);
    }

    public String getProxyServer() {
        return this.properties_.getString(34);
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "com.ibm.as400.access.AS400JDBCObjectFactory", null);
        DriverPropertyInfo[] driverPropertyInfoArray = this.properties_.getInfo();
        for (int i = 0; i < driverPropertyInfoArray.length; ++i) {
            if (driverPropertyInfoArray[i].value == null) continue;
            reference.add(new StringRefAddr(driverPropertyInfoArray[i].name, driverPropertyInfoArray[i].value));
        }
        if (this.sockProps_.keepAliveSet_) {
            reference.add(new StringRefAddr(SOCKET_KEEP_ALIVE, this.sockProps_.keepAlive_ ? TRUE_ : FALSE_));
        }
        if (this.sockProps_.receiveBufferSizeSet_) {
            reference.add(new StringRefAddr(SOCKET_RECEIVE_BUFFER_SIZE, Integer.toString(this.sockProps_.receiveBufferSize_)));
        }
        if (this.sockProps_.sendBufferSizeSet_) {
            reference.add(new StringRefAddr(SOCKET_SEND_BUFFER_SIZE, Integer.toString(this.sockProps_.sendBufferSize_)));
        }
        if (this.sockProps_.soLingerSet_) {
            reference.add(new StringRefAddr(SOCKET_LINGER, Integer.toString(this.sockProps_.soLinger_)));
        }
        if (this.sockProps_.soTimeoutSet_) {
            reference.add(new StringRefAddr(SOCKET_TIMEOUT, Integer.toString(this.sockProps_.soTimeout_)));
        }
        if (this.sockProps_.tcpNoDelaySet_) {
            reference.add(new StringRefAddr(SOCKET_TCP_NO_DELAY, this.sockProps_.tcpNoDelay_ ? TRUE_ : FALSE_));
        }
        if (this.getDatabaseName() != null) {
            reference.add(new StringRefAddr(DATABASE_NAME, this.getDatabaseName()));
        }
        if (this.getDataSourceName() != null) {
            reference.add(new StringRefAddr(DATASOURCE_NAME, this.getDataSourceName()));
        }
        if (this.getDescription() != null) {
            reference.add(new StringRefAddr(DESCRIPTION, this.getDescription()));
        }
        reference.add(new StringRefAddr(SERVER_NAME, this.getServerName()));
        reference.add(new StringRefAddr(USER, this.getUser()));
        reference.add(new StringRefAddr(KEY_RING_NAME, this.serialKeyRingName_));
        if (this.savePasswordWhenSerialized_) {
            reference.add(new StringRefAddr(PASSWORD, new String(this.serialPWBytes_)));
            if (this.serialKeyRingPWBytes_ != null) {
                reference.add(new StringRefAddr(KEY_RING_PASSWORD, new String(this.serialKeyRingPWBytes_)));
            } else {
                reference.add(new StringRefAddr(KEY_RING_PASSWORD, null));
            }
        }
        reference.add(new StringRefAddr(SECURE, this.isSecure_ ? TRUE_ : FALSE_));
        reference.add(new StringRefAddr(SAVE_PASSWORD, this.savePasswordWhenSerialized_ ? TRUE_ : FALSE_));
        return reference;
    }

    public String getRemarks() {
        return this.properties_.getString(19);
    }

    public String getSecondaryUrl() {
        return this.properties_.getString(35);
    }

    public String getSecondaryURL() {
        return this.getSecondaryUrl();
    }

    public String getServerName() {
        return this.as400_.getSystemName();
    }

    public int getServerTraceCategories() {
        return this.properties_.getInt(46);
    }

    public int getServerTrace() {
        return this.getServerTraceCategories();
    }

    public String getSort() {
        return this.properties_.getString(20);
    }

    public String getSortLanguage() {
        return this.properties_.getString(21);
    }

    public String getSortTable() {
        return this.properties_.getString(22);
    }

    public String getSortWeight() {
        return this.properties_.getString(23);
    }

    public String getTimeFormat() {
        return this.properties_.getString(24);
    }

    public String getTimeSeparator() {
        return this.properties_.getString(25);
    }

    public String getTransactionIsolation() {
        return this.properties_.getString(27);
    }

    public String getUser() {
        return this.as400_.getUserId();
    }

    public String getQaqqiniLibrary() {
        return this.properties_.getString(57);
    }

    public String getQaqqinilib() {
        return this.getQaqqiniLibrary();
    }

    public int getQueryOptimizeGoal() {
        return this.properties_.getInt(66);
    }

    public int getQueryStorageLimit() {
        return this.properties_.getInt(73);
    }

    public int getXALooselyCoupledSupport() {
        return this.properties_.getInt(70);
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.as400_ = this.isSecure_ ? new SecureAS400() : new AS400();
        if (this.serialServerName_ != null) {
            this.setServerName(this.serialServerName_);
        }
        if (this.serialUserName_ != null) {
            this.setUser(this.serialUserName_);
            if (this.serialPWBytes_ != null && this.serialPWBytes_.length > 0) {
                this.as400_.setPassword(AS400JDBCDataSource.xpwDeconfuse(this.serialPWBytes_));
            }
        }
        try {
            if (this.serialKeyRingName_ != null && this.isSecure_) {
                if (this.serialKeyRingPWBytes_ != null && this.serialKeyRingPWBytes_.length > 0) {
                    String string = AS400JDBCDataSource.xpwDeconfuse(this.serialKeyRingPWBytes_);
                    ((SecureAS400)this.as400_).setKeyRingName(this.serialKeyRingName_, string);
                } else {
                    ((SecureAS400)this.as400_).setKeyRingName(this.serialKeyRingName_);
                }
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            if (this.properties_ != null && !this.isPrompt()) {
                this.as400_.setGuiAvailable(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public boolean isTrueAutoCommit() {
        return this.properties_.getBoolean(59);
    }

    public boolean isTrueAutocommit() {
        return this.isTrueAutoCommit();
    }

    public boolean isVariableFieldCompression() {
        return this.properties_.getBoolean(65);
    }

    public boolean isAutoCommit() {
        return this.properties_.getBoolean(76);
    }

    public boolean isAutocommitException() {
        return this.properties_.getBoolean(75);
    }

    public boolean isBidiImplicitReordering() {
        return this.properties_.getBoolean(60);
    }

    public boolean isBidiNumericOrdering() {
        return this.properties_.getBoolean(61);
    }

    public boolean isBigDecimal() {
        return this.properties_.getBoolean(37);
    }

    public boolean isCursorHold() {
        return this.properties_.getBoolean(39);
    }

    public boolean isDataCompression() {
        return this.properties_.getBoolean(36);
    }

    public boolean isDataTruncation() {
        return this.properties_.getBoolean(33);
    }

    public boolean isExtendedDynamic() {
        return this.properties_.getBoolean(7);
    }

    public boolean isExtendedMetaData() {
        return this.properties_.getBoolean(48);
    }

    public boolean isExtendedMetadata() {
        return this.isExtendedMetaData();
    }

    public boolean isFullOpen() {
        return this.properties_.getBoolean(45);
    }

    public boolean isLazyClose() {
        return this.properties_.getBoolean(40);
    }

    public boolean isHoldInputLocators() {
        return this.properties_.getBoolean(62);
    }

    public boolean isPackageAdd() {
        return this.properties_.getBoolean(11);
    }

    public boolean isPackageCache() {
        return this.properties_.getBoolean(12);
    }

    public boolean isPackageClear() {
        return false;
    }

    public boolean isPrefetch() {
        return this.properties_.getBoolean(17);
    }

    public boolean isPrompt() {
        return this.properties_.getBoolean(18);
    }

    public boolean isRollbackCursorHold() {
        return this.properties_.getBoolean(64);
    }

    public boolean isHoldStatements() {
        return this.properties_.getBoolean(63);
    }

    public boolean isSavePasswordWhenSerialized() {
        return this.savePasswordWhenSerialized_;
    }

    public boolean isSecure() {
        return this.properties_.getBoolean(32);
    }

    public boolean isThreadUsed() {
        return this.properties_.getBoolean(38);
    }

    public boolean isTrace() {
        return this.properties_.getBoolean(26);
    }

    public boolean isTranslateBinary() {
        return this.properties_.getBoolean(28);
    }

    public boolean isTranslateBoolean() {
        return this.properties_.getBoolean(71);
    }

    void log(String string) {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string);
        }
        if (this.log_ != null) {
            this.log_.log(string);
        }
    }

    private void logProperty(String string, String string2) {
        if (Trace.isTraceOn()) {
            JDTrace.logProperty((Object)this, string, string2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
        this.as400_.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAccess(String string) {
        String string2 = "access";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateProperty(string2, string, 0);
        String string3 = this.getAccess();
        this.properties_.setString(0, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setAutoCommit(boolean bl) {
        String string = "autoCommit";
        Boolean bl2 = new Boolean(this.isAutoCommit());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(76, TRUE_);
        } else {
            this.properties_.setString(76, FALSE_);
        }
        this.changes_.firePropertyChange(string, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + bl);
        }
    }

    public void setAutocommitException(boolean bl) {
        String string = "autocommitException";
        Boolean bl2 = new Boolean(this.isAutocommitException());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(75, TRUE_);
        } else {
            this.properties_.setString(75, FALSE_);
        }
        this.changes_.firePropertyChange(string, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + bl);
        }
    }

    public void setTrueAutoCommit(boolean bl) {
        String string = "trueAutoCommit";
        Boolean bl2 = new Boolean(this.isTrueAutoCommit());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(59, TRUE_);
        } else {
            this.properties_.setString(59, FALSE_);
        }
        this.changes_.firePropertyChange(string, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + bl);
        }
    }

    public void setTrueAutocommit(boolean bl) {
        this.setTrueAutoCommit(bl);
    }

    public void setBehaviorOverride(int n) {
        String string = "behaviorOverride";
        Integer n2 = new Integer(this.getBehaviorOverride());
        Integer n3 = new Integer(n);
        this.properties_.setString(50, n3.toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public void setBidiStringType(int n) {
        String string = "bidiStringType";
        Integer n2 = new Integer(this.getBidiStringType());
        Integer n3 = new Integer(n);
        this.validateProperty(string, n3.toString(), 42);
        this.properties_.setString(42, n3.toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public void setBidiImplicitReordering(boolean bl) {
        String string = "bidiImplicitReordering";
        Boolean bl2 = new Boolean(this.isBidiImplicitReordering());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(60, TRUE_);
        } else {
            this.properties_.setString(60, FALSE_);
        }
        this.changes_.firePropertyChange(string, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + bl);
        }
    }

    public void setBidiNumericOrdering(boolean bl) {
        String string = "bidiNumericOrdering";
        Boolean bl2 = new Boolean(this.isBidiNumericOrdering());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(61, TRUE_);
        } else {
            this.properties_.setString(61, FALSE_);
        }
        this.changes_.firePropertyChange(string, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + bl);
        }
    }

    public void setBigDecimal(boolean bl) {
        String string = "bigDecimal";
        Boolean bl2 = new Boolean(this.isBigDecimal());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(37, TRUE_);
        } else {
            this.properties_.setString(37, FALSE_);
        }
        this.changes_.firePropertyChange(string, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + bl);
        }
    }

    public void setBlockCriteria(int n) {
        String string = "blockCriteria";
        Integer n2 = new Integer(this.getBlockCriteria());
        Integer n3 = new Integer(n);
        this.validateProperty(string, n3.toString(), 2);
        this.properties_.setString(2, n3.toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public void setBlockSize(int n) {
        String string = "blockSize";
        Integer n2 = new Integer(this.getBlockSize());
        Integer n3 = new Integer(n);
        this.validateProperty(string, n3.toString(), 1);
        this.properties_.setString(1, new Integer(n).toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public void setCursorSensitivity(String string) {
        String string2 = "cursorSensitivity";
        String string3 = this.getCursorSensitivity();
        String string4 = string;
        this.validateProperty(string2, string4, 49);
        this.properties_.setString(49, string);
        this.changes_.firePropertyChange(string2, string3, string4);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setCursorHold(boolean bl) {
        String string = "cursorHold";
        Boolean bl2 = new Boolean(this.isCursorHold());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(39, TRUE_);
        } else {
            this.properties_.setString(39, FALSE_);
        }
        this.changes_.firePropertyChange(string, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + bl);
        }
    }

    public void setDatabaseName(String string) {
        String string2 = DATABASE_NAME;
        if (string == null) {
            throw new NullPointerException(string2);
        }
        String string3 = this.getDatabaseName();
        this.properties_.setString(47, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setDataCompression(boolean bl) {
        Boolean bl2 = new Boolean(this.isDataCompression());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(36, TRUE_);
        } else {
            this.properties_.setString(36, FALSE_);
        }
        this.changes_.firePropertyChange("dataCompression", bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "dataCompression: " + bl);
        }
    }

    public void setDataSourceName(String string) {
        String string2 = DATASOURCE_NAME;
        if (string == null) {
            throw new NullPointerException(string2);
        }
        String string3 = this.getDataSourceName();
        this.dataSourceName_ = string;
        this.changes_.firePropertyChange(string2, string3, string);
        this.logProperty("dataSource", this.dataSourceName_);
    }

    public void setDataTruncation(boolean bl) {
        Boolean bl2 = new Boolean(this.isDataTruncation());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(33, TRUE_);
        } else {
            this.properties_.setString(33, FALSE_);
        }
        this.changes_.firePropertyChange("dataTruncation", bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "dataTruncation: " + bl);
        }
    }

    public void setDateFormat(String string) {
        String string2 = "dateFormat";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateProperty(string2, string, 3);
        String string3 = this.getDateFormat();
        this.properties_.setString(3, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setDateSeparator(String string) {
        String string2 = "dateSeparator";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateProperty(string2, string, 4);
        String string3 = this.getDateSeparator();
        this.properties_.setString(4, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setDecfloatRoundingMode(String string) {
        String string2 = "decfloatRoundingMode";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateProperty(string2, string, 74);
        String string3 = this.getDecfloatRoundingMode();
        this.properties_.setString(74, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setDecimalSeparator(String string) {
        String string2 = "decimalSeparator";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateProperty(string2, string, 5);
        String string3 = this.getDecimalSeparator();
        this.properties_.setString(5, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setDescription(String string) {
        String string2 = DESCRIPTION;
        if (string == null) {
            throw new NullPointerException(string2);
        }
        String string3 = this.getDescription();
        this.description_ = string;
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setSort(String string) {
        String string2 = "sort";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        if (string.equals("job")) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, string2 + ": " + this.getSort() + " (warning: " + this.getSort() + " will be used since sort=job is not valid)");
            }
            return;
        }
        this.validateProperty(string2, string, 20);
        String string3 = this.getSort();
        this.properties_.setString(20, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setErrors(String string) {
        String string2 = "errors";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateProperty(string2, string, 6);
        String string3 = this.getErrors();
        this.properties_.setString(6, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setExtendedDynamic(boolean bl) {
        Boolean bl2 = new Boolean(this.isExtendedDynamic());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(7, TRUE_);
        } else {
            this.properties_.setString(7, FALSE_);
        }
        this.changes_.firePropertyChange("extendedDynamic", bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "extendedDynamic: " + bl);
        }
    }

    public void setExtendedMetaData(boolean bl) {
        Boolean bl2 = new Boolean(this.isExtendedMetaData());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(48, TRUE_);
        } else {
            this.properties_.setString(48, FALSE_);
        }
        this.changes_.firePropertyChange("extendedMetaData", bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "extendedMetaData: " + bl);
        }
    }

    public void setExtendedMetadata(boolean bl) {
        this.setExtendedMetaData(bl);
    }

    public void setFullOpen(boolean bl) {
        Boolean bl2 = new Boolean(this.isFullOpen());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(45, TRUE_);
        } else {
            this.properties_.setString(45, FALSE_);
        }
        this.changes_.firePropertyChange("fullOpen", bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "fullOpen: " + bl);
        }
    }

    public void setHoldInputLocators(boolean bl) {
        String string = "holdInputLocators";
        Boolean bl2 = new Boolean(this.isHoldInputLocators());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(62, TRUE_);
        } else {
            this.properties_.setString(62, FALSE_);
        }
        this.changes_.firePropertyChange(string, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + bl);
        }
    }

    public void setHoldStatements(boolean bl) {
        String string = "holdStatements";
        Boolean bl2 = new Boolean(this.isHoldStatements());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(63, TRUE_);
        } else {
            this.properties_.setString(63, FALSE_);
        }
        this.changes_.firePropertyChange(string, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + bl);
        }
    }

    public void setLazyClose(boolean bl) {
        Boolean bl2 = new Boolean(this.isLazyClose());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(40, TRUE_);
        } else {
            this.properties_.setString(40, FALSE_);
        }
        this.changes_.firePropertyChange("lazyClose", bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "lazyClose: " + bl);
        }
    }

    public void setLibraries(String string) {
        String string2 = "libraries";
        if (string == null) {
            throw new NullPointerException("libraries");
        }
        String string3 = this.getLibraries();
        this.properties_.setString(8, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setLobThreshold(int n) {
        String string = "threshold";
        if (n < 0 || n > 0x1000000) {
            throw new ExtendedIllegalArgumentException(string, 4);
        }
        Integer n2 = new Integer(this.getLobThreshold());
        Integer n3 = new Integer(n);
        this.properties_.setString(31, new Integer(n).toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.setSoTimeout(n * 1000);
        String string = "loginTimeout";
        Integer n2 = new Integer(this.getLoginTimeout());
        Integer n3 = new Integer(n);
        this.properties_.setString(58, n3.toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        String string = "writer";
        PrintWriter printWriter2 = this.getLogWriter();
        this.writer_ = printWriter;
        this.changes_.firePropertyChange(string, printWriter2, printWriter);
        if (printWriter == null) {
            this.log_ = null;
            return;
        }
        this.log_ = new EventLog(printWriter);
    }

    public void setMetaDataSource(int n) {
        String string = "metaDataSource";
        Integer n2 = new Integer(this.getMetaDataSource());
        Integer n3 = new Integer(n);
        this.properties_.setString(72, n3.toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public void setMetadataSource(int n) {
        this.setMetaDataSource(n);
    }

    public void setNaming(String string) {
        String string2 = "naming";
        if (string == null) {
            throw new NullPointerException("naming");
        }
        this.validateProperty(string2, string, 9);
        String string3 = this.getNaming();
        this.properties_.setString(9, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setPackage(String string) {
        String string2 = "packageName";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        String string3 = this.getPackage();
        this.properties_.setString(10, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setPackageAdd(boolean bl) {
        Boolean bl2 = new Boolean(this.isPackageAdd());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(11, TRUE_);
        } else {
            this.properties_.setString(11, FALSE_);
        }
        this.changes_.firePropertyChange("packageAdd", bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "packageAdd: " + bl);
        }
    }

    public void setPackageCache(boolean bl) {
        Boolean bl2 = new Boolean(this.isPackageCache());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(12, TRUE_);
        } else {
            this.properties_.setString(12, FALSE_);
        }
        this.changes_.firePropertyChange("packageCache", bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "packageCache: " + bl);
        }
    }

    public void setPackageClear(boolean bl) {
    }

    public void setPackageCriteria(String string) {
        String string2 = "packageCriteria";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateProperty(string2, string, 30);
        String string3 = this.getPackageCriteria();
        this.properties_.setString(30, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setPackageError(String string) {
        String string2 = "packageError";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateProperty(string2, string, 14);
        String string3 = this.getPackageError();
        this.properties_.setString(14, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setPackageLibrary(String string) {
        String string2 = "packageLibrary";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        String string3 = this.getPackageLibrary();
        this.properties_.setString(15, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setPassword(String string) {
        this.as400_.setPassword(string);
        this.serialPWBytes_ = AS400JDBCDataSource.xpwConfuse(string);
        this.log(ResourceBundleLoader.getText("AS400_JDBC_DS_PASSWORD_SET"));
    }

    public void setPrefetch(boolean bl) {
        Boolean bl2 = new Boolean(this.isPrefetch());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(17, TRUE_);
        } else {
            this.properties_.setString(17, FALSE_);
        }
        this.changes_.firePropertyChange("prefetch", bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "prefetch: " + bl);
        }
    }

    public void setPrompt(boolean bl) {
        Boolean bl2 = new Boolean(this.isPrompt());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(18, TRUE_);
        } else {
            this.properties_.setString(18, FALSE_);
        }
        try {
            this.as400_.setGuiAvailable(bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.changes_.firePropertyChange("prompt", bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "prompt: " + bl);
        }
    }

    public void setProperties(String string) {
        string = "jdbc:as400://dummyhost;" + string;
        JDDataSourceURL jDDataSourceURL = new JDDataSourceURL(string);
        Properties properties = jDDataSourceURL.getProperties();
        this.setProperties(properties);
    }

    public void setProperties(Properties properties) {
        if (JDProperties.isTraceSet(properties, null) == "TRUE") {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
        } else if (JDProperties.isTraceSet(properties, null) == "FALSE" && JDTrace.isTraceOn()) {
            JDTrace.setTraceOn(false);
        }
        if (JDProperties.isToolboxTraceSet(properties, null) == "datastream") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDatastreamOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "diagnostic") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDiagnosticOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "error") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceErrorOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "information") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceInformationOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "warning") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceWarningOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "conversion") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceConversionOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "proxy") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceProxyOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "pcml") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTracePCMLOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "jdbc") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceJDBCOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "all") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceAllOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "thread") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceThreadOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "none" && Trace.isTraceOn()) {
            Trace.setTraceOn(false);
        }
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            int n = JDProperties.getPropertyIndex(string);
            if (n == 47) {
                this.setDatabaseName(string2);
                continue;
            }
            if (n == 29) {
                this.setUser(string2);
                continue;
            }
            if (n == 16) {
                this.setPassword(this.properties_.getString(16));
                continue;
            }
            if (n == 32) {
                this.setSecure(string2.equals(TRUE_));
                continue;
            }
            if (n == 67) {
                this.setKeepAlive(string2.equals(TRUE_));
                continue;
            }
            if (n == 68) {
                this.setReceiveBufferSize(Integer.parseInt(string2));
                continue;
            }
            if (n == 69) {
                this.setSendBufferSize(Integer.parseInt(string2));
                continue;
            }
            if (n == 18) {
                this.setPrompt(string2.equals(TRUE_));
                continue;
            }
            if (n == 43) {
                if (!JDTrace.isTraceOn()) continue;
                JDTrace.logInformation(this, "Property: " + string + " can only be changed in AS400JDBCDataSource constructor");
                continue;
            }
            if (n == 44) {
                if (!JDTrace.isTraceOn()) continue;
                JDTrace.logInformation(this, "Property: " + string + " can only be changed in AS400JDBCDataSource constructor");
                continue;
            }
            if (n == -1) continue;
            this.properties_.setString(n, string2);
        }
    }

    public void setProxyServer(String string) {
        String string2 = "proxyServer";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        String string3 = this.getProxyServer();
        this.properties_.setString(34, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setRemarks(String string) {
        String string2 = "remarks";
        if (string == null) {
            throw new NullPointerException(string);
        }
        this.validateProperty(string2, string, 19);
        String string3 = this.getRemarks();
        this.properties_.setString(19, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setRollbackCursorHold(boolean bl) {
        String string = "rollbackCursorHold";
        Boolean bl2 = new Boolean(this.isRollbackCursorHold());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(64, TRUE_);
        } else {
            this.properties_.setString(64, FALSE_);
        }
        this.changes_.firePropertyChange(string, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + bl);
        }
    }

    public void setSecondaryUrl(String string) {
        if (string == null) {
            throw new NullPointerException("url");
        }
        String string2 = this.getSecondaryUrl();
        this.properties_.setString(35, string);
        this.changes_.firePropertyChange("secondaryUrl", string2, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "secondaryUrl: " + string);
        }
    }

    public void setSecondaryURL(String string) {
        this.setSecondaryUrl(string);
    }

    public void setSecure(boolean bl) {
        Boolean bl2 = new Boolean(this.isSecure());
        Boolean bl3 = new Boolean(bl);
        if (!bl && this.isSecure_) {
            throw new ExtendedIllegalStateException(SECURE, 5);
        }
        this.isSecure_ = bl;
        if (bl) {
            this.properties_.setString(32, TRUE_);
        } else {
            this.properties_.setString(32, FALSE_);
        }
        this.changes_.firePropertyChange(SECURE, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "secure: " + bl);
        }
    }

    public void setServerName(String string) {
        String string2 = SERVER_NAME;
        if (string == null) {
            throw new NullPointerException(string2);
        }
        String string3 = this.getServerName();
        this.serialServerName_ = string;
        try {
            this.as400_.setSystemName(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.changes_.firePropertyChange(string2, string3, string);
        this.logProperty("server name", this.as400_.getSystemName());
    }

    public void setServerTraceCategories(int n) {
        String string = "serverTrace";
        Integer n2 = new Integer(this.getServerTraceCategories());
        Integer n3 = new Integer(n);
        this.properties_.setString(46, n3.toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public void setServerTrace(int n) {
        this.setServerTraceCategories(n);
    }

    public void setDriver(String string) {
        String string2 = "driver";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateProperty(string2, string, 41);
        String string3 = this.getDriver();
        this.properties_.setString(41, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setSavePasswordWhenSerialized(boolean bl) {
        String string = "savePasswordWhenSerialized";
        boolean bl2 = this.isSavePasswordWhenSerialized();
        boolean bl3 = bl;
        this.savePasswordWhenSerialized_ = bl;
        this.changes_.firePropertyChange(string, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "save password: " + bl);
        }
    }

    public void setSortLanguage(String string) {
        if (string == null) {
            throw new NullPointerException("language");
        }
        String string2 = this.getSortLanguage();
        this.properties_.setString(21, string);
        this.changes_.firePropertyChange("sortLanguage", string2, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "sortLanguage: " + string);
        }
    }

    public void setSortTable(String string) {
        if (string == null) {
            throw new NullPointerException("table");
        }
        String string2 = this.getSortTable();
        this.properties_.setString(22, string);
        this.changes_.firePropertyChange("sortTable", string2, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "sortTable: " + string);
        }
    }

    public void setSortWeight(String string) {
        String string2 = "sortWeight";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateProperty(string2, string, 23);
        String string3 = this.getSortWeight();
        this.properties_.setString(23, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setThreadUsed(boolean bl) {
        Boolean bl2 = new Boolean(this.isThreadUsed());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(38, TRUE_);
        } else {
            this.properties_.setString(38, FALSE_);
        }
        try {
            this.as400_.setThreadUsed(bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.changes_.firePropertyChange("threadUsed", bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "threadUsed: " + bl);
        }
    }

    public void setTimeFormat(String string) {
        String string2 = "timeFormat";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateProperty(string2, string, 24);
        String string3 = this.getTimeFormat();
        this.properties_.setString(24, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setTimeSeparator(String string) {
        String string2 = "timeSeparator";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateProperty(string2, string, 25);
        String string3 = this.getTimeSeparator();
        this.properties_.setString(25, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setTrace(boolean bl) {
        Boolean bl2 = new Boolean(this.isTrace());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(26, TRUE_);
        } else {
            this.properties_.setString(26, FALSE_);
        }
        this.changes_.firePropertyChange("trace", bl2, bl3);
        if (bl) {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
        } else {
            JDTrace.setTraceOn(false);
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "trace: " + bl);
        }
    }

    public void setTransactionIsolation(String string) {
        String string2 = "transactionIsolation";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateProperty(string2, string, 27);
        String string3 = this.getTransactionIsolation();
        this.properties_.setString(27, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setTranslateBinary(boolean bl) {
        String string = "translateBinary";
        Boolean bl2 = new Boolean(this.isTranslateBinary());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(28, TRUE_);
        } else {
            this.properties_.setString(28, FALSE_);
        }
        this.changes_.firePropertyChange(string, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + bl);
        }
    }

    public void setTranslateBoolean(boolean bl) {
        String string = "translateBoolean";
        Boolean bl2 = new Boolean(this.isTranslateBoolean());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(71, TRUE_);
        } else {
            this.properties_.setString(71, FALSE_);
        }
        this.changes_.firePropertyChange(string, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + bl);
        }
    }

    public void setUser(String string) {
        String string2 = "user";
        String string3 = this.getUser();
        this.serialUserName_ = string;
        try {
            this.as400_.setUserId(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.changes_.firePropertyChange(string2, string3, string);
        this.logProperty("user", this.as400_.getUserId());
    }

    public void setVariableFieldCompression(boolean bl) {
        String string = "variableFieldCompression";
        Boolean bl2 = new Boolean(this.isVariableFieldCompression());
        Boolean bl3 = new Boolean(bl);
        if (bl) {
            this.properties_.setString(65, TRUE_);
        } else {
            this.properties_.setString(65, FALSE_);
        }
        this.changes_.firePropertyChange(string, bl2, bl3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + bl);
        }
    }

    public boolean getKeepAlive() {
        return this.sockProps_.isKeepAlive();
    }

    public int getReceiveBufferSize() {
        return this.sockProps_.getReceiveBufferSize();
    }

    public int getSendBufferSize() {
        return this.sockProps_.getSendBufferSize();
    }

    public int getSoLinger() {
        return this.sockProps_.getSoLinger();
    }

    public int getSoTimeout() {
        return this.sockProps_.getSoTimeout();
    }

    public boolean getTcpNoDelay() {
        return this.sockProps_.isTcpNoDelay();
    }

    public void setKeepAlive(boolean bl) {
        this.sockProps_.setKeepAlive(bl);
    }

    public void setReceiveBufferSize(int n) {
        this.sockProps_.setReceiveBufferSize(n);
    }

    public void setSendBufferSize(int n) {
        this.sockProps_.setSendBufferSize(n);
    }

    public void setSoLinger(int n) {
        this.sockProps_.setSoLinger(n);
    }

    public void setSoTimeout(int n) {
        this.sockProps_.setSoTimeout(n);
    }

    public void setTcpNoDelay(boolean bl) {
        this.sockProps_.setTcpNoDelay(bl);
    }

    public int getPackageCCSID() {
        return this.properties_.getInt(51);
    }

    public int getPackageCcsid() {
        return this.getPackageCCSID();
    }

    public void setPackageCCSID(int n) {
        String string = "packageCCSID";
        Integer n2 = new Integer(this.getPackageCCSID());
        Integer n3 = new Integer(n);
        this.validateProperty(string, n3.toString(), 51);
        this.properties_.setString(51, n3.toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public void setPackageCcsid(int n) {
        this.setPackageCCSID(n);
    }

    public int getMinimumDivideScale() {
        return this.properties_.getInt(52);
    }

    public int getMaximumPrecision() {
        return this.properties_.getInt(53);
    }

    public int getMaximumScale() {
        return this.properties_.getInt(54);
    }

    public void setMinimumDivideScale(int n) {
        String string = "minimumDivideScale";
        Integer n2 = new Integer(this.getMinimumDivideScale());
        Integer n3 = new Integer(n);
        this.validateProperty(string, n3.toString(), 52);
        this.properties_.setString(52, n3.toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public void setMaximumPrecision(int n) {
        String string = "maximumPrecision";
        Integer n2 = new Integer(this.getMaximumPrecision());
        Integer n3 = new Integer(n);
        this.validateProperty(string, n3.toString(), 53);
        this.properties_.setString(53, n3.toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public void setMaximumScale(int n) {
        String string = "maximumScale";
        Integer n2 = new Integer(this.getMaximumScale());
        Integer n3 = new Integer(n);
        this.validateProperty(string, n3.toString(), 54);
        this.properties_.setString(54, n3.toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public String getTranslateHex() {
        return this.properties_.getString(55);
    }

    public void setTranslateHex(String string) {
        String string2 = "translateHex";
        String string3 = this.getTranslateHex();
        String string4 = string;
        this.validateProperty(string2, string4, 55);
        this.properties_.setString(55, string4);
        this.changes_.firePropertyChange(string2, string3, string4);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setQaqqiniLibrary(String string) {
        String string2 = "qaqqiniLibrary";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        String string3 = this.getQaqqiniLibrary();
        this.properties_.setString(57, string);
        this.changes_.firePropertyChange(string2, string3, string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setQaqqinilib(String string) {
        this.setQaqqiniLibrary(string);
    }

    public void setQueryOptimizeGoal(int n) {
        String string = "queryOptimizeGoal";
        Integer n2 = new Integer(this.getQueryOptimizeGoal());
        Integer n3 = new Integer(n);
        this.properties_.setString(66, n3.toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public void setQueryStorageLimit(int n) {
        String string = "queryStorageLimit";
        if (n < -1 || n > 2147352578) {
            throw new ExtendedIllegalArgumentException(string, 4);
        }
        Integer n2 = new Integer(this.getQueryStorageLimit());
        Integer n3 = new Integer(n);
        this.properties_.setString(73, n3.toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public void setXALooselyCoupledSupport(int n) {
        String string = "xaLooselyCoupledSupport";
        Integer n2 = new Integer(this.getXALooselyCoupledSupport());
        Integer n3 = new Integer(n);
        this.properties_.setString(70, n3.toString());
        this.changes_.firePropertyChange(string, n2, n3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string + ": " + n);
        }
    }

    public String getToolboxTraceCategory() {
        return this.properties_.getString(56);
    }

    public String getToolboxTrace() {
        return this.getToolboxTraceCategory();
    }

    public void setToolboxTraceCategory(String string) {
        String string2 = "toolboxTrace";
        String string3 = this.getToolboxTraceCategory();
        String string4 = string;
        this.validateProperty(string2, string4, 56);
        this.properties_.setString(56, string4);
        this.changes_.firePropertyChange(string2, string3, string4);
        if (!string.equals("") && !string.equals("none")) {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            if (string.equals("datastream")) {
                Trace.setTraceDatastreamOn(true);
            } else if (string.equals("diagnostic")) {
                Trace.setTraceDiagnosticOn(true);
            } else if (string.equals("error")) {
                Trace.setTraceErrorOn(true);
            } else if (string.equals("information")) {
                Trace.setTraceInformationOn(true);
            } else if (string.equals("warning")) {
                Trace.setTraceWarningOn(true);
            } else if (string.equals("conversion")) {
                Trace.setTraceConversionOn(true);
            } else if (string.equals("proxy")) {
                Trace.setTraceProxyOn(true);
            } else if (string.equals("pcml")) {
                Trace.setTracePCMLOn(true);
            } else if (string.equals("jdbc")) {
                Trace.setTraceJDBCOn(true);
            } else if (string.equals("all")) {
                Trace.setTraceAllOn(true);
            } else if (string.equals("thread")) {
                Trace.setTraceThreadOn(true);
            }
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setToolboxTrace(String string) {
        this.setToolboxTraceCategory(string);
    }

    private void validateProperty(String string, String string2, int n) {
        if (string2.length() != 0) {
            DriverPropertyInfo[] driverPropertyInfoArray = this.properties_.getInfo();
            String[] stringArray = driverPropertyInfoArray[n].choices;
            boolean bl = true;
            int n2 = 0;
            while (bl && n2 < stringArray.length) {
                if (string2.equalsIgnoreCase(stringArray[n2])) {
                    bl = false;
                    continue;
                }
                ++n2;
            }
            if (bl) {
                throw new ExtendedIllegalArgumentException(string, 2);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.savePasswordWhenSerialized_) {
            this.serialPWBytes_ = null;
            this.serialKeyRingPWBytes_ = null;
        }
        objectOutputStream.defaultWriteObject();
    }

    public String toString() {
        String string = this.getDataSourceName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static char[] xpwConfuse(String string) {
        Random random = new Random();
        byte[] byArray = new byte[18];
        random.nextBytes(byArray);
        char[] cArray = BinaryConverter.byteArrayToCharArray(byArray);
        byte[] byArray2 = new byte[14];
        random.nextBytes(byArray2);
        char[] cArray2 = BinaryConverter.byteArrayToCharArray(byArray2);
        char[] cArray3 = AS400JDBCDataSource.xencode(cArray, cArray2, string.toCharArray());
        char[] cArray4 = new char[string.length() + 16];
        System.arraycopy(cArray, 0, cArray4, 0, 9);
        System.arraycopy(cArray2, 0, cArray4, 9, 7);
        System.arraycopy(cArray3, 0, cArray4, 16, string.length());
        return cArray4;
    }

    private static String xpwDeconfuse(char[] cArray) {
        char[] cArray2 = new char[9];
        System.arraycopy(cArray, 0, cArray2, 0, 9);
        char[] cArray3 = new char[7];
        System.arraycopy(cArray, 9, cArray3, 0, 7);
        char[] cArray4 = new char[cArray.length - 16];
        System.arraycopy(cArray, 16, cArray4, 0, cArray.length - 16);
        return new String(AS400JDBCDataSource.xdecode(cArray2, cArray3, cArray4));
    }

    private static char[] xencode(char[] cArray, char[] cArray2, char[] cArray3) {
        int n;
        if (cArray3 == null) {
            return null;
        }
        int n2 = cArray3.length;
        char[] cArray4 = new char[n2];
        for (n = 0; n < n2; ++n) {
            cArray4[n] = (char)(cArray3[n] + cArray[n % 9]);
        }
        for (n = 0; n < n2; ++n) {
            cArray4[n] = (char)(cArray4[n] ^ cArray2[n % 7]);
        }
        return cArray4;
    }

    private static char[] xdecode(char[] cArray, char[] cArray2, char[] cArray3) {
        int n;
        int n2 = cArray3.length;
        char[] cArray4 = new char[n2];
        for (n = 0; n < n2; ++n) {
            cArray4[n] = (char)(cArray2[n % 7] ^ cArray3[n]);
        }
        for (n = 0; n < n2; ++n) {
            cArray4[n] = (char)(cArray4[n] - cArray[n % 9]);
        }
        return cArray4;
    }
}

