/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.reportwriter.pdfwriter;

import com.ibm.as400.util.reportwriter.pdfwriter.PDFCatalog;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFContentStream;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFCrossRefTable;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFExtendedFont;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFFont;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFFontCharWidthArray;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFFontDescriptor;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFFontDictionary;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFHeader;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFInfo;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFObject;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFPage;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFPages;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFXObject;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFXObjectDictionary;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PDFDocument {
    private PDFCatalog catalog_ = null;
    private PDFInfo info_ = null;
    private PDFFontDictionary fontDic_ = null;
    private PDFXObjectDictionary xobjectDic_ = null;
    Vector xobjectVector_ = null;
    private PDFPages pages_ = null;
    private int objCounter_ = 5;
    private PDFContentStream contents_ = null;
    private PDFPage currentPage_ = null;
    private PDFHeader header_ = new PDFHeader(1);
    private OutputStream outStream_ = null;
    private PageFormat pageFormat_ = null;
    private Hashtable xref = null;
    private Hashtable loadedImageResourceTable;
    private PDFCrossRefTable xrefTable_ = null;
    private boolean textModeOn_ = false;
    private int currentBytePosition_ = 0;

    public PDFDocument(OutputStream outputStream) {
        this.catalog_ = new PDFCatalog(2);
        this.pages_ = new PDFPages(3);
        this.fontDic_ = new PDFFontDictionary(4);
        this.xobjectVector_ = new Vector();
        this.xrefTable_ = new PDFCrossRefTable(0);
        this.loadedImageResourceTable = new Hashtable();
        this.catalog_.setPagesReference(3);
        this.outStream_ = outputStream;
        this.pageFormat_ = new PageFormat();
    }

    public PDFFont addFont(PDFExtendedFont pDFExtendedFont) {
        if (!this.fontDic_.contains(pDFExtendedFont)) {
            this.fontDic_.addFont(pDFExtendedFont, this.objCounter_);
            this.objCounter_ += 3;
            PDFFont pDFFont = this.fontDic_.getFont(pDFExtendedFont);
            this.currentPage_.addResource(pDFFont.getName(), pDFFont.getNumber(), 1);
            return pDFFont;
        }
        PDFFont pDFFont = this.fontDic_.getFont(pDFExtendedFont);
        this.currentPage_.addResource(pDFFont.getName(), pDFFont.getNumber(), 1);
        return pDFFont;
    }

    public PDFXObject addImage(Image image, String string) {
        PDFXObject pDFXObject = null;
        if (!this.loadedImageResourceTable.containsKey(string)) {
            try {
                pDFXObject = new PDFXObject(this.objCounter_, image);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.xobjectVector_.addElement(pDFXObject);
            ++this.objCounter_;
            this.loadedImageResourceTable.put(string, pDFXObject);
        } else {
            pDFXObject = (PDFXObject)this.loadedImageResourceTable.get(string);
        }
        this.currentPage_.addResource(pDFXObject.getName(), pDFXObject.getNumber(), 2);
        return pDFXObject;
    }

    public void startDocument() {
    }

    public void endDocument() {
        this.xrefTable_.setNumber(this.objCounter_);
        ++this.objCounter_;
    }

    public PDFContentStream startPage(int n, int n2) {
        this.currentPage_ = new PDFPage(this.objCounter_);
        this.currentPage_.setParentRef(this.pages_.getNumber());
        this.contents_ = new PDFContentStream(this.objCounter_ + 1);
        this.objCounter_ += 2;
        return this.contents_;
    }

    public void startTextMode() {
        try {
            if (!this.textModeOn_) {
                this.contents_.write("BT\r\n");
                this.textModeOn_ = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void endPage() {
        this.endTextMode();
        try {
            this.contents_.write("\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.currentPage_.addContent(this.contents_);
        this.pages_.addPage(this.currentPage_);
    }

    public void endTextMode() {
        try {
            if (this.textModeOn_) {
                this.contents_.write("ET\r\n");
                this.textModeOn_ = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write() {
        Object var2_1 = null;
        try {
            PDFObject pDFObject;
            this.outStream_.write(this.header_.toPDF().getBytes());
            this.xrefTable_.addReference(this.header_.getNumber(), 17);
            this.currentBytePosition_ += this.header_.getByteCount();
            this.outStream_.write(this.catalog_.toPDF().getBytes());
            this.xrefTable_.addReference(this.catalog_.getNumber(), this.currentBytePosition_);
            this.currentBytePosition_ += this.catalog_.getByteCount();
            this.outStream_.write(this.pages_.toPDF().getBytes());
            this.xrefTable_.addReference(this.pages_.getNumber(), this.currentBytePosition_);
            this.currentBytePosition_ += this.pages_.getByteCount();
            this.outStream_.write(this.fontDic_.toPDF().getBytes());
            this.xrefTable_.addReference(this.fontDic_.getNumber(), this.currentBytePosition_);
            this.currentBytePosition_ += this.fontDic_.getByteCount();
            Enumeration enumeration = this.fontDic_.getFonts();
            while (enumeration.hasMoreElements()) {
                PDFFont pDFFont = (PDFFont)enumeration.nextElement();
                this.outStream_.write(pDFFont.toPDF().getBytes());
                this.xrefTable_.addReference(pDFFont.getNumber(), this.currentBytePosition_);
                this.currentBytePosition_ += pDFFont.getByteCount();
                PDFFontCharWidthArray pDFFontCharWidthArray = pDFFont.getFontCharWidthArray();
                this.outStream_.write(pDFFontCharWidthArray.toPDF().getBytes());
                this.xrefTable_.addReference(pDFFontCharWidthArray.getNumber(), this.currentBytePosition_);
                this.currentBytePosition_ += pDFFontCharWidthArray.getByteCount();
                pDFObject = pDFFont.getFontDescriptor();
                this.outStream_.write(((PDFFontDescriptor)pDFObject).toPDF().getBytes());
                this.xrefTable_.addReference(pDFObject.getNumber(), this.currentBytePosition_);
                this.currentBytePosition_ += pDFObject.getByteCount();
            }
            int n = 0;
            while (n < this.pages_.size()) {
                Object object;
                pDFObject = this.pages_.pageAt(n);
                this.outStream_.write(((PDFPage)pDFObject).toPDF().getBytes());
                this.xrefTable_.addReference(pDFObject.getNumber(), this.currentBytePosition_);
                this.currentBytePosition_ += pDFObject.getByteCount();
                Enumeration enumeration2 = this.xobjectVector_.elements();
                while (enumeration2.hasMoreElements()) {
                    object = (PDFXObject)enumeration2.nextElement();
                    this.outStream_.write(((PDFXObject)object).toPDF().getBytes());
                    this.xrefTable_.addReference(((PDFObject)object).getNumber(), this.currentBytePosition_);
                    this.currentBytePosition_ += ((PDFObject)object).getByteCount();
                }
                object = ((PDFPage)pDFObject).getContents();
                while (object.hasMoreElements()) {
                    PDFObject pDFObject2 = (PDFObject)object.nextElement();
                    this.outStream_.write(pDFObject2.toPDF().getBytes());
                    this.xrefTable_.addReference(pDFObject2.getNumber(), this.currentBytePosition_);
                    this.currentBytePosition_ += pDFObject2.getByteCount();
                }
                ++n;
            }
            this.xrefTable_.setStartRef(this.currentBytePosition_);
            this.outStream_.write(this.xrefTable_.toPDF().getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

