/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.reportwriter.fonts;

import com.ibm.as400.util.reportwriter.fonts.AFMChar;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class AFMFont {
    private static final boolean _DEBUG = true;
    private String fontName_ = null;
    private String comment_ = null;
    private String fullName_ = null;
    private String familyName_ = null;
    private String weight_ = null;
    private String version_ = null;
    private String notice_ = null;
    private String encodingScheme_ = null;
    private int mappingScheme_ = 0;
    private int escChar_ = 0;
    private String characterSet_ = null;
    private int characters_ = 0;
    private boolean isBaseFont_ = false;
    private String bBoxllx_ = "0";
    private String bBoxlly_ = "0";
    private String bBoxurx_ = "0";
    private String bBoxury_ = "0";
    private String vVectorx_ = "0";
    private String vVectory_ = "0";
    private boolean isFixedV_ = false;
    private boolean isCIDFont_ = false;
    private String capHeight_ = "0";
    private String xHeight_ = "0";
    private String ascender_ = "0";
    private String descender_ = "0";
    private String stdHW_ = "0";
    private String stdVW_ = "0";
    private String metricSets_ = "0";
    private int metricSets_int = 0;
    private String underlinePosition_ = "0";
    private String underlineThickness_ = "0";
    private String italicAngle_ = "0";
    private String WX_ = "0";
    private String WY_ = "0";
    private boolean isFixedPitch_ = false;
    private String underlinePosition1_ = "0";
    private String underlineThickness1_ = "0";
    private String italicAngle1_ = "0";
    private String W1X_ = "0";
    private String W1Y_ = "0";
    private boolean isFixedPitch1_ = false;
    private int defaultChar = 32;
    private double units_per_point = 1000.0;
    private AFMChar[] charMetrics_;
    private Vector fontBBox_;
    String nextLine_ = null;
    StringTokenizer tokenizer_ = null;
    BufferedReader reader_ = null;
    private int defaultHeight_ = 10;
    private int defaultWidth_ = 10;
    static String fontDir = "/com/ibm/as400/util/reportwriter/fonts/";

    public AFMFont(String string) throws IOException {
        String string2 = string + ".afm";
        try {
            this.reader_ = new BufferedReader(this.loadFontMetricsFile(fontDir + string2));
            this.nextLine_ = this.reader_.readLine();
            this.tokenizer_ = new StringTokenizer(this.nextLine_);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("AFM file not found.");
        }
        this.parse();
        this.reader_.close();
    }

    private String AFMGlobalFontInfoParse() throws IOException {
        this.fontBBox_ = new Vector();
        String string = this.getNextWord();
        while (string != null && !string.toUpperCase().startsWith("START") && !string.toUpperCase().startsWith("END")) {
            if (string.equals("FontName")) {
                this.fontName_ = this.getNextWord();
            } else if (string.equals("Comment")) {
                this.comment_ = this.getLine();
            } else if (string.equals("FullName")) {
                this.fullName_ = this.getLine();
            } else if (string.equals("FamilyName")) {
                this.familyName_ = this.getLine();
            } else if (string.equals("Weight")) {
                this.weight_ = this.getNextWord();
            } else if (string.equals("FontBBox")) {
                this.bBoxllx_ = this.getNextWord();
                this.bBoxlly_ = this.getNextWord();
                this.bBoxurx_ = this.getNextWord();
                this.bBoxury_ = this.getNextWord();
                this.fontBBox_.addElement(this.bBoxllx_);
                this.fontBBox_.addElement(this.bBoxlly_);
                this.fontBBox_.addElement(this.bBoxurx_);
                this.fontBBox_.addElement(this.bBoxury_);
                this.defaultWidth_ = (int)(Double.parseDouble(this.bBoxurx_) - Double.parseDouble(this.bBoxllx_));
                this.defaultHeight_ = (int)(Double.parseDouble(this.bBoxury_) - Double.parseDouble(this.bBoxlly_));
            } else if (string.equals("Version")) {
                this.version_ = this.getLine();
            } else if (string.equals("Notice")) {
                this.notice_ = this.getLine();
            } else if (string.equals("EncodingScheme")) {
                this.encodingScheme_ = this.getNextWord();
            } else if (string.equals("MappingScheme")) {
                this.mappingScheme_ = Integer.parseInt(this.getNextWord());
            } else if (string.equals("EscChar")) {
                this.escChar_ = Integer.parseInt(this.getNextWord());
            } else if (string.equals("CharacterSet")) {
                this.characterSet_ = this.getNextWord();
            } else if (string.equals("Characters")) {
                this.characters_ = Integer.parseInt(this.getNextWord());
            } else if (string.equals("IsBaseFont")) {
                this.isBaseFont_ = this.getNextWord().equals("true");
            } else if (string.equals("VVector")) {
                this.vVectorx_ = this.getNextWord();
                this.vVectory_ = this.getNextWord();
            } else if (string.equals("IsFixedV")) {
                this.isFixedV_ = this.getNextWord().equals("true");
            } else if (string.equals("IsCIDFont")) {
                this.isCIDFont_ = this.getNextWord().equals("true");
            } else if (string.equals("CapHeight")) {
                this.capHeight_ = this.getNextWord();
            } else if (string.equals("XHeight")) {
                this.xHeight_ = this.getNextWord();
            } else if (string.equals("Ascender")) {
                this.ascender_ = this.getNextWord();
            } else if (string.equals("Descender")) {
                this.descender_ = this.getNextWord();
            } else if (string.equals("StdHW")) {
                this.stdHW_ = this.getNextWord();
            } else if (string.equals("StdVW")) {
                this.stdVW_ = this.getNextWord();
            } else if (string.equals("MetricSets")) {
                this.metricSets_ = this.getNextWord();
                this.metricSets_int = Integer.parseInt(this.metricSets_);
            } else if (this.metricSets_int == 0) {
                if (string.equals("UnderlinePosition")) {
                    this.underlinePosition_ = this.getNextWord();
                } else if (string.equals("UnderlineThickness")) {
                    this.underlineThickness_ = this.getNextWord();
                } else if (string.equals("ItalicAngle")) {
                    this.italicAngle_ = this.getNextWord();
                } else if (string.equals("CharWidth")) {
                    this.WX_ = this.getNextWord();
                    this.WY_ = this.getNextWord();
                } else if (string.equals("IsFixedPitch")) {
                    this.isFixedPitch_ = this.getNextWord().equals("true");
                }
            }
            string = this.getNextWord();
        }
        if (string == null) {
            throw new IOException("Global Font Information parse error.");
        }
        return string;
    }

    private void AFMCharMetricsParse() throws IOException {
        String string = this.getNextWord();
        if (string != null) {
            this.characters_ = Integer.parseInt(string);
            this.charMetrics_ = new AFMChar[this.characters_];
            string = this.getNextWord();
        }
        int n = 0;
        while (n < this.characters_ && string != null && !string.equals("EndCharMetrics")) {
            this.charMetrics_[n] = new AFMChar();
            if (string.equals("C")) {
                this.charMetrics_[n].setCharCode(Integer.parseInt(this.getNextWord()));
            } else if (string.equals("CH")) {
                this.charMetrics_[n].setCharCode(this.stringHexToInt(this.getNextWord()));
            }
            this.getNextWord();
            string = this.getNextWord();
            while (!(string == null || string.equals("C") || string.equals("CH") || string.equals("EndCharMetrics"))) {
                String string2;
                String string3;
                if (string.equals("WX") || string.equals("W0X")) {
                    this.charMetrics_[n].setWX(this.getNextWord());
                } else if (string.equals("W1X")) {
                    this.charMetrics_[n].setW1X(this.getNextWord());
                } else if (string.equals("WY") || string.equals("W0Y")) {
                    this.charMetrics_[n].setWY(this.getNextWord());
                } else if (string.equals("W1Y")) {
                    this.charMetrics_[n].setW1Y(this.getNextWord());
                } else if (string.equals("W") || string.equals("W0")) {
                    string3 = this.getNextWord();
                    string2 = this.getNextWord();
                    this.charMetrics_[n].setWX(string3);
                    this.charMetrics_[n].setWY(string2);
                } else if (string.equals("W1")) {
                    string3 = this.getNextWord();
                    string2 = this.getNextWord();
                    this.charMetrics_[n].setW1X(string3);
                    this.charMetrics_[n].setW1Y(string2);
                } else if (string.equals("VV")) {
                    string3 = this.getNextWord();
                    string2 = this.getNextWord();
                    this.charMetrics_[n].setVV(string3, string2);
                } else if (string.equals("N")) {
                    this.charMetrics_[n].setCharName(this.getNextWord());
                } else if (string.equals("B")) {
                    string3 = this.getNextWord();
                    string2 = this.getNextWord();
                    String string4 = this.getNextWord();
                    String string5 = this.getNextWord();
                    this.charMetrics_[n].setBoundBox(string3, string2, string4, string5);
                } else if (string.equals("L")) {
                    string3 = this.getNextWord();
                    string2 = this.getNextWord();
                    this.charMetrics_[n].addLigature(string3, string2);
                }
                this.getNextWord();
                string = this.getNextWord();
            }
            ++n;
        }
        if (string == null) {
            throw new IOException("Character Metrics parse error.");
        }
    }

    private void AFMCompositesParse() throws IOException {
        String string = this.getNextWord();
        while (string != null && !string.equals("EndComposites")) {
            string = this.getNextWord();
        }
        if (string == null) {
            throw new IOException("Composite Character Data parse error.");
        }
    }

    private void AFMDirectionParse() throws IOException {
        String string;
        String string2;
        String string3 = this.getNextWord();
        int n = 0;
        if (string3 != null) {
            n = Integer.parseInt(this.getNextWord());
        }
        if (n == 0) {
            string3 = this.getNextWord();
            while (string3 != null && !string3.equals("EndDirection")) {
                if (string3.equals("UnderlinePosition")) {
                    this.underlinePosition_ = string3 = this.getNextWord();
                } else if (string3.equals("UnderlineThickness")) {
                    this.underlineThickness_ = string3 = this.getNextWord();
                } else if (string3.equals("ItalicAngle")) {
                    this.italicAngle_ = string3 = this.getNextWord();
                } else if (string3.equals("CharWidth")) {
                    string2 = this.getNextWord();
                    string = this.getNextWord();
                    this.WX_ = string2;
                    this.WY_ = string;
                } else if (string3.equals("IsFixedPitch")) {
                    boolean bl;
                    this.isFixedPitch_ = bl = this.getNextWord().equals("true");
                } else {
                    throw new IOException("Bad File Format");
                }
                string3 = this.getNextWord();
            }
        }
        if (n == 1) {
            string3 = this.getNextWord();
            while (string3 != null && !string3.equals("EndDirection")) {
                if (string3.equals("UnderlinePosition")) {
                    this.underlinePosition1_ = string3 = this.getNextWord();
                } else if (string3.equals("UnderlineThickness")) {
                    this.underlineThickness1_ = string3 = this.getNextWord();
                } else if (string3.equals("ItalicAngle")) {
                    this.italicAngle1_ = string3 = this.getNextWord();
                } else if (string3.equals("CharWidth")) {
                    string2 = this.getNextWord();
                    string = this.getNextWord();
                    this.W1X_ = string2;
                    this.W1Y_ = string;
                } else if (string3.equals("IsFixedPitch")) {
                    boolean bl;
                    this.isFixedPitch1_ = bl = this.getNextWord().equals("true");
                } else {
                    throw new IOException("Bad File Format");
                }
                string3 = this.getNextWord();
            }
        }
        if (n == 0 || n == 2) {
            string3 = this.getNextWord();
            while (string3 != null && !string3.equals("EndDirection")) {
                if (string3.equals("UnderlinePosition")) {
                    this.underlinePosition_ = string3 = this.getNextWord();
                    this.underlinePosition1_ = string3;
                } else if (string3.equals("UnderlineThickness")) {
                    this.underlineThickness_ = string3 = this.getNextWord();
                    this.underlineThickness1_ = string3;
                } else if (string3.equals("ItalicAngle")) {
                    this.italicAngle_ = string3 = this.getNextWord();
                    this.italicAngle1_ = string3;
                } else if (string3.equals("CharWidth")) {
                    string2 = this.getNextWord();
                    string = this.getNextWord();
                    this.WX_ = string2;
                    this.WY_ = string;
                    this.W1X_ = string2;
                    this.W1Y_ = string;
                } else if (string3.equals("IsFixedPitch")) {
                    boolean bl;
                    this.isFixedPitch_ = bl = this.getNextWord().equals("true");
                    this.isFixedPitch1_ = bl;
                } else {
                    throw new IOException("Bad File Format");
                }
                string3 = this.getNextWord();
            }
        } else {
            throw new IOException("Writing direction parse error.");
        }
        if (string3 == null) {
            throw new IOException("Writing direction parse error.");
        }
    }

    private void AFMKernDataParse() throws IOException {
        String string = this.getNextWord();
        while (string != null && !string.equals("EndKernData")) {
            string = this.getNextWord();
        }
        if (string == null) {
            throw new IOException("Kerning Data parse error.");
        }
    }

    public AFMChar getAFMCharacter(int n) {
        int n2 = 0;
        n2 = 0;
        while (n2 < this.characters_) {
            if (this.charMetrics_[n2].getCharCode() == n) break;
            ++n2;
        }
        if (n2 != this.characters_) {
            return this.charMetrics_[n2];
        }
        return this.charMetrics_[this.defaultChar];
    }

    public double getCharacterHeight(int n) {
        AFMChar aFMChar = this.getAFMCharacter(n);
        if (aFMChar != null) {
            return this.stringToDouble(aFMChar.getWY());
        }
        return (double)this.defaultHeight_ / this.units_per_point;
    }

    public double getCharacterWidth(int n) {
        AFMChar aFMChar = this.getAFMCharacter(n);
        if (aFMChar != null) {
            return this.stringToDouble(aFMChar.getWX()) / this.units_per_point;
        }
        return (double)this.defaultWidth_ / this.units_per_point;
    }

    public String getCharacterWidthMetric(int n) {
        AFMChar aFMChar = this.getAFMCharacter(n);
        if (aFMChar != null) {
            return aFMChar.getWX();
        }
        return new String("0");
    }

    public boolean getFixedPitch() {
        return this.isFixedPitch_;
    }

    public String getFontFamily() {
        return this.familyName_;
    }

    public double getAscent() {
        return this.stringToDouble(this.ascender_) / this.units_per_point;
    }

    public String getAscentMetric() {
        return this.ascender_;
    }

    public String getFontName() {
        return this.fontName_;
    }

    public double getMaxHeight() {
        return (this.stringToDouble(this.bBoxury_) - this.stringToDouble(this.bBoxlly_)) / this.units_per_point;
    }

    public double getMaxWidth() {
        return (double)this.defaultWidth_ / this.units_per_point;
    }

    public double getDescent() {
        return this.stringToDouble(this.descender_) / this.units_per_point;
    }

    public String getDescentMetric() {
        return this.descender_;
    }

    private String getLine() throws IOException {
        String string = "";
        while (this.tokenizer_.hasMoreTokens()) {
            string = string + this.tokenizer_.nextToken() + " ";
        }
        if (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        this.nextLine_ = this.reader_.readLine();
        if (this.nextLine_ != null) {
            this.tokenizer_ = new StringTokenizer(this.nextLine_);
        }
        return string;
    }

    private String getNextWord() throws IOException {
        String string = null;
        boolean bl = false;
        while (this.nextLine_ != null && !bl) {
            if (this.tokenizer_.hasMoreTokens()) {
                string = this.tokenizer_.nextToken();
                bl = true;
                continue;
            }
            this.nextLine_ = this.reader_.readLine();
            if (this.nextLine_ == null) continue;
            this.tokenizer_ = new StringTokenizer(this.nextLine_);
        }
        return string;
    }

    public String getWeight() {
        return this.weight_;
    }

    public Vector getVVector() {
        Vector<Double> vector = new Vector<Double>();
        vector.addElement(new Double(this.stringToDouble(this.vVectorx_)));
        vector.addElement(new Double(this.stringToDouble(this.vVectory_)));
        return vector;
    }

    public double getStdHW() {
        return this.stringToDouble(this.stdHW_);
    }

    public double getStdVW() {
        return this.stringToDouble(this.stdVW_);
    }

    public int getMetricSets() {
        return this.metricSets_int;
    }

    public Vector getFontBBoxMetric() {
        return this.fontBBox_;
    }

    public String getCapHeightMetric() {
        return this.capHeight_;
    }

    public String getItalicAngleMetric_0() {
        return this.italicAngle_;
    }

    public String getItalicAngleMetric_1() {
        return this.italicAngle1_;
    }

    private void parse() throws EOFException, IOException {
        String string = this.getNextWord();
        if (string == null || !string.equals("StartFontMetrics")) {
            throw new IOException("Error::StartFontMetrics keyword expected");
        }
        string = this.AFMGlobalFontInfoParse();
        while (string != null && !string.equals("EndFontMetrics")) {
            if (string.equals("StartCharMetrics")) {
                this.AFMCharMetricsParse();
            } else if (string.equals("StartKernData")) {
                this.AFMKernDataParse();
            } else if (string.equals("StartComposites")) {
                this.AFMCompositesParse();
            } else if (string.equals("StartDirection")) {
                this.AFMDirectionParse();
            }
            string = this.getNextWord();
        }
        if (string == null) {
            throw new IOException("Bad File format.");
        }
    }

    private int stringHexToInt(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length() - 2;
        int n4 = 1;
        while (n4 <= n3) {
            char c = Character.toUpperCase(string.charAt(n4));
            n2 = c >= 'A' ? c - 65 + 10 : c - 48;
            n = 16 * n + n2;
            ++n4;
        }
        System.out.println(":: stringHexToInt ::");
        System.out.println("String to convert: " + string);
        System.out.println("Converted        : " + n);
        return n;
    }

    private double stringToDouble(String string) {
        return Double.valueOf(string);
    }

    public InputStreamReader loadFontMetricsFile(String string) {
        InputStreamReader inputStreamReader = null;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            inputStreamReader = new InputStreamReader(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return inputStreamReader;
    }

    private void dumpData() {
        System.out.println("FontName:    " + this.fontName_);
        System.out.println("FullName:    " + this.fullName_);
        System.out.println("FamilyName:  " + this.familyName_);
        System.out.println("Weight:      " + this.weight_);
        System.out.println("Version:     " + this.version_);
        System.out.println("Notice:      " + this.notice_);
        System.out.println("EncodingScheme: " + this.encodingScheme_);
        System.out.println("MappingScheme:  " + this.mappingScheme_);
        System.out.println("EscChar:     " + this.escChar_);
        System.out.println("CharacterSet:" + this.characterSet_);
        System.out.println("Characters:  " + this.characters_);
        System.out.println("isBaseFont:  " + this.isBaseFont_);
        System.out.println("VVector(X):  " + this.vVectorx_);
        System.out.println("VVector(Y):  " + this.vVectory_);
        System.out.println("isFixedV:    " + this.isFixedV_);
        System.out.println("isCIDFont:   " + this.isCIDFont_);
        System.out.println("CapHeight:   " + this.capHeight_);
        System.out.println("XHeight:     " + this.xHeight_);
        System.out.println("Ascender:    " + this.ascender_);
        System.out.println("Descender:   " + this.descender_);
        System.out.println("StdHW:       " + this.stdHW_);
        System.out.println("StdVW:       " + this.stdVW_);
        System.out.println("MetricsSets: " + this.metricSets_);
        System.out.println("UnderlinePosition:  " + this.underlinePosition_);
        System.out.println("UnderlineThickness: " + this.underlineThickness_);
        System.out.println("ItalicAngle :" + this.italicAngle_);
        System.out.println("CharWidth(x):" + this.WX_);
        System.out.println("CharWidth(y):" + this.WY_);
        System.out.println("IsFixedPitch:" + this.isFixedPitch_);
        System.out.println("UnderlinePosition1:  " + this.underlinePosition1_);
        System.out.println("UnderlineThickness1: " + this.underlineThickness1_);
        System.out.println("ItalicAngle1 :" + this.italicAngle1_);
        System.out.println("CharWidth(x)1:" + this.W1X_);
        System.out.println("CharWidth(y)1:" + this.W1Y_);
        System.out.println("IsFixedPitch1:" + this.isFixedPitch1_);
    }
}

