/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spinner;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

class BasicArrowButton
extends JButton
implements SwingConstants {
    protected int arrowDirection;
    protected Color arrowColor;

    public BasicArrowButton() {
        this(1, Color.black);
    }

    public BasicArrowButton(int n, Color color) {
        this.setArrowDirection(n);
        this.setArrowColor(color);
        this.setBackground(UIManager.getColor("control"));
    }

    public void fireStateChanged() {
        super.fireStateChanged();
    }

    public Color getArrowColor() {
        return this.arrowColor;
    }

    public int getArrowDirection() {
        return this.arrowDirection;
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Color color = graphics.getColor();
        boolean bl = this.getModel().isPressed();
        boolean bl2 = this.isEnabled();
        graphics.setColor(this.getBackground());
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        if (bl) {
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        } else {
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(1, 0, n - 2, 0);
            graphics.setColor(UIManager.getColor("controlHighlight"));
            graphics.drawLine(1, 1, 1, n2 - 3);
            graphics.drawLine(2, 1, n - 3, 1);
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 3);
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, n2 - 1, n - 1, 0);
        }
        if (n2 < 5 || n < 5) {
            graphics.setColor(color);
            return;
        }
        if (bl) {
            graphics.translate(1, 1);
        }
        int n3 = Math.min((n2 - 4) / 3, (n - 4) / 3);
        n3 = Math.max(n3, 2);
        this.paintTriangle(graphics, (n - n3) / 2, (n2 - n3) / 2, n3, this.arrowDirection, this.arrowColor, bl2);
        if (bl) {
            graphics.translate(-1, -1);
        }
        graphics.setColor(color);
    }

    private void paintTriangle(Graphics graphics, int n, int n2, int n3, int n4, Color color, boolean bl) {
        Color color2 = graphics.getColor();
        int n5 = 0;
        n3 = Math.max(n3, 3);
        int n6 = n3 / 2;
        graphics.translate(n, n2);
        if (bl) {
            graphics.setColor(UIManager.getColor("controlDKShadow"));
        } else {
            graphics.setColor(UIManager.getColor("controlShadow"));
        }
        switch (n4) {
            case 1: {
                graphics.setColor(color);
                int n7 = 0;
                while (n7 < n3) {
                    graphics.drawLine(n6 - n7, n7, n6 + n7, n7);
                    ++n7;
                }
                if (bl) break;
                graphics.setColor(UIManager.getColor("controlHighlight"));
                graphics.drawLine(n6 - n7 + 2, n7, n6 + n7, n7);
                break;
            }
            case 5: {
                int n8;
                if (!bl) {
                    graphics.translate(1, 1);
                    graphics.setColor(UIManager.getColor("controlHighlight"));
                    n8 = n3 - 1;
                    while (n8 >= 0) {
                        graphics.drawLine(n6 - n8, n5, n6 + n8, n5);
                        ++n5;
                        --n8;
                    }
                    graphics.translate(-1, -1);
                    graphics.setColor(UIManager.getColor("controlShadow"));
                }
                n5 = 0;
                graphics.setColor(color);
                n8 = n3 - 1;
                while (n8 >= 0) {
                    graphics.drawLine(n6 - n8, n5, n6 + n8, n5);
                    ++n5;
                    --n8;
                }
                break;
            }
            case 7: {
                graphics.setColor(color);
                int n9 = 0;
                while (n9 < n3) {
                    graphics.drawLine(n9, n6 - n9, n9, n6 + n9);
                    ++n9;
                }
                if (bl) break;
                graphics.setColor(UIManager.getColor("controlHighlight"));
                graphics.drawLine(n9, n6 - n9 + 2, n9, n6 + n9);
                break;
            }
            case 3: {
                int n10;
                if (!bl) {
                    graphics.translate(1, 1);
                    graphics.setColor(UIManager.getColor("controlHighlight"));
                    n10 = n3 - 1;
                    while (n10 >= 0) {
                        graphics.drawLine(n5, n6 - n10, n5, n6 + n10);
                        ++n5;
                        --n10;
                    }
                    graphics.translate(-1, -1);
                    graphics.setColor(UIManager.getColor("controlShadow"));
                }
                n5 = 0;
                graphics.setColor(color);
                n10 = n3 - 1;
                while (n10 >= 0) {
                    graphics.drawLine(n5, n6 - n10, n5, n6 + n10);
                    ++n5;
                    --n10;
                }
                break;
            }
        }
        graphics.translate(-n, -n2);
        graphics.setColor(color2);
    }

    public void requestFocus() {
    }

    public void setArrowColor(Color color) {
        this.arrowColor = color;
        this.repaint();
    }

    public void setArrowDirection(int n) {
        this.arrowDirection = n;
        this.repaint();
    }
}

