/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer m_emptyRenderer = new EmptyTableHeaderRenderer();

    public void paint(Graphics graphics, JComponent jComponent) {
        Serializable serializable;
        super.paint(graphics, jComponent);
        if (this.header.getColumnModel() == null) {
            return;
        }
        int n = 0;
        Dimension dimension = this.header.getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            int n2 = this.header.getColumnModel().getColumnMargin();
            rectangle.width = ((TableColumn)serializable).getWidth() + n2;
            rectangle.x += rectangle.width;
            ++n;
        }
        serializable = this.header.getTable();
        Dimension dimension2 = ((Component)serializable).getParent().getSize();
        if (rectangle.x < dimension2.width) {
            Rectangle rectangle2 = new Rectangle(rectangle.x, 0, dimension2.width - rectangle.x, dimension.height);
            this.paintEmptyCell(graphics, rectangle2);
        }
    }

    private void paintEmptyCell(Graphics graphics, Rectangle rectangle) {
        Component component = this.m_emptyRenderer.getTableCellRendererComponent(this.header.getTable(), null, false, false, -1, -1);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }

    class EmptyTableHeaderRenderer
    extends DefaultTableCellRenderer {
        EmptyTableHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }
}

