/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.ContextButtonHelpHandler;
import com.ibm.as400.ui.framework.MenuDescriptor;
import com.ibm.as400.ui.framework.MenuItemDescriptor;
import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.XMLMenuDefinition;
import com.ibm.as400.ui.framework.java.ActionHandler;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.LookAndFeelManager;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.framework.java.PaneManager;
import com.ibm.as400.ui.framework.java.UIFramework;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class MenuManager {
    String m_name;
    Locale m_locale;
    XMLMenuDefinition m_md;
    PaneManager m_paneManager;
    JMenu m_menu;
    Vector m_createdActions = new Vector();
    Hashtable m_menuItemDictionary = new Hashtable();
    static boolean m_descriptorTrace = false;
    static /* synthetic */ Class class$java$awt$event$ItemListener;
    static /* synthetic */ Class class$com$ibm$as400$ui$framework$java$MenuManager;

    public static void main(String[] stringArray) {
        System.setErr(System.out);
        String string = SystemResourceFinder.format("menuManagerArguments");
        if (stringArray.length == 2) {
            JFrame jFrame = new JFrame("MenuManager Test");
            jFrame.setResizable(false);
            JLabel jLabel = new JLabel("To test the menu, click the item on the menu bar.");
            jLabel.setHorizontalAlignment(0);
            jFrame.getContentPane().add((Component)jLabel, "North");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            MenuManager menuManager = null;
            try {
                menuManager = new MenuManager(stringArray[0], stringArray[1], null);
            }
            catch (DisplayManagerException displayManagerException) {
                displayManagerException.displayUserMessage(null);
                System.exit(-1);
            }
            JMenuBar jMenuBar = new JMenuBar();
            jMenuBar.add(menuManager.getMenu());
            jFrame.setJMenuBar(jMenuBar);
            jFrame.pack();
            ((Component)jFrame).setBounds(440, 312, 400, 400);
            ((Component)jFrame).setVisible(true);
        } else if (stringArray.length == 3) {
            if (!stringArray[0].equalsIgnoreCase("-SERIALIZE")) {
                System.err.println(string);
                System.exit(0);
            }
            try {
                new MenuManager(stringArray[1], null, stringArray[2]);
            }
            catch (DisplayManagerException displayManagerException) {
                System.exit(-1);
            }
        } else if (stringArray.length == 4) {
            if (stringArray[0].equalsIgnoreCase("-LOCALE")) {
                String string2;
                String string3 = stringArray[1];
                String string4 = null;
                int n = string3.indexOf("_");
                if (n == -1) {
                    System.err.println(string);
                    System.exit(0);
                }
                String string5 = string3.substring(0, n);
                if ((n = (string3 = string3.substring(n + 1)).indexOf("_")) == -1) {
                    string2 = string3;
                } else {
                    string2 = string3.substring(0, n);
                    string4 = string3.substring(n + 1);
                }
                Locale locale = string4 == null ? new Locale(string5, string2) : new Locale(string5, string2, string4);
                JFrame jFrame = new JFrame("MenuManager Test");
                jFrame.setResizable(false);
                JLabel jLabel = new JLabel("To test the menu, click the item on the menu bar.");
                jLabel.setHorizontalAlignment(0);
                jFrame.getContentPane().add((Component)jLabel, "North");
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                MenuManager menuManager = null;
                try {
                    menuManager = new MenuManager(stringArray[0], stringArray[1], null);
                }
                catch (DisplayManagerException displayManagerException) {
                    displayManagerException.displayUserMessage(null);
                    System.exit(-1);
                }
                JMenuBar jMenuBar = new JMenuBar();
                jMenuBar.add(menuManager.getMenu());
                jFrame.setJMenuBar(jMenuBar);
                jFrame.pack();
                ((Component)jFrame).setBounds(440, 312, 400, 400);
                ((Component)jFrame).setVisible(true);
            } else {
                System.err.println(string);
                System.exit(0);
            }
        } else if (stringArray.length == 5) {
            if (stringArray[0].equalsIgnoreCase("-SERIALIZE") && stringArray[1].equalsIgnoreCase("-LOCALE")) {
                String string6;
                String string7 = stringArray[2];
                String string8 = null;
                int n = string7.indexOf("_");
                if (n == -1) {
                    System.err.println(string);
                    System.exit(0);
                }
                String string9 = string7.substring(0, n);
                if ((n = (string7 = string7.substring(n + 1)).indexOf("_")) == -1) {
                    string6 = string7;
                } else {
                    string6 = string7.substring(0, n);
                    string8 = string7.substring(n + 1);
                }
                Locale locale = string8 == null ? new Locale(string9, string6) : new Locale(string9, string6, string8);
                try {
                    new MenuManager(stringArray[3], locale, stringArray[4]);
                }
                catch (DisplayManagerException displayManagerException) {
                    displayManagerException.displayUserMessage(null);
                    System.exit(-1);
                }
            } else {
                System.err.println(string);
                System.exit(0);
            }
        } else {
            System.err.println(string);
            System.exit(0);
        }
    }

    public MenuManager(String string, String string2, PaneManager paneManager) throws DisplayManagerException {
        this(string, null, string2, paneManager);
    }

    public MenuManager(String string, Locale locale, String string2, PaneManager paneManager) throws DisplayManagerException {
        this.m_md = this.constructMenuDefinition(string, locale, string2);
        this.m_locale = locale;
        this.m_name = string2;
        this.m_paneManager = paneManager;
        this.constructUI();
    }

    public MenuManager(String string, Locale locale, String string2) throws DisplayManagerException {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullBaseNameArgument"));
        }
        if (string2 == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullMenuNameArgument"));
        }
        try {
            this.m_md = new XMLMenuDefinition(string, locale, string2);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            throw new DisplayManagerException(parseException.getClass().getName());
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError(missingResourceException);
            throw new DisplayManagerException(missingResourceException.getClass().getName());
        }
        catch (PDMLSpecificationException pDMLSpecificationException) {
            pDMLSpecificationException.reportErrors();
            throw new DisplayManagerException(pDMLSpecificationException.getClass().getName());
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
        try {
            this.serialize();
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
    }

    public void serialize() throws IOException {
        this.saveMenuDefinition(this.m_md.getMenu().m_name + this.m_md.getPanelDefinitions().m_localeString + ".pdml.ser");
    }

    public JMenu getMenu() {
        return this.m_menu;
    }

    public JMenuItem getMenuItem(String string) {
        return (JMenuItem)this.m_menuItemDictionary.get(string);
    }

    public void enableAllMenuItems(boolean bl) {
        Enumeration enumeration = this.m_menuItemDictionary.elements();
        while (enumeration.hasMoreElements()) {
            JMenuItem jMenuItem = (JMenuItem)enumeration.nextElement();
            jMenuItem.setEnabled(bl);
        }
    }

    public void enableMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = (JMenuItem)this.m_menuItemDictionary.get(string);
        if (jMenuItem != null) {
            jMenuItem.setEnabled(bl);
        }
    }

    public void addMenuItem(JMenuItem jMenuItem) {
        if (jMenuItem != null && jMenuItem.getName() != null) {
            this.m_menuItemDictionary.put(jMenuItem.getName(), jMenuItem);
            this.m_menu.add(jMenuItem);
        }
    }

    public void addSeparator() {
        this.m_menu.addSeparator();
    }

    public void removeMenuItem(String string) {
        if (this.m_menuItemDictionary.get(string) != null) {
            this.m_menu.remove((JMenuItem)this.m_menuItemDictionary.get(string));
            this.m_menuItemDictionary.remove(string);
        }
    }

    public Action[] getActions() {
        Object[] objectArray = new Action[this.m_createdActions.size()];
        this.m_createdActions.copyInto(objectArray);
        return objectArray;
    }

    public PaneManager getPaneManager() {
        return this.m_paneManager;
    }

    public String getName() {
        return this.m_name;
    }

    private XMLMenuDefinition constructMenuDefinition(String string, Locale locale, String objectArray) throws DisplayManagerException {
        Object object;
        XMLMenuDefinition xMLMenuDefinition;
        block17: {
            Locale locale2;
            if (string == null) {
                throw new IllegalArgumentException(SystemResourceFinder.format("nullBaseNameArgument"));
            }
            if (objectArray == null) {
                throw new IllegalArgumentException(SystemResourceFinder.format("nullMenuNameArgument"));
            }
            xMLMenuDefinition = null;
            Locale locale3 = locale2 = locale != null ? locale : Locale.getDefault();
            if (UIFramework.getSearchMode() != 3) {
                int n = string.lastIndexOf(46);
                object = n != -1 ? string.substring(0, n) + "/" + (String)objectArray : objectArray;
                try {
                    xMLMenuDefinition = this.loadMenuDefinition((String)object, locale);
                }
                catch (MissingResourceException missingResourceException) {
                    if (UIFramework.getSearchMode() == 1) {
                        Object[] objectArray2 = new Object[]{new String((String)objectArray + "_" + locale2)};
                        MessageLog.logError(SystemResourceFinder.format("serializedMenuNotFound", objectArray2));
                        throw new DisplayManagerException(missingResourceException.getClass().getName());
                    }
                }
                catch (IOException iOException) {
                    MessageLog.printStackTrace(iOException);
                    if (UIFramework.getSearchMode() == 1) {
                        throw new DisplayManagerException(iOException.getClass().getName());
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MessageLog.printStackTrace(classNotFoundException);
                    if (UIFramework.getSearchMode() != 1) break block17;
                    throw new DisplayManagerException(classNotFoundException.getClass().getName());
                }
            }
        }
        if (xMLMenuDefinition != null) {
            object = new Object[]{new String((String)objectArray + SystemResourceFinder.getLastDocumentLocale() + ".pdml.ser")};
            MessageLog.traceOut(SystemResourceFinder.format("menuLoaded", object));
            if (m_descriptorTrace) {
                xMLMenuDefinition.dump();
            }
            return xMLMenuDefinition;
        }
        try {
            xMLMenuDefinition = new XMLMenuDefinition(string, locale, (String)objectArray);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            throw new DisplayManagerException(parseException.getClass().getName());
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError(missingResourceException);
            throw new DisplayManagerException(missingResourceException.getClass().getName());
        }
        catch (PDMLSpecificationException pDMLSpecificationException) {
            pDMLSpecificationException.reportErrors();
            throw new DisplayManagerException(pDMLSpecificationException.getClass().getName());
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
        object = new Object[]{objectArray, new String(xMLMenuDefinition.getPanelDefinitions().m_baseName + xMLMenuDefinition.getPanelDefinitions().m_localeString)};
        MessageLog.traceOut(SystemResourceFinder.format("menuParsed", object));
        if (m_descriptorTrace) {
            xMLMenuDefinition.dump();
        }
        return xMLMenuDefinition;
    }

    private XMLMenuDefinition loadMenuDefinition(String string, Locale locale) throws IOException, ClassNotFoundException {
        InputStream inputStream = SystemResourceFinder.getSerializedPDMLDocument(string, locale);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
        XMLMenuDefinition xMLMenuDefinition = (XMLMenuDefinition)objectInputStream.readObject();
        objectInputStream.close();
        return xMLMenuDefinition;
    }

    private void saveMenuDefinition(String string) throws IOException {
        Object[] objectArray = new Object[]{string};
        MessageLog.traceOut(SystemResourceFinder.format("menuSaved", objectArray));
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
        objectOutputStream.writeObject(this.m_md);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    private void constructUI() {
        LookAndFeelManager.setLookAndFeel();
        MenuDescriptor menuDescriptor = this.m_md.getMenu();
        this.m_menu = new JMenu(menuDescriptor.m_title);
        this.m_menu.setName(menuDescriptor.m_name);
        if (menuDescriptor.m_mnemonic != '\u0000') {
            this.m_menu.setMnemonic(menuDescriptor.m_mnemonic);
        }
        Vector vector = this.m_md.getMenuItems();
        this.createMenuItems(this.m_menu, vector);
    }

    private void createMenuItems(JMenu jMenu, Vector vector) {
        ButtonGroup buttonGroup = null;
        int n = 0;
        while (n < vector.size()) {
            Object object;
            MenuItemDescriptor menuItemDescriptor = (MenuItemDescriptor)vector.elementAt(n);
            if (menuItemDescriptor.m_name == null) {
                buttonGroup = null;
                jMenu.addSeparator();
                object = new DefaultAction();
                object.putValue("Default", "SEPARATOR");
                this.m_createdActions.addElement(object);
            } else if (menuItemDescriptor.m_children != null) {
                buttonGroup = null;
                object = new JMenu(menuItemDescriptor.m_title);
                ((Component)object).setName(menuItemDescriptor.m_name);
                if (menuItemDescriptor.m_mnemonic != '\u0000') {
                    ((AbstractButton)object).setMnemonic(menuItemDescriptor.m_mnemonic);
                }
                this.createMenuItems((JMenu)object, menuItemDescriptor.m_children);
                jMenu.add((JMenuItem)object);
                this.m_menuItemDictionary.put(((Component)object).getName(), object);
            } else {
                Object object2;
                Object[] objectArray;
                Accessible accessible;
                object = this.createAction(menuItemDescriptor);
                if (object == null) {
                    object = new DefaultAction();
                }
                object.putValue("Default", menuItemDescriptor.m_title != null ? menuItemDescriptor.m_title : menuItemDescriptor.m_flyover);
                object.putValue("Name", menuItemDescriptor.m_title);
                object.putValue("ShortDescription", menuItemDescriptor.m_flyover);
                object.putValue("pdml.menuitem.descriptor", menuItemDescriptor);
                if (menuItemDescriptor.m_icon != null) {
                    accessible = null;
                    try {
                        accessible = SystemResourceFinder.getImageResource(menuItemDescriptor.m_icon);
                    }
                    catch (MissingResourceException missingResourceException) {
                        MessageLog.logError(missingResourceException);
                    }
                    if (accessible != null) {
                        object.putValue("SmallIcon", accessible);
                    }
                }
                object.setEnabled(!menuItemDescriptor.m_disabled);
                this.m_createdActions.addElement(object);
                if (menuItemDescriptor.m_type.equals("CHECK")) {
                    buttonGroup = null;
                    accessible = new JCheckBoxMenuItem((String)object.getValue("Name"), (Icon)object.getValue("SmallIcon"));
                    ((AbstractButton)((Object)accessible)).setSelected(menuItemDescriptor.m_selected);
                    if (!(class$java$awt$event$ItemListener == null ? MenuManager.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener).isAssignableFrom(object.getClass())) {
                        objectArray = new Object[]{object.getClass().getName()};
                        MessageLog.traceErr(SystemResourceFinder.format("menuListenerNotImplemented", objectArray));
                    } else {
                        ((AbstractButton)((Object)accessible)).addItemListener((ItemListener)object);
                    }
                } else if (menuItemDescriptor.m_type.equals("RADIO")) {
                    if (buttonGroup == null) {
                        buttonGroup = new ButtonGroup();
                    }
                    accessible = new JRadioButtonMenuItem((String)object.getValue("Name"), (Icon)object.getValue("SmallIcon"));
                    buttonGroup.add((AbstractButton)((Object)accessible));
                    ((AbstractButton)((Object)accessible)).setSelected(menuItemDescriptor.m_selected);
                    if (!(class$java$awt$event$ItemListener == null ? MenuManager.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener).isAssignableFrom(object.getClass())) {
                        objectArray = new Object[]{object.getClass().getName()};
                        MessageLog.traceErr(SystemResourceFinder.format("menuListenerNotImplemented", objectArray));
                    } else {
                        ((AbstractButton)((Object)accessible)).addItemListener((ItemListener)object);
                    }
                } else {
                    buttonGroup = null;
                    accessible = new JMenuItem((String)object.getValue("Name"), (Icon)object.getValue("SmallIcon"));
                }
                ((AbstractButton)((Object)accessible)).setActionCommand(menuItemDescriptor.m_name);
                ((Component)((Object)accessible)).setName(menuItemDescriptor.m_name);
                objectArray = (Object[])object.getValue("ShortDescription");
                if (objectArray != null && !objectArray.trim().equals("")) {
                    ((JComponent)((Object)accessible)).setToolTipText((String)objectArray);
                }
                ((JMenuItem)accessible).setEnabled(object.isEnabled());
                if (menuItemDescriptor.m_default) {
                    object2 = ((JMenuItem)accessible).getComponent();
                    Font font = ((Component)object2).getFont();
                    String string = font.getName();
                    int n2 = font.getSize();
                    Font font2 = new Font(string, 1, n2);
                    ((Component)object2).setFont(font2);
                }
                if (menuItemDescriptor.m_mnemonic != '\u0000') {
                    ((AbstractButton)((Object)accessible)).setMnemonic(menuItemDescriptor.m_mnemonic);
                }
                if (menuItemDescriptor.m_accelerator != null) {
                    ((JMenuItem)accessible).setAccelerator(KeyStroke.getKeyStroke(menuItemDescriptor.m_accelerator.m_keycode, menuItemDescriptor.m_accelerator.m_modifiers));
                }
                if (object.getValue("SmallIcon") != null) {
                    if (menuItemDescriptor.m_iconPosition == null) {
                        object2 = this.m_md.getMenu().m_type;
                        if (((String)object2).equals("MENU")) {
                            menuItemDescriptor.m_iconPosition = "RIGHT";
                        } else if (((String)object2).equals("TOOLBAR")) {
                            menuItemDescriptor.m_iconPosition = "CENTER";
                        }
                    }
                    if (menuItemDescriptor.m_vIconPosition == null) {
                        object2 = this.m_md.getMenu().m_type;
                        if (((String)object2).equals("MENU")) {
                            menuItemDescriptor.m_vIconPosition = "CENTER";
                        } else if (((String)object2).equals("TOOLBAR")) {
                            menuItemDescriptor.m_vIconPosition = "TOP";
                        }
                    }
                    if (menuItemDescriptor.m_iconPosition.equals("LEFT")) {
                        ((AbstractButton)((Object)accessible)).setHorizontalTextPosition(4);
                    } else if (menuItemDescriptor.m_iconPosition.equals("CENTER")) {
                        ((AbstractButton)((Object)accessible)).setHorizontalTextPosition(0);
                    } else if (menuItemDescriptor.m_iconPosition.equals("RIGHT")) {
                        ((AbstractButton)((Object)accessible)).setHorizontalTextPosition(2);
                    }
                    if (menuItemDescriptor.m_vIconPosition.equals("CENTER")) {
                        ((AbstractButton)((Object)accessible)).setVerticalTextPosition(0);
                    } else if (menuItemDescriptor.m_iconPosition.equals("CENTER")) {
                        if (menuItemDescriptor.m_vIconPosition.equals("TOP")) {
                            ((AbstractButton)((Object)accessible)).setVerticalTextPosition(3);
                        } else if (menuItemDescriptor.m_vIconPosition.equals("BOTTOM")) {
                            ((AbstractButton)((Object)accessible)).setVerticalTextPosition(1);
                        }
                    } else if (menuItemDescriptor.m_vIconPosition.equals("TOP")) {
                        ((AbstractButton)((Object)accessible)).setVerticalTextPosition(1);
                    } else if (menuItemDescriptor.m_vIconPosition.equals("BOTTOM")) {
                        ((AbstractButton)((Object)accessible)).setVerticalTextPosition(3);
                    }
                }
                ((AbstractButton)((Object)accessible)).addActionListener((ActionListener)object);
                jMenu.add((JMenuItem)accessible);
                this.m_menuItemDictionary.put(menuItemDescriptor.m_name, accessible);
                object.addPropertyChangeListener(new ActionChangedListener((JMenuItem)accessible));
            }
            ++n;
        }
    }

    private Action createAction(MenuItemDescriptor menuItemDescriptor) {
        ActionHandler actionHandler = null;
        if (menuItemDescriptor.m_action.equals("CONTEXTHELP")) {
            return new ContextButtonHelpHandler(this);
        }
        try {
            Class[] classArray = new Class[]{class$com$ibm$as400$ui$framework$java$MenuManager == null ? (class$com$ibm$as400$ui$framework$java$MenuManager = MenuManager.class$("com.ibm.as400.ui.framework.java.MenuManager")) : class$com$ibm$as400$ui$framework$java$MenuManager};
            Constructor<?> constructor = Class.forName(menuItemDescriptor.m_action).getConstructor(classArray);
            Object[] objectArray = new Object[]{this};
            actionHandler = (ActionHandler)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            MessageLog.logError(exception);
            Object[] objectArray = new Object[]{menuItemDescriptor.m_action};
            MessageLog.logError(SystemResourceFinder.format("actionCreationError", objectArray));
            return null;
        }
        return actionHandler;
    }

    private void debug(String string) {
        if (m_descriptorTrace) {
            System.out.println("MenuManager: " + string);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DefaultAction
    extends AbstractAction
    implements ItemListener {
        private DefaultAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("ACTION SELECTED: " + actionEvent.getActionCommand());
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            System.out.println(((JMenuItem)itemEvent.getItem()).getText() + " STATE CHANGED: " + (itemEvent.getStateChange() == 1 ? "SELECTED" : "DESELECTED"));
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem jMenuItem) {
            this.menuItem = jMenuItem;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl);
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.menuItem.setIcon(icon);
                this.menuItem.invalidate();
                this.menuItem.repaint();
            }
        }
    }
}

