/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.sun.java.help.impl.ViewAwareComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.help.TextHelpModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class JHShowICHelp
extends JButton
implements ActionListener,
ViewAwareComponent {
    private View myView;
    private HelpSet hs;
    private SimpleAttributeSet textAttribs;
    private URL base;
    private HTMLDocument doc;
    private String curDir = System.getProperty("user.dir");
    public static String LINK_BUTTON = "javax.help.LinkButton";
    public static String LINK_LABEL = "javax.help.LinkLabel";
    private static final String buttonPropertyPrefix = "Button.";
    private static final String editorPropertyPrefix = "EditorPane.";
    private String m_helpFile;
    private String m_topic;
    private static Component container;
    private int viewerActivator = 0;
    private static final boolean debug = true;

    public JHShowICHelp() {
        this.setText(">");
        this.setMargin(new Insets(0, 0, 0, 0));
        this.createLinkButton();
        this.addActionListener(this);
    }

    public void setViewData(View view) {
        TextHelpModel textHelpModel;
        this.myView = view;
        this.doc = (HTMLDocument)this.myView.getDocument();
        this.base = this.doc.getBase();
        Font font = this.getFont();
        this.textAttribs = new SimpleAttributeSet();
        this.textAttribs.removeAttribute(StyleConstants.FontSize);
        this.textAttribs.removeAttribute(StyleConstants.Bold);
        this.textAttribs.removeAttribute(StyleConstants.Italic);
        this.textAttribs.addAttribute(StyleConstants.FontFamily, font.getName());
        this.textAttribs.addAttribute(StyleConstants.FontSize, new Integer(font.getSize()));
        this.textAttribs.addAttribute(StyleConstants.Bold, new Boolean(font.isBold()));
        this.textAttribs.addAttribute(StyleConstants.Italic, new Boolean(font.isItalic()));
        container = this.myView.getContainer();
        Container container = JHShowICHelp.container;
        while (container != null) {
            if (container instanceof JHelpContentViewer) break;
            container = container.getParent();
        }
        if (container != null && (textHelpModel = ((JHelpContentViewer)container).getModel()) != null) {
            this.hs = textHelpModel.getHelpSet();
        }
    }

    public void setTopic(String string) {
        this.m_topic = string;
    }

    public String getTopic() {
        return this.m_topic;
    }

    public void setViewerActivator(String string) {
        if (string.compareTo(LINK_BUTTON) == 0 && this.viewerActivator != 0) {
            this.viewerActivator = 0;
            this.createLinkButton();
        } else if (string.compareTo(LINK_LABEL) == 0 && this.viewerActivator != 1) {
            this.viewerActivator = 1;
            this.createLinkLabel();
        }
    }

    public String getViewerActivator() {
        switch (this.viewerActivator) {
            case 0: {
                return LINK_BUTTON;
            }
            case 1: {
                return LINK_LABEL;
            }
        }
        return "unknownStyle";
    }

    private void createLinkButton() {
        LookAndFeel.installBorder(this, "Button.border");
        this.setBorderPainted(true);
        this.setFocusPainted(true);
        this.setAlignmentY(0.5f);
        this.setContentAreaFilled(true);
        this.setBackground(UIManager.getColor("Button.background"));
        if (this.textAttribs != null && this.textAttribs.isDefined(StyleConstants.Foreground)) {
            this.setForeground((Color)this.textAttribs.getAttribute(StyleConstants.Foreground));
        } else {
            this.setForeground(UIManager.getColor("Button.foreground"));
        }
        this.invalidate();
    }

    private void createLinkLabel() {
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setAlignmentY(this.getPreferredLabelAlignment());
        this.setContentAreaFilled(false);
        this.setBackground(UIManager.getColor("EditorPane.background"));
        if (this.textAttribs != null && this.textAttribs.isDefined(StyleConstants.Foreground)) {
            this.setForeground((Color)this.textAttribs.getAttribute(StyleConstants.Foreground));
        } else {
            this.setForeground(Color.blue);
        }
        this.invalidate();
    }

    private float getPreferredLabelAlignment() {
        Icon icon = this.getIcon();
        String string = this.getText();
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(this, fontMetrics, string, icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, string == null ? 0 : ((BasicButtonUI)this.ui).getDefaultTextIconGap(this));
        Rectangle rectangle4 = rectangle.union(rectangle2);
        Insets insets = this.getInsets();
        rectangle4.height += insets.top + insets.bottom;
        if (rectangle4.height % 2 == 0) {
            ++rectangle4.height;
        }
        float f = fontMetrics.getMaxAscent() + insets.top;
        return f / (float)rectangle4.height;
    }

    public void setIconByName(String string) {
        ImageIcon imageIcon = null;
        URL uRL = null;
        try {
            uRL = new URL(this.base, string);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        imageIcon = new ImageIcon(uRL);
        if (imageIcon != null) {
            this.setIcon(imageIcon);
            String string2 = this.getText();
            if (string2.compareTo(">") == 0) {
                this.setText("");
            }
        }
    }

    public void setIconByID(String string) {
        ImageIcon imageIcon = null;
        URL uRL = null;
        Map map = this.hs.getCombinedMap();
        try {
            uRL = map.getURLFromID(Map.ID.create((String)string, (HelpSet)this.hs));
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        imageIcon = new ImageIcon(uRL);
        if (imageIcon != null) {
            this.setIcon(imageIcon);
            String string2 = this.getText();
            if (string2.compareTo(">") == 0) {
                this.setText("");
            }
        }
    }

    public void setTextFontFamily(String string) {
        this.textAttribs.removeAttribute(StyleConstants.FontFamily);
        this.textAttribs.addAttribute(StyleConstants.FontFamily, string);
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        Font font = this.getFont();
    }

    public String getTextFontFamily() {
        return StyleConstants.getFontFamily(this.textAttribs);
    }

    public void setTextFontSize(String string) {
        Object object;
        int n;
        StyleSheet styleSheet = this.doc.getStyleSheet();
        try {
            if (string.equals("xx-small")) {
                n = (int)styleSheet.getPointSize(0);
            } else if (string.equals("x-small")) {
                n = (int)styleSheet.getPointSize(1);
            } else if (string.equals("small")) {
                n = (int)styleSheet.getPointSize(2);
            } else if (string.equals("medium")) {
                n = (int)styleSheet.getPointSize(3);
            } else if (string.equals("large")) {
                n = (int)styleSheet.getPointSize(4);
            } else if (string.equals("x-large")) {
                n = (int)styleSheet.getPointSize(5);
            } else if (string.equals("xx-large")) {
                n = (int)styleSheet.getPointSize(6);
            } else if (string.equals("bigger")) {
                n = (int)styleSheet.getPointSize("+1");
            } else if (string.equals("smaller")) {
                n = (int)styleSheet.getPointSize("-1");
            } else if (string.endsWith("pt")) {
                object = string.substring(0, string.length() - 2);
                n = Integer.parseInt((String)object);
            } else {
                n = (int)styleSheet.getPointSize(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n == 0) {
            return;
        }
        this.textAttribs.removeAttribute(StyleConstants.FontSize);
        this.textAttribs.addAttribute(StyleConstants.FontSize, new Integer(n));
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        object = this.getFont();
    }

    public String getTextFontSize() {
        return Integer.toString(StyleConstants.getFontSize(this.textAttribs));
    }

    public void setTextFontWeight(String string) {
        boolean bl = false;
        bl = string.compareTo("bold") == 0;
        this.textAttribs.removeAttribute(StyleConstants.Bold);
        this.textAttribs.addAttribute(StyleConstants.Bold, new Boolean(bl));
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        Font font = this.getFont();
    }

    public String getTextFontWeight() {
        if (StyleConstants.isBold(this.textAttribs)) {
            return "bold";
        }
        return "plain";
    }

    public void setTextFontStyle(String string) {
        boolean bl = false;
        bl = string.compareTo("italic") == 0;
        this.textAttribs.removeAttribute(StyleConstants.Italic);
        this.textAttribs.addAttribute(StyleConstants.Italic, new Boolean(bl));
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        Font font = this.getFont();
    }

    public String getTextFontStyle() {
        if (StyleConstants.isItalic(this.textAttribs)) {
            return "italic";
        }
        return "plain";
    }

    public void setTextColor(String string) {
        Color color = null;
        if (string.compareTo("black") == 0) {
            color = Color.black;
        } else if (string.compareTo("blue") == 0) {
            color = Color.blue;
        } else if (string.compareTo("cyan") == 0) {
            color = Color.cyan;
        } else if (string.compareTo("darkGray") == 0) {
            color = Color.darkGray;
        } else if (string.compareTo("gray") == 0) {
            color = Color.gray;
        } else if (string.compareTo("green") == 0) {
            color = Color.green;
        } else if (string.compareTo("lightGray") == 0) {
            color = Color.lightGray;
        } else if (string.compareTo("magenta") == 0) {
            color = Color.magenta;
        } else if (string.compareTo("orange") == 0) {
            color = Color.orange;
        } else if (string.compareTo("pink") == 0) {
            color = Color.pink;
        } else if (string.compareTo("red") == 0) {
            color = Color.red;
        } else if (string.compareTo("white") == 0) {
            color = Color.white;
        } else if (string.compareTo("yellow") == 0) {
            color = Color.yellow;
        }
        if (color == null) {
            return;
        }
        this.textAttribs.removeAttribute(StyleConstants.Foreground);
        this.textAttribs.addAttribute(StyleConstants.Foreground, color);
        this.setForeground(color);
    }

    public String getTextColor() {
        Color color = this.getForeground();
        return color.toString();
    }

    private Font getAttributeSetFont(AttributeSet attributeSet) {
        int n = 0;
        if (StyleConstants.isBold(attributeSet)) {
            n |= 1;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n |= 2;
        }
        String string = StyleConstants.getFontFamily(attributeSet);
        int n2 = StyleConstants.getFontSize(attributeSet);
        if (StyleConstants.isSuperscript(attributeSet) || StyleConstants.isSubscript(attributeSet)) {
            n2 -= 2;
        }
        return this.doc.getStyleSheet().getFont(string, n, n2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JHShowICHelp.debug("actionPerformed: button/link clicked on");
        try {
            JHShowICHelp.debug("Topic is " + this.getTopic());
            String string = this.curDir + "\\cwb3uic.exe";
            String[] stringArray = new String[]{string, this.getTopic()};
            Runtime runtime = Runtime.getRuntime();
            runtime.exec(stringArray);
        }
        catch (Exception exception) {
            JHShowICHelp.debug(exception.toString());
        }
    }

    private static void debug(String string) {
        System.out.println("JHShowICHelp: " + string);
    }
}

