/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.java.GroupDescriptor;
import com.ibm.as400.ui.framework.java.GroupingTableHeaderUI;
import com.ibm.as400.ui.framework.java.MessageLog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class JGroupingTableHeader
extends JTableHeader {
    private static final String uiClassID = "GroupingTableHeaderUI";
    private Vector m_groups = new Vector();
    private int m_columnsRemaining;
    private ColumnModelListener m_modelListener = new ColumnModelListener();
    private static boolean dbgFlag;

    JGroupingTableHeader() {
        this.setReorderingAllowed(false);
        JGroupingTableHeader.debug("ctor1 returning!");
    }

    JGroupingTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
        this.setReorderingAllowed(false);
        this.m_columnsRemaining = this.getColumnModel().getColumnCount();
        JGroupingTableHeader.debug("ctor2 returning!");
    }

    public void setGroup(String string, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of columns must be >= 1");
        }
        if (n > this.getColumnModel().getColumnCount()) {
            throw new IllegalArgumentException("Number of columns exceeds column count: " + n + " > " + this.columnModel.getColumnCount());
        }
        if (n > this.m_columnsRemaining) {
            throw new IllegalArgumentException("Number of columns exceeds columns remaining: " + n + " > " + this.m_columnsRemaining);
        }
        this.m_groups.add(new GroupDescriptor(string, n));
        this.m_columnsRemaining -= n;
        this.resizeAndRepaint();
    }

    public void resetGroups() {
        this.m_groups.clear();
        this.m_columnsRemaining = this.getColumnModel().getColumnCount();
        this.resizeAndRepaint();
    }

    GroupDescriptor[] getGroups() {
        Object[] objectArray = new GroupDescriptor[this.m_groups.size()];
        this.m_groups.copyInto(objectArray);
        return objectArray;
    }

    public TableHeaderUI getUI() {
        JGroupingTableHeader.debug("getUI called!");
        return (GroupingTableHeaderUI)this.ui;
    }

    public void setUI(GroupingTableHeaderUI groupingTableHeaderUI) {
        JGroupingTableHeader.debug("setUI called!");
        super.setUI(groupingTableHeaderUI);
    }

    public void updateUI() {
        JGroupingTableHeader.debug("updateUI called!");
        try {
            this.setUI((GroupingTableHeaderUI)UIManager.getUI(this));
        }
        catch (ClassCastException classCastException) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass("com.ibm.as400.ui.framework.java.GroupingTableHeaderUI");
                if (clazz != null) {
                    UIManager.put("com.ibm.as400.ui.framework.java.GroupingTableHeaderUI", clazz);
                } else {
                    MessageLog.traceErr("class not found: com.ibm.as400.ui.framework.java.GroupingTableHeaderUI");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                MessageLog.printStackTrace(classNotFoundException);
            }
            this.setUI((GroupingTableHeaderUI)UIManager.getUI(this));
        }
        this.resizeAndRepaint();
        this.invalidate();
    }

    public String getUIClassID() {
        JGroupingTableHeader.debug("getUIClassID called!");
        return uiClassID;
    }

    public void setTable(JTable jTable) {
        JGroupingTableHeader.debug("setTable called: " + jTable);
        if (!(this.getTable() == null || jTable != null && this.getTable().equals(jTable))) {
            this.getTable().removePropertyChangeListener("model", this.m_modelListener);
            if (jTable != null) {
                jTable.addPropertyChangeListener("model", this.m_modelListener);
            }
        } else if (this.getTable() == null && jTable != null) {
            jTable.addPropertyChangeListener("model", this.m_modelListener);
        }
        super.setTable(jTable);
    }

    private static void debug(String string) {
        if (dbgFlag) {
            System.out.println("JGroupingTableHeader: " + string);
        }
    }

    static {
        try {
            UIManager.put(uiClassID, "com.ibm.as400.ui.framework.java.GroupingTableHeaderUI");
            UIManager.put("com.ibm.as400.ui.framework.java.GroupingTableHeaderUI", Class.forName("com.ibm.as400.ui.framework.java.GroupingTableHeaderUI"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        dbgFlag = false;
    }

    private class ColumnModelListener
    implements PropertyChangeListener {
        private ColumnModelListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JGroupingTableHeader.debug("property change: " + propertyChangeEvent);
            if (propertyChangeEvent.getPropertyName().equals("model")) {
                JGroupingTableHeader.this.resetGroups();
            }
        }
    }
}

