/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;
import javax.swing.SwingConstants;

class FormattedFlowLayout
implements LayoutManager2,
SwingConstants {
    Hashtable m_comptable = new Hashtable();
    int m_count = 0;
    int m_space = 10;
    int m_orient = 0;
    int m_align = 0;
    boolean m_equal = false;
    Insets m_insets;

    public FormattedFlowLayout(int n) {
        this.m_count = n;
        this.m_insets = new Insets(0, 0, 0, 0);
    }

    public void setOrientation(int n) {
        this.m_orient = n;
        this.resetAlignment();
    }

    public int getOrientation() {
        return this.m_orient;
    }

    public void setAlignment(int n) {
        this.m_align = n;
        this.resetAlignment();
    }

    public int getAlignment() {
        return this.m_align;
    }

    protected void resetAlignment() {
        if (this.m_orient == 0) {
            if (this.m_align == 2) {
                this.m_align = 1;
            } else if (this.m_align == 4) {
                this.m_align = 3;
            }
        } else if (this.m_align == 1) {
            this.m_align = 2;
        } else if (this.m_align == 3) {
            this.m_align = 4;
        }
    }

    public void setEqualSizeCells(boolean bl) {
        this.m_equal = bl;
    }

    public boolean isEqualSizeCells() {
        return this.m_equal;
    }

    public void setSpacing(int n) {
        this.m_space = n;
    }

    public int getSpacing() {
        return this.m_space;
    }

    public void setInsets(Insets insets) {
        this.m_insets = insets;
    }

    public Insets getInsets() {
        return new Insets(this.m_insets.top, this.m_insets.left, this.m_insets.bottom, this.m_insets.right);
    }

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.m_comptable.put(component, gridBagConstraints.clone());
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof GridBagConstraints) {
            this.setConstraints(component, (GridBagConstraints)object);
        } else if (!(object instanceof String) && object != null) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a TableConstraint");
        }
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            block15: {
                n7 = container.getComponentCount();
                n6 = this.m_orient == 0 ? 1 : this.m_count;
                n5 = this.m_orient == 1 ? 1 : this.m_count;
                Insets insets = container.getInsets();
                n4 = insets.top + insets.bottom + this.m_insets.top + this.m_insets.bottom;
                n3 = insets.left + insets.right + this.m_insets.left + this.m_insets.right;
                n2 = 0;
                n = 0;
                if (!this.m_equal) break block15;
                int n8 = 0;
                while (n8 < n7) {
                    Component component = container.getComponent(n8);
                    Dimension dimension = component.getMinimumSize();
                    if (n2 < dimension.width) {
                        n2 = dimension.width;
                    }
                    if (n < dimension.height) {
                        n = dimension.height;
                    }
                    ++n8;
                }
                if (n7 == 0) {
                    n = 25;
                    n2 = 25;
                }
                Dimension dimension = new Dimension(n3 + n2 * n5 + this.m_space * (n5 - 1), n4 + n * n6 + this.m_space * (n6 - 1));
                return dimension;
            }
            int n9 = 0;
            while (n9 < n7) {
                Component component = container.getComponent(n9);
                Dimension dimension = component.getMinimumSize();
                if (this.m_orient == 0) {
                    n2 += dimension.width;
                    if (n < dimension.height) {
                        n = dimension.height;
                    }
                } else {
                    n += dimension.height;
                    if (n2 < dimension.width) {
                        n2 = dimension.width;
                    }
                }
                ++n9;
            }
            if (this.m_orient == 0) {
                n2 += (this.m_count - n7) * 25;
            } else {
                n += (this.m_count - n7) * 25;
            }
            Dimension dimension = new Dimension(n3 + n2 + this.m_space * (n5 - 1), n4 + n + this.m_space * (n6 - 1));
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            block15: {
                n7 = container.getComponentCount();
                n6 = this.m_orient == 0 ? 1 : this.m_count;
                n5 = this.m_orient == 1 ? 1 : this.m_count;
                Insets insets = container.getInsets();
                n4 = insets.top + insets.bottom + this.m_insets.top + this.m_insets.bottom;
                n3 = insets.left + insets.right + this.m_insets.left + this.m_insets.right;
                n2 = 0;
                n = 0;
                if (!this.m_equal) break block15;
                int n8 = 0;
                while (n8 < n7) {
                    Component component = container.getComponent(n8);
                    Dimension dimension = component.getPreferredSize();
                    if (n2 < dimension.width) {
                        n2 = dimension.width;
                    }
                    if (n < dimension.height) {
                        n = dimension.height;
                    }
                    ++n8;
                }
                if (n7 == 0) {
                    n = 25;
                    n2 = 25;
                }
                Dimension dimension = new Dimension(n3 + n2 * n5 + this.m_space * (n5 - 1), n4 + n * n6 + this.m_space * (n6 - 1));
                return dimension;
            }
            int n9 = 0;
            while (n9 < n7) {
                Component component = container.getComponent(n9);
                Dimension dimension = component.getPreferredSize();
                if (this.m_orient == 0) {
                    n2 += dimension.width;
                    if (n < dimension.height) {
                        n = dimension.height;
                    }
                } else {
                    n += dimension.height;
                    if (n2 < dimension.width) {
                        n2 = dimension.width;
                    }
                }
                ++n9;
            }
            if (this.m_orient == 0) {
                n2 += (this.m_count - n7) * 25;
            } else {
                n += (this.m_count - n7) * 25;
            }
            Dimension dimension = new Dimension(n3 + n2 + this.m_space * (n5 - 1), n4 + n + this.m_space * (n6 - 1));
            return dimension;
        }
    }

    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n = insets.top + insets.bottom + this.m_insets.top + this.m_insets.bottom;
            int n2 = insets.left + insets.right + this.m_insets.left + this.m_insets.right;
            int n3 = container.getComponentCount();
            int n4 = this.m_orient == 0 ? 1 : this.m_count;
            int n5 = this.m_orient == 1 ? 1 : this.m_count;
            int n6 = 0;
            int n7 = 0;
            if (this.m_equal) {
                if (this.m_orient == 0) {
                    n6 = (dimension.width - n2 - this.m_space * (this.m_count - 1)) / this.m_count;
                    n7 = dimension.height - n;
                } else {
                    n6 = dimension.width - n2;
                    n7 = (dimension.height - n - this.m_space * (this.m_count - 1)) / this.m_count;
                }
                int n8 = 0;
                while (n8 < n3) {
                    int n9;
                    int n10;
                    Component component = container.getComponent(n8);
                    if (this.m_orient == 0) {
                        n10 = insets.left + this.m_insets.left + n8 * n6 + n8 * this.m_space;
                        n9 = insets.top + this.m_insets.top;
                    } else {
                        n10 = insets.left + this.m_insets.left;
                        n9 = insets.top + this.m_insets.top + n8 * n7 + n8 * this.m_space;
                    }
                    int n11 = n6;
                    int n12 = n7;
                    component.setBounds(n10, n9, n11, n12);
                    ++n8;
                }
            } else {
                int n13 = dimension.width - n2;
                int n14 = dimension.height - n;
                int n15 = insets.left + this.m_insets.left;
                int n16 = insets.top + this.m_insets.top;
                int n17 = insets.bottom + this.m_insets.bottom;
                int n18 = insets.right + this.m_insets.right;
                int n19 = n15 + (dimension.width - (n18 + n15)) / 2;
                int n20 = n16 + (dimension.height - (n16 + n17)) / 2;
                int n21 = 0;
                while (n21 < n3) {
                    Component component = container.getComponent(n21);
                    Dimension dimension2 = component.getPreferredSize();
                    int n22 = dimension2.width;
                    int n23 = dimension2.height;
                    if (this.m_orient == 0) {
                        if (this.m_align == 1) {
                            component.setBounds(n15, n16, n22, n23);
                        } else if (this.m_align == 3) {
                            component.setBounds(n15, dimension.height - n23 - n17, n22, n23);
                        } else {
                            component.setBounds(n15, n20 - n23 / 2, n22, n23);
                        }
                        n15 += n22 + this.m_space;
                    } else {
                        if (this.m_align == 2) {
                            component.setBounds(n15, n16, n22, n23);
                        } else if (this.m_align == 4) {
                            component.setBounds(dimension.width - dimension2.width - n18, n16, n22, n23);
                        } else {
                            component.setBounds(n19 - n22 / 2, n16, n22, n23);
                        }
                        n16 += n23 + this.m_space;
                    }
                    ++n21;
                }
            }
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

