/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.PaneDescriptor;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.XMLDeckPaneDefinition;
import com.ibm.as400.ui.framework.java.DataBean;
import com.ibm.as400.ui.framework.java.DataFormatter;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.DynamicPanelManager;
import com.ibm.as400.ui.framework.java.IllegalUserDataException;
import com.ibm.as400.ui.framework.java.JavaComponentDescriptor;
import com.ibm.as400.ui.framework.java.LookAndFeelManager;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.framework.java.PaneManager;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.framework.java.SplitPaneManager;
import com.ibm.as400.ui.framework.java.TabbedPaneManager;
import com.ibm.as400.ui.framework.java.UIFramework;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DeckPaneManager
implements PaneManager {
    private Locale m_locale;
    private XMLDeckPaneDefinition m_dpd;
    private DataBean[] m_dataBeans;
    private JPanel m_deckPanePanel;
    private Container m_container;
    private Vector m_panes;
    private Vector m_panels = new Vector();
    Hashtable m_panelTable = new Hashtable();
    private PaneManager m_activePanel;
    private boolean m_dataLoaded = false;
    private PaneManager m_aggregateManager;
    static boolean m_descriptorTrace = false;

    public static void main(String[] stringArray) {
        System.setErr(System.out);
        String string = SystemResourceFinder.format("paneManagerArguments");
        if (stringArray.length == 2) {
            JFrame jFrame = new JFrame("DeckPaneManager Test");
            jFrame.setResizable(false);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            DeckPaneManager deckPaneManager = null;
            try {
                deckPaneManager = new DeckPaneManager(stringArray[0], stringArray[1], null, jFrame.getContentPane());
            }
            catch (DisplayManagerException displayManagerException) {
                System.exit(-1);
            }
            deckPaneManager.loadData();
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            System.out.println("COMMENCING TEST...");
            try {
                Thread.sleep(5000L);
                deckPaneManager.showPane("IDD_WIZARD_INTRO");
                Thread.sleep(5000L);
                deckPaneManager.showPane("IDD_WIZARD_SCENARIOQUESTION");
                Thread.sleep(5000L);
                deckPaneManager.showPane("IDD_WIZARD_CONNECTIONNAME");
                Thread.sleep(5000L);
                deckPaneManager.showPane("IDD_MOBILE_USERIDS");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("TEST COMPLETE!");
        } else if (stringArray.length == 3) {
            if (!stringArray[0].equalsIgnoreCase("-SERIALIZE")) {
                System.err.println(string);
                System.exit(0);
            }
            try {
                new DeckPaneManager(stringArray[1], null, stringArray[2]);
            }
            catch (DisplayManagerException displayManagerException) {
                System.exit(-1);
            }
        } else if (stringArray.length == 4) {
            if (stringArray[0].equalsIgnoreCase("-LOCALE")) {
                String string2;
                String string3 = stringArray[1];
                String string4 = null;
                int n = string3.indexOf("_");
                if (n == -1) {
                    System.err.println(string);
                    System.exit(0);
                }
                String string5 = string3.substring(0, n);
                if ((n = (string3 = string3.substring(n + 1)).indexOf("_")) == -1) {
                    string2 = string3;
                } else {
                    string2 = string3.substring(0, n);
                    string4 = string3.substring(n + 1);
                }
                Locale locale = string4 == null ? new Locale(string5, string2) : new Locale(string5, string2, string4);
                JFrame jFrame = new JFrame("DeckPaneManager Test");
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                DeckPaneManager deckPaneManager = null;
                try {
                    deckPaneManager = new DeckPaneManager(stringArray[0], locale, stringArray[1], null, jFrame.getContentPane());
                }
                catch (DisplayManagerException displayManagerException) {
                    System.exit(-1);
                }
                deckPaneManager.loadData();
                jFrame.pack();
                ((Component)jFrame).setVisible(true);
            } else {
                System.err.println(string);
                System.exit(0);
            }
        } else if (stringArray.length == 5) {
            if (stringArray[0].equalsIgnoreCase("-SERIALIZE") && stringArray[1].equalsIgnoreCase("-LOCALE")) {
                String string6;
                String string7 = stringArray[2];
                String string8 = null;
                int n = string7.indexOf("_");
                if (n == -1) {
                    System.err.println(string);
                    System.exit(0);
                }
                String string9 = string7.substring(0, n);
                if ((n = (string7 = string7.substring(n + 1)).indexOf("_")) == -1) {
                    string6 = string7;
                } else {
                    string6 = string7.substring(0, n);
                    string8 = string7.substring(n + 1);
                }
                Locale locale = string8 == null ? new Locale(string9, string6) : new Locale(string9, string6, string8);
                try {
                    new DeckPaneManager(stringArray[3], locale, stringArray[4]);
                }
                catch (DisplayManagerException displayManagerException) {
                    System.exit(-1);
                }
            } else {
                System.err.println(string);
                System.exit(0);
            }
        } else {
            System.err.println(string);
            System.exit(0);
        }
    }

    public DeckPaneManager(String string, String string2, DataBean[] dataBeanArray, Container container) throws DisplayManagerException {
        this(string, null, string2, dataBeanArray, container);
    }

    public DeckPaneManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, Container container) throws DisplayManagerException {
        if (container == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullContainerArgument"));
        }
        this.m_dpd = this.constructDeckPaneDefinition(string, locale, string2);
        this.m_locale = locale;
        this.m_dataBeans = dataBeanArray;
        this.m_container = container;
        this.constructUI();
    }

    public DeckPaneManager(String string, Locale locale, String string2) throws DisplayManagerException {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullBaseNameArgument"));
        }
        if (string2 == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullDeckPaneNameArgument"));
        }
        try {
            this.m_dpd = new XMLDeckPaneDefinition(string, locale, string2);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            throw new DisplayManagerException(parseException.getClass().getName());
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError(missingResourceException);
            throw new DisplayManagerException(missingResourceException.getClass().getName());
        }
        catch (PDMLSpecificationException pDMLSpecificationException) {
            pDMLSpecificationException.reportErrors();
            throw new DisplayManagerException(pDMLSpecificationException.getClass().getName());
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
        try {
            this.serialize();
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
    }

    DeckPaneManager(XMLDeckPaneDefinition xMLDeckPaneDefinition, DataBean[] dataBeanArray, Container container, PaneManager paneManager) throws DisplayManagerException {
        if (container == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullContainerArgument"));
        }
        this.debug("deck pane definition: " + xMLDeckPaneDefinition + "  locale: " + xMLDeckPaneDefinition.getDeckPaneDefinitions().m_locale);
        this.setAggregateManager(paneManager);
        this.m_dpd = xMLDeckPaneDefinition;
        this.m_locale = xMLDeckPaneDefinition.getDeckPaneDefinitions().m_locale;
        this.m_dataBeans = dataBeanArray;
        this.m_container = container;
        this.constructUI();
    }

    public void serialize() throws IOException {
        this.saveDeckPaneDefinition(this.m_dpd.getDeckPane().m_name + this.m_dpd.getDeckPaneDefinitions().m_localeString + ".pdml.ser");
    }

    public Dimension getPreferredSize() {
        if (this.m_container != null) {
            return this.m_container.getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    public String getTitle() {
        return this.m_dpd.getDeckPane().m_title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData() {
        if (!this.m_dataLoaded && this.m_container != null) {
            DeckPaneManager deckPaneManager = this;
            synchronized (deckPaneManager) {
                int n = 0;
                while (n < this.m_panels.size()) {
                    PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
                    paneManager.loadData();
                    ++n;
                }
                this.m_dataLoaded = true;
            }
        }
    }

    public void activatePanel() {
        if (this.m_activePanel != null) {
            this.m_activePanel.activatePanel();
        }
    }

    public String[] getPaneNames() {
        String[] stringArray = new String[this.m_panes.size()];
        int n = 0;
        while (n < this.m_panes.size()) {
            PaneDescriptor paneDescriptor = (PaneDescriptor)this.m_panes.elementAt(n);
            stringArray[n] = paneDescriptor.m_paneName;
            ++n;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPane(String string) {
        Object object;
        int n = -1;
        int n2 = 0;
        while (n2 < this.m_panes.size()) {
            object = (PaneDescriptor)this.m_panes.elementAt(n2);
            if (((PaneDescriptor)object).m_paneName.equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        object = this;
        synchronized (object) {
            this.m_container.setCursor(new Cursor(3));
            try {
                while (n >= this.m_panels.size()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.m_container.setCursor(new Cursor(0));
        }
        ((CardLayout)this.m_deckPanePanel.getLayout()).show(this.m_deckPanePanel, string);
        this.m_activePanel = (PaneManager)this.m_panels.elementAt(n);
        this.m_activePanel.activatePanel();
    }

    public Component getComponent(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        return panelManager != null ? panelManager.getComponent(string3) : null;
    }

    public JavaComponentDescriptor getComponentDescriptor(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        return panelManager != null ? panelManager.getComponentDescriptor(string3) : null;
    }

    public PaneManager getDelegateManager(String string) {
        return (PaneManager)this.m_panelTable.get(string);
    }

    public void setAggregateManager(PaneManager paneManager) {
        this.m_aggregateManager = paneManager;
    }

    public PaneManager getAggregateManager() {
        return this.m_aggregateManager;
    }

    public PaneManager getRootManager() {
        PaneManager paneManager = this.m_aggregateManager;
        PaneManager paneManager2 = null;
        while (paneManager != null) {
            paneManager2 = paneManager;
            paneManager = paneManager.getAggregateManager();
        }
        return paneManager2;
    }

    public void applyChanges() throws IllegalUserDataException {
        int n = 0;
        while (n < this.m_panels.size()) {
            PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
            try {
                paneManager.applyChanges();
            }
            catch (IllegalUserDataException illegalUserDataException) {
                PaneDescriptor paneDescriptor = (PaneDescriptor)this.m_panes.elementAt(n);
                this.showPane(paneDescriptor.m_paneName);
                throw (IllegalUserDataException)illegalUserDataException.fillInStackTrace();
            }
            ++n;
        }
    }

    public void prepareToCommit(Vector vector) {
        int n = 0;
        while (n < this.m_panels.size()) {
            PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
            paneManager.prepareToCommit(vector);
            ++n;
        }
    }

    public void commit(Vector vector) {
        int n = 0;
        while (n < this.m_panels.size()) {
            PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
            paneManager.commit(vector);
            ++n;
        }
    }

    public void setFormatter(String string, DataFormatter dataFormatter, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullComponentNameArgument"));
        }
        if (dataFormatter == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullFormatterArgument"));
        }
        int n = string.indexOf(46);
        if (n == -1) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("invalidComponentNameArgument", objectArray));
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        if (panelManager == null) {
            Object[] objectArray = new Object[]{string2, new String(this.m_dpd.getDeckPaneDefinitions().m_baseName + this.m_dpd.getDeckPaneDefinitions().m_localeString)};
            throw new IllegalArgumentException(SystemResourceFinder.format("panelNotFound", objectArray));
        }
        panelManager.setFormatter(string3, dataFormatter, bl);
    }

    public DataFormatter getFormatter(String string) {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullComponentNameArgument"));
        }
        int n = string.indexOf(46);
        if (n == -1) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("invalidComponentNameArgument", objectArray));
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        if (panelManager == null) {
            return null;
        }
        return panelManager.getFormatter(string3);
    }

    public void setHelpPath(String string) {
        Enumeration enumeration = this.m_panelTable.elements();
        while (enumeration.hasMoreElements()) {
            PaneManager paneManager = (PaneManager)enumeration.nextElement();
            paneManager.setHelpPath(string);
        }
    }

    public void addPane(PanelManager panelManager, int n) {
        panelManager.setAggregateManager(this);
        panelManager.setFocusPolicy(false);
        this.m_panels.insertElementAt(panelManager, n);
        this.m_panelTable.put(panelManager.getName(), panelManager);
        PaneDescriptor paneDescriptor = new PaneDescriptor();
        paneDescriptor.m_paneName = panelManager.getName();
        paneDescriptor.m_paneType = "PANEL";
        this.m_panes.insertElementAt(paneDescriptor, n);
        this.m_deckPanePanel.add((Component)panelManager.getContainer(), panelManager.getName());
    }

    public void removePane(String string) {
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string);
        int n = this.m_panels.indexOf(panelManager);
        if (n != -1) {
            this.removePane(n);
        }
    }

    public void removePane(int n) {
        this.m_deckPanePanel.remove(n);
        PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
        this.m_panels.removeElement(paneManager);
        this.m_panelTable.remove(((PaneDescriptor)this.m_panes.elementAt((int)n)).m_paneName);
        this.m_panes.removeElementAt(n);
        paneManager.setAggregateManager(null);
    }

    private XMLDeckPaneDefinition constructDeckPaneDefinition(String string, Locale locale, String objectArray) throws DisplayManagerException {
        Object object;
        XMLDeckPaneDefinition xMLDeckPaneDefinition;
        block17: {
            Locale locale2;
            if (string == null) {
                throw new IllegalArgumentException(SystemResourceFinder.format("nullBaseNameArgument"));
            }
            if (objectArray == null) {
                throw new IllegalArgumentException(SystemResourceFinder.format("nullDeckPaneNameArgument"));
            }
            xMLDeckPaneDefinition = null;
            Locale locale3 = locale2 = locale != null ? locale : Locale.getDefault();
            if (UIFramework.getSearchMode() != 3) {
                int n = string.lastIndexOf(46);
                object = n != -1 ? string.substring(0, n) + "/" + (String)objectArray : objectArray;
                try {
                    xMLDeckPaneDefinition = this.loadDeckPaneDefinition((String)object, locale);
                }
                catch (MissingResourceException missingResourceException) {
                    if (UIFramework.getSearchMode() == 1) {
                        Object[] objectArray2 = new Object[]{new String((String)objectArray + "_" + locale2)};
                        MessageLog.logError(SystemResourceFinder.format("serializedDeckPaneNotFound", objectArray2));
                        throw new DisplayManagerException(missingResourceException.getClass().getName());
                    }
                }
                catch (IOException iOException) {
                    MessageLog.printStackTrace(iOException);
                    if (UIFramework.getSearchMode() == 1) {
                        throw new DisplayManagerException(iOException.getClass().getName());
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MessageLog.printStackTrace(classNotFoundException);
                    if (UIFramework.getSearchMode() != 1) break block17;
                    throw new DisplayManagerException(classNotFoundException.getClass().getName());
                }
            }
        }
        if (xMLDeckPaneDefinition != null) {
            object = new Object[]{new String((String)objectArray + SystemResourceFinder.getLastDocumentLocale() + ".pdml.ser")};
            MessageLog.traceOut(SystemResourceFinder.format("deckPaneLoaded", object));
            if (m_descriptorTrace) {
                xMLDeckPaneDefinition.dump();
            }
            return xMLDeckPaneDefinition;
        }
        try {
            xMLDeckPaneDefinition = new XMLDeckPaneDefinition(string, locale, (String)objectArray);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            throw new DisplayManagerException(parseException.getClass().getName());
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError(missingResourceException);
            throw new DisplayManagerException(missingResourceException.getClass().getName());
        }
        catch (PDMLSpecificationException pDMLSpecificationException) {
            pDMLSpecificationException.reportErrors();
            throw new DisplayManagerException(pDMLSpecificationException.getClass().getName());
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
        object = new Object[]{objectArray, new String(xMLDeckPaneDefinition.getDeckPaneDefinitions().m_baseName + xMLDeckPaneDefinition.getDeckPaneDefinitions().m_localeString)};
        MessageLog.traceOut(SystemResourceFinder.format("deckPaneParsed", object));
        if (m_descriptorTrace) {
            xMLDeckPaneDefinition.dump();
        }
        return xMLDeckPaneDefinition;
    }

    private XMLDeckPaneDefinition loadDeckPaneDefinition(String string, Locale locale) throws IOException, ClassNotFoundException {
        InputStream inputStream = SystemResourceFinder.getSerializedPDMLDocument(string, locale);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
        XMLDeckPaneDefinition xMLDeckPaneDefinition = (XMLDeckPaneDefinition)objectInputStream.readObject();
        objectInputStream.close();
        return xMLDeckPaneDefinition;
    }

    private void saveDeckPaneDefinition(String string) throws IOException {
        Object[] objectArray = new Object[]{string};
        MessageLog.traceOut(SystemResourceFinder.format("deckPaneSaved", objectArray));
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
        objectOutputStream.writeObject(this.m_dpd);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    private void constructUI() throws DisplayManagerException {
        LookAndFeelManager.setLookAndFeel();
        this.m_deckPanePanel = new JPanel(new CardLayout(), false);
        if (UIFramework.isDynamicResizingEnabled()) {
            this.m_container.setLayout(new BorderLayout());
            this.m_container.add((Component)this.m_deckPanePanel, "Center");
        } else {
            this.m_container.setLayout(new FlowLayout(1, 0, 0));
            this.m_container.add(this.m_deckPanePanel);
        }
        this.m_panes = this.m_dpd.getPanes();
        if (this.m_panes.isEmpty()) {
            return;
        }
        JPanel jPanel = new JPanel(false);
        this.m_deckPanePanel.add((Component)jPanel, "@BLANK");
        int n = 0;
        while (n < this.m_panes.size()) {
            block11: {
                JPanel jPanel2;
                PaneDescriptor paneDescriptor;
                block10: {
                    PaneManager paneManager;
                    block9: {
                        paneDescriptor = (PaneDescriptor)this.m_panes.elementAt(n);
                        jPanel2 = new JPanel(false);
                        if (!paneDescriptor.m_paneType.equals("PANEL")) break block9;
                        paneManager = UIFramework.isDynamicResizingEnabled() ? new DynamicPanelManager(paneDescriptor.m_baseName, this.m_locale, paneDescriptor.m_paneName, this.m_dataBeans, (Container)jPanel2) : new PanelManager(paneDescriptor.m_baseName, this.m_locale, paneDescriptor.m_paneName, this.m_dataBeans, jPanel2);
                        ((PanelManager)paneManager).setAggregateManager(this);
                        this.m_panels.addElement(paneManager);
                        this.m_panelTable.put(paneDescriptor.m_paneName, paneManager);
                        ((PanelManager)paneManager).activatePanel();
                        if (!((PanelManager)paneManager).isContainerScrollable()) break block10;
                        JScrollPane jScrollPane = new JScrollPane(jPanel2);
                        jScrollPane.setBorder(null);
                        this.m_deckPanePanel.add((Component)jScrollPane, paneDescriptor.m_paneName);
                        break block11;
                    }
                    if (paneDescriptor.m_paneType.equals("SPLIT")) {
                        paneManager = new SplitPaneManager(paneDescriptor.m_baseName, this.m_locale, paneDescriptor.m_paneName, this.m_dataBeans, jPanel2);
                        ((SplitPaneManager)paneManager).setAggregateManager(this);
                        this.m_panels.addElement(paneManager);
                        this.m_panelTable.put(paneDescriptor.m_paneName, paneManager);
                    } else if (paneDescriptor.m_paneType.equals("DECK")) {
                        paneManager = new DeckPaneManager(paneDescriptor.m_baseName, this.m_locale, paneDescriptor.m_paneName, this.m_dataBeans, jPanel2);
                        ((DeckPaneManager)paneManager).setAggregateManager(this);
                        this.m_panels.addElement(paneManager);
                        this.m_panelTable.put(paneDescriptor.m_paneName, paneManager);
                    } else if (paneDescriptor.m_paneType.equals("TAB")) {
                        paneManager = new TabbedPaneManager(paneDescriptor.m_baseName, this.m_locale, paneDescriptor.m_paneName, this.m_dataBeans, jPanel2);
                        ((TabbedPaneManager)paneManager).setAggregateManager(this);
                        this.m_panels.addElement(paneManager);
                        this.m_panelTable.put(paneDescriptor.m_paneName, paneManager);
                    }
                }
                this.m_deckPanePanel.add((Component)jPanel2, paneDescriptor.m_paneName);
            }
            ++n;
        }
    }

    private void debug(String string) {
        if (m_descriptorTrace) {
            System.out.println("DeckPaneManager: " + string);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }

    private class PaneLoader
    implements Runnable {
        private PaneLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = 1;
            while (n < DeckPaneManager.this.m_panes.size()) {
                block29: {
                    DeckPaneManager deckPaneManager;
                    PaneManager paneManager;
                    PaneDescriptor paneDescriptor = (PaneDescriptor)DeckPaneManager.this.m_panes.elementAt(n);
                    JPanel jPanel = new JPanel(false);
                    if (paneDescriptor.m_paneType.equals("PANEL")) {
                        paneManager = null;
                        try {
                            paneManager = UIFramework.isDynamicResizingEnabled() ? new DynamicPanelManager(paneDescriptor.m_baseName, DeckPaneManager.this.m_locale, paneDescriptor.m_paneName, DeckPaneManager.this.m_dataBeans, (Container)jPanel) : new PanelManager(paneDescriptor.m_baseName, DeckPaneManager.this.m_locale, paneDescriptor.m_paneName, DeckPaneManager.this.m_dataBeans, jPanel);
                        }
                        catch (DisplayManagerException displayManagerException) {
                            break block29;
                        }
                        ((PanelManager)paneManager).setAggregateManager(DeckPaneManager.this);
                        if (DeckPaneManager.this.m_dataLoaded) {
                            ((PanelManager)paneManager).loadData();
                        }
                        deckPaneManager = DeckPaneManager.this;
                        synchronized (deckPaneManager) {
                            DeckPaneManager.this.m_panels.addElement(paneManager);
                            DeckPaneManager.this.m_panelTable.put(paneDescriptor.m_paneName, paneManager);
                            DeckPaneManager.this.m_deckPanePanel.add((Component)jPanel, paneDescriptor.m_paneName);
                            DeckPaneManager.this.notifyAll();
                        }
                    }
                    if (paneDescriptor.m_paneType.equals("SPLIT")) {
                        paneManager = null;
                        try {
                            paneManager = new SplitPaneManager(paneDescriptor.m_baseName, DeckPaneManager.this.m_locale, paneDescriptor.m_paneName, DeckPaneManager.this.m_dataBeans, jPanel);
                        }
                        catch (DisplayManagerException displayManagerException) {
                            break block29;
                        }
                        ((SplitPaneManager)paneManager).setAggregateManager(DeckPaneManager.this);
                        if (DeckPaneManager.this.m_dataLoaded) {
                            ((SplitPaneManager)paneManager).loadData();
                        }
                        deckPaneManager = DeckPaneManager.this;
                        synchronized (deckPaneManager) {
                            DeckPaneManager.this.m_panels.addElement(paneManager);
                            DeckPaneManager.this.m_panelTable.put(paneDescriptor.m_paneName, paneManager);
                            DeckPaneManager.this.m_deckPanePanel.add((Component)jPanel, paneDescriptor.m_paneName);
                            DeckPaneManager.this.notifyAll();
                        }
                    }
                    if (paneDescriptor.m_paneType.equals("DECK")) {
                        paneManager = null;
                        try {
                            paneManager = new DeckPaneManager(paneDescriptor.m_baseName, DeckPaneManager.this.m_locale, paneDescriptor.m_paneName, DeckPaneManager.this.m_dataBeans, jPanel);
                        }
                        catch (DisplayManagerException displayManagerException) {
                            break block29;
                        }
                        ((DeckPaneManager)paneManager).setAggregateManager(DeckPaneManager.this);
                        if (DeckPaneManager.this.m_dataLoaded) {
                            ((DeckPaneManager)paneManager).loadData();
                        }
                        deckPaneManager = DeckPaneManager.this;
                        synchronized (deckPaneManager) {
                            DeckPaneManager.this.m_panels.addElement(paneManager);
                            DeckPaneManager.this.m_panelTable.put(paneDescriptor.m_paneName, paneManager);
                            DeckPaneManager.this.m_deckPanePanel.add((Component)jPanel, paneDescriptor.m_paneName);
                            DeckPaneManager.this.notifyAll();
                        }
                    }
                    if (paneDescriptor.m_paneType.equals("TAB")) {
                        paneManager = null;
                        try {
                            paneManager = new TabbedPaneManager(paneDescriptor.m_baseName, DeckPaneManager.this.m_locale, paneDescriptor.m_paneName, DeckPaneManager.this.m_dataBeans, jPanel);
                        }
                        catch (DisplayManagerException displayManagerException) {
                            break block29;
                        }
                        ((TabbedPaneManager)paneManager).setAggregateManager(DeckPaneManager.this);
                        if (DeckPaneManager.this.m_dataLoaded) {
                            ((TabbedPaneManager)paneManager).loadData();
                        }
                        deckPaneManager = DeckPaneManager.this;
                        synchronized (deckPaneManager) {
                            DeckPaneManager.this.m_panels.addElement(paneManager);
                            DeckPaneManager.this.m_panelTable.put(paneDescriptor.m_paneName, paneManager);
                            DeckPaneManager.this.m_deckPanePanel.add((Component)jPanel, paneDescriptor.m_paneName);
                            DeckPaneManager.this.notifyAll();
                        }
                    }
                }
                ++n;
            }
            DeckPaneManager.this.m_container.validate();
            DeckPaneManager.this.m_container.repaint();
        }
    }
}

