/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework;

import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class XMLSAXErrorHandler
implements ErrorHandler {
    private String m_filename;
    private int m_headerLineCount;
    private boolean m_ignorePDML = false;
    private ParseException m_exc;

    public XMLSAXErrorHandler(String string, int n) {
        this.m_filename = string;
        this.m_headerLineCount = n;
    }

    public void error(SAXParseException sAXParseException) {
        String string;
        int n = sAXParseException.getLineNumber();
        int n2 = sAXParseException.getColumnNumber();
        if (n - this.m_headerLineCount <= 0) {
            string = "pdmlHeader.xml";
            this.m_ignorePDML = true;
        } else if (!this.m_ignorePDML) {
            string = this.m_filename;
            n -= this.m_headerLineCount;
        } else {
            return;
        }
        if (this.m_exc == null) {
            Object[] objectArray = new Object[]{string};
            this.m_exc = new ParseException(SystemResourceFinder.format("failedToParse", objectArray));
        }
        this.m_exc.addMessage("[" + n + "," + (n2 - 1) + "]: " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.error(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        String string;
        int n = sAXParseException.getLineNumber();
        int n2 = sAXParseException.getColumnNumber();
        if (n - this.m_headerLineCount <= 0) {
            string = "pdml.dtd";
        } else {
            string = this.m_filename;
            n -= this.m_headerLineCount;
        }
        System.err.println(string + "[" + n + "," + (n2 - 1) + "]: " + sAXParseException.getMessage());
    }

    public ParseException getException() {
        return this.m_exc;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

