/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework;

import com.ibm.as400.ui.framework.AbortException;
import com.ibm.as400.ui.framework.FrameworkDefaults;
import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.PanelDefinitionsDescriptor;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.PropertyPageDescriptor;
import com.ibm.as400.ui.framework.PropertySheetDescriptor;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.XMLPanelDefinition;
import com.ibm.as400.ui.framework.XMLSAXErrorHandler;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;

public class XMLPropertySheetDefinition
implements Serializable,
DocumentHandler {
    private transient String m_baseName;
    private transient Locale m_locale;
    private transient String m_propertySheetName;
    private transient ResourceBundle m_bundle;
    private transient String m_documentName;
    private transient String m_sxml = null;
    private static transient boolean m_bElementTrace = false;
    private transient PDMLSpecificationException m_pdmlException = null;
    private PanelDefinitionsDescriptor m_propertySheetDefinitions = new PanelDefinitionsDescriptor();
    private PropertySheetDescriptor m_propertySheetDescriptor = new PropertySheetDescriptor();
    private Vector m_propertyPageDescriptors = new Vector();
    static final long serialVersionUID = 6826304896183497188L;
    private String m_chars = "";
    private Stack m_stack = null;
    private boolean found = false;

    public static void main(String[] stringArray) {
        System.setErr(System.out);
        m_bElementTrace = true;
        if (stringArray.length == 2) {
            XMLPropertySheetDefinition xMLPropertySheetDefinition;
            try {
                xMLPropertySheetDefinition = new XMLPropertySheetDefinition(stringArray[0], null, stringArray[1]);
            }
            catch (ParseException parseException) {
                parseException.reportErrors();
                return;
            }
            catch (PDMLSpecificationException pDMLSpecificationException) {
                pDMLSpecificationException.reportErrors();
                return;
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println(missingResourceException);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            xMLPropertySheetDefinition.dump();
        } else {
            System.out.println("Arguments are: <resource bundle name> <panel name>");
        }
    }

    public XMLPropertySheetDefinition(String string, Locale locale, String string2) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_locale = locale;
        this.m_propertySheetName = string2;
        this.m_documentName = locale != null ? this.m_baseName + "_" + locale.toString() + ".pdml" : this.m_baseName + ".pdml";
        try {
            this.m_bundle = FrameworkDefaults.m_resourceMode == 1 ? (locale != null ? ResourceBundle.getBundle(string, locale) : ResourceBundle.getBundle(string)) : SystemResourceFinder.getUncachedBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            Object[] objectArray = new Object[]{string};
            throw new MissingResourceException(SystemResourceFinder.format("resourceBundleNotFound", objectArray), missingResourceException.getClassName(), missingResourceException.getKey());
        }
        this.parseXML(false);
        if (this.m_pdmlException != null) {
            throw this.m_pdmlException;
        }
    }

    public XMLPropertySheetDefinition(String string, Locale locale) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_locale = locale;
        this.m_documentName = locale != null ? this.m_baseName + "_" + locale.toString() + ".pdml" : this.m_baseName + ".pdml";
        try {
            this.m_bundle = locale != null ? ResourceBundle.getBundle(string, locale) : ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            Object[] objectArray = new Object[]{string};
            throw new MissingResourceException(SystemResourceFinder.format("resourceBundleNotFound", objectArray), missingResourceException.getClassName(), missingResourceException.getKey());
        }
        this.parseXML(false);
        if (this.m_pdmlException != null) {
            throw this.m_pdmlException;
        }
    }

    public XMLPropertySheetDefinition(String string, ResourceBundle resourceBundle, String string2, String string3, PanelDefinitionsDescriptor panelDefinitionsDescriptor) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_propertySheetName = string2;
        this.m_bundle = resourceBundle;
        this.m_documentName = this.addLocale(this.m_baseName, panelDefinitionsDescriptor.m_localeString) + ".pdml";
        this.m_propertySheetDefinitions = panelDefinitionsDescriptor;
        this.m_sxml = string3;
        this.parseXML(true);
        if (this.m_pdmlException != null) {
            throw this.m_pdmlException;
        }
    }

    public XMLPropertySheetDefinition(String string) {
        this.m_propertySheetName = string;
        this.m_propertySheetDescriptor.m_name = string;
    }

    public PanelDefinitionsDescriptor getPropertySheetDefinitions() {
        return this.m_propertySheetDefinitions;
    }

    public PropertySheetDescriptor getPropertySheet() {
        return this.m_propertySheetDescriptor;
    }

    public Vector getPropertySheetPages() {
        return this.m_propertyPageDescriptors;
    }

    public String toString() {
        return this.getClass().getName() + "[baseName=" + this.m_baseName + ",propertySheetName=" + this.m_propertySheetName + "]";
    }

    public void dump() {
        System.out.println(this.m_propertySheetDefinitions);
        System.out.println(this.m_propertySheetDescriptor);
        Enumeration enumeration = this.m_propertyPageDescriptors.elements();
        while (enumeration.hasMoreElements()) {
            PropertyPageDescriptor propertyPageDescriptor = (PropertyPageDescriptor)enumeration.nextElement();
            System.out.println(propertyPageDescriptor);
        }
    }

    private String addLocale(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        if (string2.trim().length() == 0) {
            return string;
        }
        return string + "_" + string2;
    }

    private void parseXML(boolean bl) throws MissingResourceException, IOException, ParseException {
        InputStream inputStream = SystemResourceFinder.getPDMLHeader();
        InputStream inputStream2 = null;
        inputStream2 = !bl ? SystemResourceFinder.getPDMLDocument(this.m_baseName, this.m_locale) : new BufferedInputStream(new FileInputStream(this.m_sxml));
        String string = this.m_baseName + SystemResourceFinder.getLastDocumentLocale() + ".pdml";
        XMLSAXErrorHandler xMLSAXErrorHandler = new XMLSAXErrorHandler(this.m_documentName, SystemResourceFinder.getHeaderLineCount());
        Object object = XMLPanelDefinition.getParser(this, xMLSAXErrorHandler);
        SequenceInputStream sequenceInputStream = new SequenceInputStream(inputStream, inputStream2);
        InputSource inputSource = new InputSource(sequenceInputStream);
        XMLPanelDefinition.introspectMethod(object, "parse", new Object[]{inputSource}, new Class[]{inputSource.getClass()}, this.m_baseName);
        sequenceInputStream.close();
        ParseException parseException = xMLSAXErrorHandler.getException();
        if (parseException != null) {
            throw parseException;
        }
    }

    private void processError(String string) {
        if (this.m_pdmlException == null) {
            Object[] objectArray = new Object[]{this.m_documentName};
            this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
        }
        this.m_pdmlException.addMessage(string);
    }

    private void processError(Throwable throwable, String string) {
        Object[] objectArray;
        if (this.m_pdmlException == null) {
            objectArray = new Object[]{this.m_documentName};
            this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
        }
        if (throwable instanceof NumberFormatException) {
            objectArray = new Object[]{throwable.getMessage(), string};
            this.m_pdmlException.addMessage(SystemResourceFinder.format("valueNotNumeric", objectArray));
        } else {
            objectArray = new Object[]{throwable.toString(), string};
            this.m_pdmlException.addMessage(SystemResourceFinder.format("unknownValidationError", objectArray));
        }
    }

    public void startDocument() {
        this.m_stack = new Stack();
    }

    public void endDocument() {
        if (this.m_propertySheetDescriptor.m_name == null) {
            if (this.m_locale == null) {
                Object[] objectArray = new Object[]{this.m_propertySheetName, this.m_baseName};
                throw new MissingResourceException(SystemResourceFinder.format("propertySheetNotFound", objectArray), this.m_baseName, this.m_propertySheetName);
            }
            Object[] objectArray = new Object[]{this.m_propertySheetName, new String(this.m_baseName + "_" + this.m_locale)};
            throw new MissingResourceException(SystemResourceFinder.format("propertySheetNotFound", objectArray), this.m_baseName + "_" + this.m_locale, this.m_propertySheetName);
        }
        this.m_stack = null;
    }

    public void startElement(String string, AttributeList attributeList) {
        if (this.found) {
            this.debug("<" + string + ">");
        }
        if (!this.found) {
            if (string.equalsIgnoreCase("PDML")) {
                this.m_propertySheetDefinitions.m_baseName = this.m_baseName;
                this.debug("Base name: " + this.m_propertySheetDefinitions.m_baseName);
                this.m_propertySheetDefinitions.m_locale = this.m_locale;
                this.m_propertySheetDefinitions.m_localeString = SystemResourceFinder.getLastDocumentLocale();
                this.debug("Locale string: " + this.m_propertySheetDefinitions.m_localeString);
                int n = 0;
                while (n < attributeList.getLength()) {
                    block31: {
                        String string2 = attributeList.getName(n);
                        String string3 = attributeList.getValue(n).trim();
                        if (string2.equalsIgnoreCase("VERSION")) {
                            this.m_propertySheetDefinitions.m_version = string3;
                            this.debug("Version: " + this.m_propertySheetDefinitions.m_version);
                        } else if (string2.equalsIgnoreCase("SOURCE")) {
                            this.m_propertySheetDefinitions.m_source = string3.toUpperCase();
                            this.debug("Source: " + this.m_propertySheetDefinitions.m_source);
                        } else if (string2.equalsIgnoreCase("BASESCREENSIZE")) {
                            Object[] objectArray;
                            String string4 = string3;
                            int n2 = string4.indexOf(120);
                            if (n2 == -1) {
                                this.debug("Base Screen Size '" + string4 + "' invalid");
                                objectArray = new Object[]{string4, string2.toString()};
                                this.processError(SystemResourceFinder.format("baseScreenSizeNotValid", objectArray));
                            } else {
                                objectArray = string4.substring(0, n2).trim();
                                String string5 = string4.substring(n2 + 1).trim();
                                try {
                                    int n3 = Integer.parseInt((String)objectArray);
                                    int n4 = Integer.parseInt(string5);
                                    this.m_propertySheetDefinitions.m_baseScreenSize.setSize(n3, n4);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.debug("Base Screen Size '" + string4 + "' invalid");
                                    this.processError(numberFormatException, string2 + "= " + string3);
                                    break block31;
                                }
                                this.debug("Storing base screen size: " + string4);
                            }
                        }
                    }
                    ++n;
                }
            } else if (string.equals("PROPERTYSHEET")) {
                int n = 0;
                while (n < attributeList.getLength()) {
                    String string6 = attributeList.getName(n);
                    String string7 = attributeList.getValue(n).trim();
                    if (string6.equalsIgnoreCase("NAME") && string7 != null && string7.equals(this.m_propertySheetName)) {
                        this.found = true;
                        this.m_propertySheetDescriptor.m_name = string7;
                        this.m_stack.push(this.m_propertySheetDescriptor);
                    }
                    ++n;
                }
            }
        } else if (string.equalsIgnoreCase("TITLE")) {
            this.m_stack.push(string);
        } else if (string.equalsIgnoreCase("ICON")) {
            int n = 0;
            while (n < attributeList.getLength()) {
                Object[] objectArray;
                String string8 = attributeList.getName(n);
                String string9 = attributeList.getValue(n).trim();
                if (string8.equalsIgnoreCase("POSITION")) {
                    objectArray = new Object[]{this.m_propertySheetDescriptor.toString()};
                    this.processError(SystemResourceFinder.format("positionOnlyValidForButton", objectArray));
                } else if (string8.equalsIgnoreCase("VPOSITION")) {
                    objectArray = new Object[]{this.m_propertySheetDescriptor.toString()};
                    this.processError(SystemResourceFinder.format("vpositionOnlyValidForButton", objectArray));
                }
                ++n;
            }
            this.m_stack.push(string);
        } else if (string.equalsIgnoreCase("PAGE")) {
            PropertyPageDescriptor propertyPageDescriptor = new PropertyPageDescriptor();
            int n = 0;
            while (n < attributeList.getLength()) {
                String string10 = attributeList.getName(n);
                String string11 = attributeList.getValue(n).trim();
                if (string10.equalsIgnoreCase("NAME")) {
                    propertyPageDescriptor.m_pageName = string11;
                } else if (string10.equalsIgnoreCase("RESOURCE")) {
                    propertyPageDescriptor.m_baseName = string11;
                }
                ++n;
            }
            this.debug("Storing resource name: " + propertyPageDescriptor.m_baseName);
            this.debug("Storing page name: " + propertyPageDescriptor.m_pageName);
            this.m_propertyPageDescriptors.addElement(propertyPageDescriptor);
            this.m_stack.push(propertyPageDescriptor);
        }
    }

    public void endElement(String string) {
        if (!this.m_chars.equals("")) {
            this.writeChars();
            this.m_chars = "";
        }
        if (this.found) {
            this.m_stack.pop();
            if (this.m_stack.empty()) {
                this.found = false;
                throw new AbortException();
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (!this.found) {
            return;
        }
        if (!(this.m_stack.peek() instanceof String)) {
            this.debug("STRING expected on the stack");
            return;
        }
        this.m_chars = this.m_chars + new String(cArray, n, n2).trim();
    }

    private void writeChars() {
        String string = this.m_chars;
        String string2 = (String)this.m_stack.pop();
        if (string2.equalsIgnoreCase("TITLE")) {
            this.m_propertySheetDescriptor.m_title = string;
            this.m_propertySheetDescriptor.m_titleBundle = string;
            try {
                this.m_propertySheetDescriptor.m_title = this.m_bundle.getString(this.m_propertySheetDescriptor.m_titleBundle);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.debug("Storing property sheet title: " + this.m_propertySheetDescriptor.m_title);
        } else if (string2.equalsIgnoreCase("ICON")) {
            this.m_propertySheetDescriptor.m_icon = string;
            this.m_propertySheetDescriptor.m_iconBundle = string;
            try {
                this.m_propertySheetDescriptor.m_icon = this.m_bundle.getString(this.m_propertySheetDescriptor.m_iconBundle);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.debug("Storing property sheet icon: " + this.m_propertySheetDescriptor.m_icon);
        }
        this.m_stack.push(string2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    public void skippedEntity(String string) {
    }

    private void debug(String string) {
        if (m_bElementTrace) {
            System.out.println("XMLPropertySheetDefinition: " + string);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

