/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.micro.JdbcMeConnection;
import com.ibm.as400.micro.JdbcMeDriver;
import com.ibm.as400.micro.JdbcMeException;
import com.ibm.as400.micro.JdbcMeLiveResultSet;
import com.ibm.as400.micro.JdbcMeOfflineData;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JdbcMeStatement
implements Statement {
    JdbcMeConnection connection_ = null;
    private int statementId_ = -1;
    private int updateCount_ = -1;
    private JdbcMeLiveResultSet rs_ = null;
    int numColumns_ = 0;
    int[] columnTypes_ = null;
    int type_ = 1003;
    int concurrency_ = 1007;

    JdbcMeStatement(JdbcMeConnection jdbcMeConnection, int n) throws JdbcMeException {
        this.connection_ = jdbcMeConnection;
        this.statementId_ = n;
    }

    public void close() throws JdbcMeException {
        try {
            this.connection_.system_.toServer_.writeInt(4705);
            this.connection_.system_.toServer_.writeInt(this.statementId_);
            this.connection_.system_.toServer_.flush();
            if (this.rs_ != null) {
                this.rs_.closeHard();
            }
            return;
        }
        catch (IOException iOException) {
            this.connection_.disconnected();
            throw new JdbcMeException(iOException.toString(), null);
        }
    }

    public ResultSet executeQuery(String string) throws JdbcMeException {
        boolean bl = this.execute(string);
        if (bl) {
            return this.getResultSet();
        }
        return null;
    }

    public int executeUpdate(String string) throws JdbcMeException {
        boolean bl = this.execute(string);
        if (bl) {
            return -1;
        }
        return this.updateCount_;
    }

    public boolean execute(String string) throws JdbcMeException {
        try {
            this.updateCount_ = -1;
            if (this.rs_ != null) {
                this.rs_.closeHard();
                this.rs_ = null;
            }
            this.connection_.system_.toServer_.writeInt(4706);
            this.connection_.system_.toServer_.writeInt(this.statementId_);
            this.connection_.system_.toServer_.writeUTF(string);
            this.connection_.system_.toServer_.flush();
            int n = this.connection_.system_.fromServer_.readInt();
            if (n == -1) {
                JdbcMeDriver.processException(this.connection_);
            }
            if (n == 0) {
                this.updateCount_ = this.connection_.system_.fromServer_.readInt();
                return false;
            }
            int n2 = this.connection_.system_.fromServer_.readInt();
            this.rs_ = new JdbcMeLiveResultSet(this, n2);
            this.numColumns_ = this.connection_.system_.fromServer_.readInt();
            this.columnTypes_ = new int[this.numColumns_];
            for (int i = 0; i < this.numColumns_; ++i) {
                this.columnTypes_[i] = this.connection_.system_.fromServer_.readInt();
            }
            return true;
        }
        catch (IOException iOException) {
            this.connection_.disconnected();
            throw new JdbcMeException(iOException.toString(), null);
        }
    }

    public boolean executeToOfflineData(String string, String string2, int n, int n2) throws JdbcMeException {
        boolean bl = this.execute(string);
        if (!bl) {
            return false;
        }
        JdbcMeOfflineData jdbcMeOfflineData = null;
        try {
            int n3;
            jdbcMeOfflineData = JdbcMeOfflineData.create(string2, n, n2);
            if (jdbcMeOfflineData == null) {
                throw new JdbcMeException("Couldn't open/create DB " + string2, null);
            }
            byte[] byArray = new byte[4];
            ResultSet resultSet = this.getResultSet();
            byArray[0] = 74;
            byArray[1] = 68;
            byArray[2] = 66;
            byArray[3] = 67;
            jdbcMeOfflineData.addRecord(byArray, 0, byArray.length);
            int n4 = 1;
            byArray[0] = (byte)((0xFF000000 & n4) >>> 24);
            byArray[1] = (byte)((0xFF0000 & n4) >>> 16);
            byArray[2] = (byte)((0xFF00 & n4) >>> 8);
            byArray[3] = (byte)((0xFF & n4) >>> 0);
            jdbcMeOfflineData.addRecord(byArray, 0, byArray.length);
            byArray[0] = (byte)((0xFF000000 & this.numColumns_) >>> 24);
            byArray[1] = (byte)((0xFF0000 & this.numColumns_) >>> 16);
            byArray[2] = (byte)((0xFF00 & this.numColumns_) >>> 8);
            byArray[3] = (byte)((0xFF & this.numColumns_) >>> 0);
            jdbcMeOfflineData.addRecord(byArray, 0, byArray.length);
            byArray = new byte[4 * this.numColumns_];
            for (n3 = 0; n3 < this.numColumns_; ++n3) {
                byArray[n3 * 4 + 0] = (byte)((0xFF000000 & this.columnTypes_[n3]) >>> 24);
                byArray[n3 * 4 + 1] = (byte)((0xFF0000 & this.columnTypes_[n3]) >>> 16);
                byArray[n3 * 4 + 2] = (byte)((0xFF00 & this.columnTypes_[n3]) >>> 8);
                byArray[n3 * 4 + 3] = (byte)((0xFF & this.columnTypes_[n3]) >>> 0);
            }
            jdbcMeOfflineData.addRecord(byArray, 0, byArray.length);
            byArray = null;
            String string3 = null;
            while (resultSet.next()) {
                for (n3 = 1; n3 <= this.numColumns_; ++n3) {
                    string3 = resultSet.getString(n3);
                    byArray = string3.getBytes();
                    jdbcMeOfflineData.addRecord(byArray, 0, byArray.length);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new JdbcMeException(sQLException.getMessage(), sQLException.getSQLState());
        }
        finally {
            if (jdbcMeOfflineData != null) {
                jdbcMeOfflineData.close();
                jdbcMeOfflineData = null;
            }
            System.gc();
        }
        return true;
    }

    public ResultSet getResultSet() throws JdbcMeException {
        return this.rs_;
    }

    public int getResultSetConcurrency() throws JdbcMeException {
        return this.concurrency_;
    }

    public int getResultSetType() throws JdbcMeException {
        return this.type_;
    }

    public int getUpdateCount() throws JdbcMeException {
        return this.updateCount_;
    }

    public Connection getConnection() throws JdbcMeException {
        return this.connection_;
    }
}

