/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.guimain;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.RootPaneContainer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.phbwt.jtans.calc.CalcFigure;
import net.phbwt.jtans.calc.DisplayFigure;
import net.phbwt.jtans.calc.EditableFigure;
import net.phbwt.jtans.guicommon.Config;
import net.phbwt.jtans.guicommon.FigureGroup;
import net.phbwt.jtans.guimain.DisplayFigureComponent;
import net.phbwt.jtans.guimain.EditableFigureComponent;
import net.phbwt.jtans.guimain.LayoutCarre;
import net.phbwt.jtans.guimain.StatusBar;

public class MainWindow
extends Observable
implements Observer {
    private static final boolean DEBUG = false;
    private static final int BUTTON_GAP = 5;
    private EditableFigureComponent grandeArea;
    private DisplayFigureComponent petiteArea;
    private StatusBar statusBar;
    private Config config;
    private Method setMaxMethod;
    private Method setValMethod;
    private Object setValMaxObject;
    private List actualList;
    private String actualName;
    private int actualFigNr;
    private static ResourceBundle i18n = null;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$java$lang$Comparable;
    static /* synthetic */ Class class$java$lang$Object;

    public MainWindow(Config config) {
        if (i18n == null) {
            i18n = ResourceBundle.getBundle("net.phbwt.jtans.i18n.main");
        }
        this.config = config;
        this.config.addObserver(this);
        FigureGroup figureGroup = config.getFigureGroup("main.figureList");
        this.actualList = figureGroup.getListNoError();
        this.actualName = figureGroup.getName();
        this.actualFigNr = 0;
    }

    public void fill(RootPaneContainer rootPaneContainer) {
        CalcFigure calcFigure = ((CalcFigure.StoredFigure)this.actualList.get(this.actualFigNr)).getCalcFigure();
        CalcFigure calcFigure2 = new CalcFigure();
        EditableFigure editableFigure = new EditableFigure(calcFigure2);
        DisplayFigure displayFigure = new DisplayFigure(calcFigure);
        DisplayFigure displayFigure2 = new DisplayFigure(calcFigure);
        this.petiteArea = new DisplayFigureComponent(displayFigure2, this.config, this.config.isSolved(this.actualName, this.actualFigNr));
        this.petiteArea.setPreferredSize(new Dimension(140, 140));
        this.petiteArea.setMinimumSize(this.petiteArea.getPreferredSize());
        this.petiteArea.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel = new JPanel(new LayoutCarre());
        jPanel.add(this.petiteArea);
        this.grandeArea = new EditableFigureComponent(editableFigure, displayFigure, this.config);
        this.grandeArea.setPreferredSize(new Dimension(420, 420));
        this.grandeArea.setMinimumSize(this.grandeArea.getPreferredSize());
        this.grandeArea.setBorder(BorderFactory.createEtchedBorder());
        this.grandeArea.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("jt.found".equals(propertyChangeEvent.getPropertyName())) {
                    if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                        MainWindow.this.petiteArea.setSolved(true);
                        MainWindow.this.config.setSolved(MainWindow.this.actualName, MainWindow.this.actualFigNr, true);
                        MainWindow.this.statusBar.setMessage(3, i18n.getString("statusBar.wellDone"));
                    } else {
                        MainWindow.this.statusBar.setMessage(3, null);
                    }
                } else if ("jt.selection".equals(propertyChangeEvent.getPropertyName())) {
                    MainWindow.this.statusBar.setMessage(2, Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) ? i18n.getString("statusBar.selected") : null);
                }
            }
        });
        JPanel jPanel2 = new JPanel(new LayoutCarre());
        jPanel2.add(this.grandeArea);
        Container container = this.figNrInit(this.actualList.size());
        JButton jButton = new JButton();
        jButton.setText(i18n.getString("button.unselect"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.grandeArea.unselect();
            }
        });
        JButton jButton2 = new JButton();
        jButton2.setText(i18n.getString("button.flip"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.grandeArea.flip();
            }
        });
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1, 0, 5));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), i18n.getString("boxtitle.piece")));
        jPanel3.add(jButton2);
        jPanel3.add(jButton);
        JButton jButton3 = new JButton();
        jButton3.setText(i18n.getString("button.showTan"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.petiteArea.selectNext();
                MainWindow.this.petiteArea.repaint();
            }
        });
        JButton jButton4 = new JButton();
        jButton4.setText(i18n.getString("button.showOutline"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.grandeArea.toggleOutline();
            }
        });
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1, 0, 5));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), i18n.getString("boxtitle.help")));
        jPanel4.add(jButton3);
        jPanel4.add(jButton4);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel5.add((Component)container, gridBagConstraints);
        jPanel5.add((Component)jPanel3, gridBagConstraints);
        jPanel5.add((Component)jPanel4, gridBagConstraints);
        Dimension dimension = new Dimension(0, 0);
        gridBagConstraints.weighty = 1.0;
        jPanel5.add((Component)new Box.Filler(dimension, dimension, new Dimension(0, Short.MAX_VALUE)), gridBagConstraints);
        Dimension dimension2 = jPanel5.getPreferredSize();
        dimension2.width = 50;
        jPanel5.setPreferredSize(dimension2);
        this.statusBar = new StatusBar(5);
        this.statusBar.setBorder(BorderFactory.createEtchedBorder());
        this.statusBar.setMessage(1, i18n.getString("statusBar.unSelected"));
        this.statusBar.setVisible(this.config.getBoolean("main.showStatus", true));
        rootPaneContainer.getContentPane().setLayout(new GridBagLayout());
        Container container2 = rootPaneContainer.getContentPane();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.gridheight = 3;
        gridBagConstraints2.weightx = 3.0;
        gridBagConstraints2.weighty = 3.0;
        container2.add((Component)jPanel2, gridBagConstraints2);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        container2.add((Component)jPanel, gridBagConstraints2);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 2.0;
        container2.add((Component)jPanel5, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        container2.add((Component)this.statusBar, gridBagConstraints2);
    }

    public List getMenus() {
        ArrayList<JMenu> arrayList = new ArrayList<JMenu>();
        JMenu jMenu = new JMenu(i18n.getString("menu.status"));
        jMenu.add(i18n.getString("menu.status.current")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.config.setSolved(MainWindow.this.actualName, MainWindow.this.actualFigNr, false);
                MainWindow.this.petiteArea.setSolved(false);
            }
        });
        jMenu.add(i18n.getString("menu.status.file")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.config.clearSolved(MainWindow.this.actualName);
                MainWindow.this.petiteArea.setSolved(false);
            }
        });
        jMenu.add(i18n.getString("menu.status.all")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.config.clearAllSolved();
                MainWindow.this.petiteArea.setSolved(false);
            }
        });
        arrayList.add(jMenu);
        JMenu jMenu2 = new JMenu(i18n.getString("menu.info"));
        jMenu2.add(i18n.getString("menu.info.help")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.setChanged();
                MainWindow.this.notifyObservers("jtans.help");
            }
        });
        jMenu2.add(i18n.getString("menu.info.about")).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.setChanged();
                MainWindow.this.notifyObservers("jtans.about");
            }
        });
        arrayList.add(jMenu2);
        return arrayList;
    }

    private void changeDisplayFigure(int n) {
        this.actualFigNr = n;
        CalcFigure calcFigure = ((CalcFigure.StoredFigure)this.actualList.get(n)).getCalcFigure();
        DisplayFigure displayFigure = new DisplayFigure(calcFigure);
        DisplayFigure displayFigure2 = new DisplayFigure(calcFigure);
        this.grandeArea.setOutlineFigure(displayFigure);
        this.petiteArea.setFigure(displayFigure2, this.config.isSolved(this.actualName, this.actualFigNr));
    }

    public void update(Observable observable, Object object) {
        Config config = (Config)observable;
        FigureGroup figureGroup = config.getFigureGroup("main.figureList");
        if (!this.actualName.equals(figureGroup.getName())) {
            this.actualList = figureGroup.getListNoError();
            this.actualName = figureGroup.getName();
            this.actualFigNr = 0;
            this.figNrReSet(this.actualList.size());
        }
        this.statusBar.setVisible(config.getBoolean("main.showStatus", true));
    }

    private Container figNrInit(int n) {
        JComponent jComponent;
        final String string = i18n.getString("button.actualFig") + " ";
        try {
            Class<?> clazz = Class.forName("javax.swing.SpinnerNumberModel");
            Constructor<?> constructor = clazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Object obj = constructor.newInstance(new Integer(1), new Integer(1), new Integer(n), new Integer(1));
            Class<?> clazz2 = Class.forName("javax.swing.JSpinner");
            Constructor<?> constructor2 = clazz2.getConstructor(Class.forName("javax.swing.SpinnerModel"));
            Object obj2 = constructor2.newInstance(obj);
            Method method = clazz2.getMethod("addChangeListener", class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = MainWindow.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
            final Method method2 = clazz2.getMethod("getValue", null);
            method.invoke(obj2, new ChangeListener(){
                private Object[] dum = new Object[0];

                public void stateChanged(ChangeEvent changeEvent) {
                    int n;
                    try {
                        n = (Integer)method2.invoke(changeEvent.getSource(), this.dum) - 1;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        n = 0;
                    }
                    MainWindow.this.changeDisplayFigure(n);
                }
            });
            this.setMaxMethod = clazz.getMethod("setMaximum", class$java$lang$Comparable == null ? (class$java$lang$Comparable = MainWindow.class$("java.lang.Comparable")) : class$java$lang$Comparable);
            this.setValMethod = clazz.getMethod("setValue", class$java$lang$Object == null ? (class$java$lang$Object = MainWindow.class$("java.lang.Object")) : class$java$lang$Object);
            this.setValMaxObject = obj;
            JLabel jLabel = new JLabel(string);
            Dimension dimension = jLabel.getMinimumSize();
            dimension.width = 50;
            jLabel.setMinimumSize(dimension);
            jComponent = Box.createHorizontalBox();
            jComponent.add(jLabel);
            jComponent.add((JComponent)obj2);
        }
        catch (Exception exception) {
            System.err.println("*INFO*: JSpinner not available, falling back to JSlider");
            final TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string + "1");
            JSlider jSlider = new JSlider(1, this.actualList.size(), 1);
            jSlider.setBorder(titledBorder);
            jSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    int n = jSlider.getValue() - 1;
                    if (n != MainWindow.this.actualFigNr) {
                        MainWindow.this.changeDisplayFigure(n);
                    }
                    titledBorder.setTitle(string + (n + 1));
                    jSlider.repaint();
                }
            });
            this.setValMaxObject = jSlider;
            this.setMaxMethod = null;
            this.setValMethod = null;
            jComponent = jSlider;
        }
        return jComponent;
    }

    private void figNrReSet(int n) {
        if (this.setMaxMethod != null) {
            try {
                Object[] objectArray = new Object[]{new Integer(1)};
                this.setValMethod.invoke(this.setValMaxObject, objectArray);
                objectArray[0] = new Integer(n);
                this.setMaxMethod.invoke(this.setValMaxObject, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        } else {
            this.actualFigNr = -1;
            JSlider jSlider = (JSlider)this.setValMaxObject;
            jSlider.setValue(1);
            jSlider.setMaximum(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

