/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.guimain;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import net.phbwt.jtans.calc.DisplayFigure;
import net.phbwt.jtans.calc.PixelOutlinePolygon;
import net.phbwt.jtans.guicommon.Config;
import net.phbwt.jtans.guicommon.Surface;

public final class DisplayFigureComponent
extends JPanel
implements Observer {
    private static final boolean DEBUG = false;
    private static final int IN_BORDER = 5;
    private boolean gfxIsConfigured = false;
    private Surface bgSurface;
    private Paint bgPaint;
    private Surface solvedSurface;
    private Paint solvedPaint;
    private Surface unselectedFiguresSurface;
    private Paint unselectedFiguresPaint;
    private Surface selectedFigureSurface;
    private Paint selectedFigurePaint;
    private RenderingHints hints;
    private double refScale = 0.1;
    private boolean solved;
    public DisplayFigure fig;

    DisplayFigureComponent(DisplayFigure displayFigure, Config config, boolean bl) {
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        this.fig = displayFigure;
        this.solved = bl;
        this.config(config);
        config.addObserver(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DisplayFigureComponent.this.resetFigureScale();
                DisplayFigureComponent.this.repaint();
            }
        });
    }

    public void update(Observable observable, Object object) {
        this.config((Config)observable);
        this.repaint();
    }

    public void config(Config config) {
        this.unselectedFiguresSurface = config.getSurface("small.piece.normal");
        this.selectedFigureSurface = config.getSurface("small.piece.selected");
        this.bgSurface = config.getSurface("small.background.normal");
        this.solvedSurface = config.getSurface("small.background.solved");
        this.hints = config.getRenderingHints();
        this.gfxIsConfigured = false;
    }

    private void configGfx() {
        this.unselectedFiguresPaint = this.unselectedFiguresSurface.getPaintNoError(this);
        this.selectedFigurePaint = this.selectedFigureSurface.getPaintNoError(this);
        this.bgPaint = this.bgSurface.getPaintNoError(this);
        this.solvedPaint = this.solvedSurface.getPaintNoError(this);
        this.gfxIsConfigured = true;
    }

    public void paintComponent(Graphics graphics) {
        if (!this.gfxIsConfigured) {
            this.configGfx();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        graphics2D.setPaint(this.solved ? this.solvedPaint : this.bgPaint);
        graphics2D.fill(new Rectangle(n, n2, n3, n3));
        graphics2D.setPaint(this.unselectedFiguresPaint);
        int n5 = 0;
        Object object = this.fig.outlineIterator();
        while (object.hasNext()) {
            PixelOutlinePolygon pixelOutlinePolygon = (PixelOutlinePolygon)object.next();
            if (n5 == 0 && pixelOutlinePolygon.getType() == 7) {
                graphics2D.setPaint(this.bgPaint);
                ++n5;
            } else if (n5 == 1 && pixelOutlinePolygon.getType() == 5) {
                graphics2D.setPaint(this.unselectedFiguresPaint);
                ++n5;
            }
            graphics2D.fill(pixelOutlinePolygon);
        }
        object = this.fig.getSelectedPiece();
        if (object != null) {
            graphics2D.setPaint(this.selectedFigurePaint);
            graphics2D.fill((Shape)object);
        }
        graphics2D.setStroke(stroke);
    }

    public void selectNext() {
        this.fig.selectNext();
    }

    public void setFigure(DisplayFigure displayFigure, boolean bl) {
        this.solved = bl;
        this.fig = displayFigure;
        this.resetFigureScale();
        this.repaint();
    }

    public void setSolved(boolean bl) {
        this.solved = bl;
        this.repaint();
    }

    private void resetFigureScale() {
        Insets insets = this.getInsets();
        this.fig.resetCoords(insets.left + 5, insets.top + 5, this.getWidth() - insets.right - 5, this.getHeight() - insets.bottom - 5);
    }

    protected final Graphics getComponentGraphics(Graphics graphics) {
        ((Graphics2D)graphics).addRenderingHints(this.hints);
        return graphics;
    }
}

