/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.guiconfig;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.phbwt.jtans.guicommon.Trait;
import net.phbwt.jtans.guiconfig.TraitExampleComponent;

final class TraitComponentGroup {
    TraitComponentGroup() {
    }

    static void addGroup(final JComponent jComponent, final Trait trait, String string, GridBagConstraints gridBagConstraints, ResourceBundle resourceBundle) {
        final TraitExampleComponent traitExampleComponent = new TraitExampleComponent(trait);
        JSlider jSlider = new JSlider(100, 1000, (int)(trait.getWidth() * 100.0f));
        jSlider.setPaintTicks(true);
        jSlider.setMinorTickSpacing(100);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                trait.setWidth((float)((JSlider)changeEvent.getSource()).getValue() / 100.0f);
                traitExampleComponent.repaint();
            }
        });
        JButton jButton = new JButton(resourceBundle.getString("trait.choose"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(jComponent, null, trait.getColor());
                if (color != null) {
                    trait.setColor(color);
                }
                traitExampleComponent.repaint();
            }
        });
        GridBagLayout gridBagLayout = (GridBagLayout)jComponent.getLayout();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JComponent jComponent2 = new JLabel(string);
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jComponent.add(jComponent2);
        ++gridBagConstraints.gridx;
        ++gridBagConstraints.gridx;
        jComponent2 = jButton;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jComponent.add(jComponent2);
        ++gridBagConstraints.gridx;
        jComponent2 = jSlider;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jComponent.add(jComponent2);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jComponent2 = traitExampleComponent;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jComponent.add(jComponent2);
    }
}

