/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.guiconfig;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.phbwt.jtans.guicommon.Surface;
import net.phbwt.jtans.guiconfig.SurfaceExampleComponent;

final class SurfaceComponentGroup {
    private static String[] typeLabels = null;

    SurfaceComponentGroup() {
    }

    public static void addGroup(final JComponent jComponent, final Surface surface, String string, GridBagConstraints gridBagConstraints, final JFileChooser jFileChooser, final ResourceBundle resourceBundle) {
        if (typeLabels == null) {
            typeLabels = new String[]{resourceBundle.getString("surface.type.color"), resourceBundle.getString("surface.type.base"), resourceBundle.getString("surface.type.file")};
        }
        if (surface == null) {
            System.err.println("*WARNING*:config incomplete: manque " + string);
            return;
        }
        final SurfaceExampleComponent surfaceExampleComponent = new SurfaceExampleComponent(surface);
        final JSlider jSlider = new JSlider(50, 150, (int)(surface.getBrightness() * 100.0f));
        jSlider.setPaintTicks(true);
        jSlider.setMinorTickSpacing(10);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    surface.setBrightness((float)jSlider.getValue() / 100.0f);
                    surfaceExampleComponent.repaint();
                }
            }
        });
        JComboBox<String> jComboBox = new JComboBox<String>(typeLabels);
        switch (surface.getType()) {
            case 1: {
                jComboBox.setSelectedIndex(0);
                jSlider.setEnabled(false);
                break;
            }
            case 3: {
                jComboBox.setSelectedIndex(1);
                break;
            }
            case 2: {
                jComboBox.setSelectedIndex(2);
            }
        }
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                switch (((JComboBox)actionEvent.getSource()).getSelectedIndex()) {
                    case 0: {
                        surface.setType(1);
                        jSlider.setEnabled(false);
                        break;
                    }
                    case 2: {
                        surface.setType(2);
                        jSlider.setEnabled(true);
                        break;
                    }
                    case 1: {
                        surface.setType(3);
                        jSlider.setEnabled(true);
                    }
                }
                surfaceExampleComponent.repaint();
            }
        });
        JButton jButton = new JButton(resourceBundle.getString("surface.choose"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    switch (surface.getType()) {
                        case 1: {
                            Color color = JColorChooser.showDialog(jComponent, null, surface.getColor());
                            if (color == null) break;
                            surface.setColor(color);
                            break;
                        }
                        case 2: {
                            if (jFileChooser == null) {
                                throw new Exception(resourceBundle.getString("error.restricted"));
                            }
                            if (surface.getTextureFile() != null) {
                                jFileChooser.setSelectedFile(surface.getTextureFile());
                            }
                            if (jFileChooser.showOpenDialog(jComponent) != 0) break;
                            surface.setTextureFile(jFileChooser.getSelectedFile());
                            break;
                        }
                        case 3: {
                            String string = (String)JOptionPane.showInputDialog(jComponent, null, null, 3, null, Surface.getBaseTextures(), surface.getBaseTextureName());
                            if (string == null) break;
                            surface.setBaseTextureName(string);
                            break;
                        }
                    }
                    surface.getPaint(surfaceExampleComponent);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(surfaceExampleComponent, resourceBundle.getString("error.surface.load") + " : " + exception.getMessage());
                }
                surfaceExampleComponent.repaint();
            }
        });
        GridBagLayout gridBagLayout = (GridBagLayout)jComponent.getLayout();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JComponent jComponent2 = new JLabel(string);
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jComponent.add(jComponent2);
        ++gridBagConstraints.gridx;
        jComponent2 = jComboBox;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jComponent.add(jComponent2);
        ++gridBagConstraints.gridx;
        jComponent2 = jButton;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jComponent.add(jComponent2);
        ++gridBagConstraints.gridx;
        jComponent2 = jSlider;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jComponent.add(jComponent2);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jComponent2 = surfaceExampleComponent;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jComponent.add(jComponent2);
    }
}

