/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.guiconfig;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.phbwt.jtans.guicommon.Config;
import net.phbwt.jtans.guicommon.FigureGroup;
import net.phbwt.jtans.guiconfig.SurfaceComponentGroup;
import net.phbwt.jtans.guiconfig.TraitComponentGroup;

public class ConfigWindow {
    private Config editedConfig;
    private Config origConfig;
    private JFrame window = null;
    private JFileChooser fileChooser = null;
    private static ResourceBundle i18n = ResourceBundle.getBundle("net.phbwt.jtans.i18n.config");
    private static final int[] rotValues = new int[]{13, 14, 15};
    private static final String[] rotLabels = new String[]{i18n.getString("game.rotation.continuous"), i18n.getString("game.rotation.step32"), i18n.getString("game.rotation.stepAuto")};
    private static final int[] accurValues = new int[]{18, 17, 16};
    private static final String[] accurLabels = new String[]{i18n.getString("game.accuracy.low"), i18n.getString("game.accuracy.medium"), i18n.getString("game.accuracy.high")};
    private static final int[] figTypeValues = new int[]{2, 1};
    private static final String[] figTypeLabels = new String[]{i18n.getString("game.figures.type.resource"), i18n.getString("game.figures.type.file")};

    public ConfigWindow(Config config) {
        this.origConfig = config;
    }

    public void show() {
        if (this.fileChooser == null) {
            try {
                this.fileChooser = new JFileChooser();
            }
            catch (SecurityException securityException) {
                System.err.println("*INFO*: wont'be able to access filesystem :");
                securityException.printStackTrace(System.err);
            }
        }
        if (this.editedConfig == null) {
            this.editedConfig = (Config)this.origConfig.clone();
        }
        if (this.window == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(1, 3, 1, 3);
            JTabbedPane jTabbedPane = new JTabbedPane();
            jTabbedPane.addTab(i18n.getString("game.tabTitle"), null, this.gameParametersTab(gridBagConstraints), i18n.getString("game.tabHint"));
            jTabbedPane.addTab(i18n.getString("main.tabTitle"), null, this.mainFigureTab(gridBagConstraints), i18n.getString("main.tabHint"));
            jTabbedPane.addTab(i18n.getString("small.tabTitle"), null, this.smallFigureTab(gridBagConstraints), i18n.getString("small.tabHint"));
            jTabbedPane.addTab(i18n.getString("hint.tabTitle"), null, this.renderingTab(gridBagConstraints), i18n.getString("hint.tabHint"));
            JButton jButton = new JButton(i18n.getString("ok"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigWindow.this.window.hide();
                    ConfigWindow.this.window.dispose();
                    ConfigWindow.this.origConfig.updateFromConfig(ConfigWindow.this.editedConfig);
                    ConfigWindow.this.origConfig.notifyChanges();
                }
            });
            JButton jButton2 = new JButton(i18n.getString("cancel"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigWindow.this.abort();
                }
            });
            JButton jButton3 = new JButton(i18n.getString("apply"));
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigWindow.this.origConfig.updateFromConfig(ConfigWindow.this.editedConfig);
                    ConfigWindow.this.origConfig.notifyChanges();
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(Box.createGlue());
            box.add(jButton);
            box.add(Box.createGlue());
            box.add(jButton2);
            box.add(Box.createGlue());
            box.add(jButton3);
            box.add(Box.createGlue());
            Box box2 = Box.createVerticalBox();
            box2.add(jTabbedPane);
            box2.add(Box.createGlue());
            box2.add(new JSeparator());
            box2.add(Box.createGlue());
            box2.add(box);
            this.window = new JFrame(i18n.getString("global.title"));
            this.window.setDefaultCloseOperation(2);
            this.window.getContentPane().add(box2);
        }
        this.window.pack();
        this.window.show();
    }

    private JComponent mainFigureTab(GridBagConstraints gridBagConstraints) {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        gridBagConstraints.anchor = 10;
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JComponent jComponent = new JLabel(i18n.getString("main.type"));
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.gridx += 2;
        jComponent = new JLabel(i18n.getString("main.brightness-width"));
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        SurfaceComponentGroup.addGroup(jPanel, this.editedConfig.getSurface("main.piece.normal"), i18n.getString("main.piece.normal"), gridBagConstraints, this.fileChooser, i18n);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        SurfaceComponentGroup.addGroup(jPanel, this.editedConfig.getSurface("main.piece.selected"), i18n.getString("main.piece.selected"), gridBagConstraints, this.fileChooser, i18n);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        TraitComponentGroup.addGroup(jPanel, this.editedConfig.getTrait("main.piece.border"), i18n.getString("main.piece.border"), gridBagConstraints, i18n);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        SurfaceComponentGroup.addGroup(jPanel, this.editedConfig.getSurface("main.background"), i18n.getString("main.background"), gridBagConstraints, this.fileChooser, i18n);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        TraitComponentGroup.addGroup(jPanel, this.editedConfig.getTrait("main.outline"), i18n.getString("main.outline"), gridBagConstraints, i18n);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        TraitComponentGroup.addGroup(jPanel, this.editedConfig.getTrait("main.rotation"), i18n.getString("main.rotation"), gridBagConstraints, i18n);
        JSlider jSlider = new JSlider(0, 95, (int)(100.0 - this.editedConfig.getDouble("main.piece.selected.alpha", 1.0) * 100.0));
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ConfigWindow.this.editedConfig.putDouble("main.piece.selected.alpha", 1.0 - (double)((JSlider)changeEvent.getSource()).getValue() / 100.0);
            }
        });
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jComponent = new JLabel(i18n.getString("main.piece.selected.alpha"));
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 3;
        jComponent = jSlider;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.gridwidth = 1;
        return jPanel;
    }

    private JComponent smallFigureTab(GridBagConstraints gridBagConstraints) {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        gridBagConstraints.anchor = 10;
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel(i18n.getString("small.type"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx += 2;
        jLabel = new JLabel(i18n.getString("small.brightness"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        SurfaceComponentGroup.addGroup(jPanel, this.editedConfig.getSurface("small.piece.normal"), i18n.getString("small.piece.normal"), gridBagConstraints, this.fileChooser, i18n);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        SurfaceComponentGroup.addGroup(jPanel, this.editedConfig.getSurface("small.piece.selected"), i18n.getString("small.piece.selected"), gridBagConstraints, this.fileChooser, i18n);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        SurfaceComponentGroup.addGroup(jPanel, this.editedConfig.getSurface("small.background.normal"), i18n.getString("small.background.normal"), gridBagConstraints, this.fileChooser, i18n);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        SurfaceComponentGroup.addGroup(jPanel, this.editedConfig.getSurface("small.background.solved"), i18n.getString("small.background.solved"), gridBagConstraints, this.fileChooser, i18n);
        return jPanel;
    }

    private JComponent renderingTab(GridBagConstraints gridBagConstraints) {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        jPanel.setLayout(new GridBagLayout());
        for (int i = 0; i < Config.Hint.getTypesNumber(); ++i) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            this.addRenderingComponents(jPanel, gridBagConstraints, this.editedConfig.getHint(i));
        }
        return jPanel;
    }

    private void addRenderingComponents(JComponent jComponent, GridBagConstraints gridBagConstraints, Config.Hint hint) {
        GridBagLayout gridBagLayout = (GridBagLayout)jComponent.getLayout();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(i18n.getString(hint.getKeyName()));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jComponent.add(jLabel);
        String[] stringArray = hint.getValueNames();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = stringArray.length - 1; i >= 0; --i) {
            stringArray2[i] = i18n.getString(stringArray[i]);
        }
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray2);
        jComboBox.putClientProperty("hint", hint);
        jComboBox.setSelectedIndex(hint.getSelectedValueIndex());
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                ((Config.Hint)jComboBox.getClientProperty("hint")).setSelectedValueIndex(jComboBox.getSelectedIndex());
            }
        });
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(jComboBox, gridBagConstraints);
        jComponent.add(jComboBox);
    }

    private JComponent gameParametersTab(GridBagConstraints gridBagConstraints) {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        jPanel.setLayout(new GridBagLayout());
        JSlider jSlider = new JSlider(8, 18, (int)(this.editedConfig.getDouble("main.scale", 0.1) * 100.0));
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ConfigWindow.this.editedConfig.putDouble("main.scale", (double)((JSlider)changeEvent.getSource()).getValue() / 100.0);
            }
        });
        JComboBox<String> jComboBox = new JComboBox<String>(rotLabels);
        jComboBox.setSelectedIndex(ConfigWindow.search(rotValues, this.editedConfig.getInt("main.rotationStep", 14)));
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigWindow.this.editedConfig.putInt("main.rotationStep", rotValues[((JComboBox)actionEvent.getSource()).getSelectedIndex()]);
            }
        });
        JComboBox<String> jComboBox2 = new JComboBox<String>(accurLabels);
        jComboBox2.setSelectedIndex(ConfigWindow.search(accurValues, this.editedConfig.getInt("main.compareAccuracy", 17)));
        jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigWindow.this.editedConfig.putInt("main.compareAccuracy", accurValues[((JComboBox)actionEvent.getSource()).getSelectedIndex()]);
            }
        });
        final FigureGroup figureGroup = this.editedConfig.getFigureGroup("main.figureList");
        JComboBox<String> jComboBox3 = new JComboBox<String>(figTypeLabels);
        jComboBox3.setSelectedIndex(ConfigWindow.search(figTypeValues, figureGroup.getType()));
        jComboBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                figureGroup.setType(figTypeValues[((JComboBox)actionEvent.getSource()).getSelectedIndex()]);
            }
        });
        final JButton jButton = new JButton(i18n.getString("game.figures.choose"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    switch (figureGroup.getType()) {
                        case 1: {
                            if (ConfigWindow.this.fileChooser == null) {
                                throw new Exception(i18n.getString("restricted"));
                            }
                            if (figureGroup.getFile() != null) {
                                ConfigWindow.this.fileChooser.setSelectedFile(figureGroup.getFile());
                            }
                            if (ConfigWindow.this.fileChooser.showOpenDialog(jButton) != 0) break;
                            figureGroup.setFile(ConfigWindow.this.fileChooser.getSelectedFile());
                            break;
                        }
                        case 2: {
                            String string = (String)JOptionPane.showInputDialog(jButton, null, null, 3, null, FigureGroup.getResources(), figureGroup.getResourceName());
                            if (string == null) break;
                            figureGroup.setResourceName(string);
                            break;
                        }
                    }
                    figureGroup.getList();
                }
                catch (Exception exception) {
                    System.err.println("*INFO*:Can't get figure file:");
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(jButton, i18n.getString("error.figures.load") + " : " + exception.getMessage());
                }
            }
        });
        JCheckBox jCheckBox = new JCheckBox("", this.editedConfig.getBoolean("main.showStatus", true));
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigWindow.this.editedConfig.putBoolean("main.showStatus", ((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JComponent jComponent = new JLabel(i18n.getString("game.size"));
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        jComponent = jSlider;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        jComponent = new JLabel(i18n.getString("game.accuracy"));
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        jComponent = jComboBox2;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        jComponent = new JLabel(i18n.getString("game.rotation"));
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        jComponent = jComboBox;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        jComponent = new JLabel(i18n.getString("game.figures"));
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        ++gridBagConstraints.gridx;
        jComponent = jComboBox3;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        ++gridBagConstraints.gridx;
        jComponent = jButton;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        jComponent = new JLabel(i18n.getString("game.showStatus"));
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        ++gridBagConstraints.gridx;
        jComponent = jCheckBox;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        return jPanel;
    }

    public void abort() {
        if (this.window != null) {
            this.window.hide();
            this.window.dispose();
            this.window = null;
        }
        this.editedConfig = null;
    }

    public static int search(int[] nArray, int n) {
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (n != nArray[i]) continue;
            return i;
        }
        throw new RuntimeException("valeur inconnue");
    }

    public static int posIndex(double[] dArray, double d) {
        int n;
        for (n = 0; n < dArray.length - 1 && d > (dArray[n] + dArray[n + 1]) / 2.0; ++n) {
        }
        return n;
    }

    public static String[] createLabels(double[] dArray) {
        String[] stringArray = new String[dArray.length];
        for (int i = dArray.length - 1; i >= 0; --i) {
            stringArray[i] = Double.toString(dArray[i]);
        }
        return stringArray;
    }
}

