/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.guicommon;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RescaleOp;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import net.phbwt.jtans.guicommon.Config;

public class Surface
implements Serializable,
Config.ConfigItem {
    static final long serialVersionUID = 1L;
    private static final String BASE_TEXTURE_PATH = "net/phbwt/jtans/images";
    public static final int COLOR = 1;
    public static final int USER_TEXTURE = 2;
    public static final int BASE_TEXTURE = 3;
    private int type;
    private Color color;
    private File textureFile;
    private String baseTextureName;
    private float brightness;
    private transient Paint paint = null;
    private transient BufferedImageOp brightOp = null;
    private static String[] baseTextures = null;
    static /* synthetic */ Class class$net$phbwt$jtans$guicommon$Surface;

    Surface() {
    }

    Surface(int n, Color color, String string, String string2, float f) {
        this.type = n;
        this.color = color;
        this.textureFile = string2 == null ? null : new File(string2);
        this.baseTextureName = string;
        this.brightness = f;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float f) {
        this.brightness = f;
        this.paint = null;
        this.brightOp = null;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
        this.paint = null;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.paint = null;
    }

    public File getTextureFile() {
        return this.textureFile;
    }

    public void setTextureFile(File file) {
        this.textureFile = file;
        this.paint = null;
    }

    public String getBaseTextureName() {
        return this.baseTextureName;
    }

    public void setBaseTextureName(String string) {
        this.baseTextureName = string;
        this.paint = null;
    }

    public static String[] getBaseTextures() {
        if (baseTextures == null) {
            TreeSet<String> treeSet = new TreeSet<String>();
            try {
                String string = "net/phbwt/jtans/images/baseTextures.txt";
                Enumeration<URL> enumeration = (class$net$phbwt$jtans$guicommon$Surface == null ? (class$net$phbwt$jtans$guicommon$Surface = Surface.class$("net.phbwt.jtans.guicommon.Surface")) : class$net$phbwt$jtans$guicommon$Surface).getClassLoader().getResources(string);
                while (enumeration.hasMoreElements()) {
                    String string2;
                    InputStream inputStream = enumeration.nextElement().openStream();
                    if (inputStream == null) continue;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if ("".equals(string2 = string2.trim())) continue;
                        treeSet.add(string2);
                    }
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            baseTextures = treeSet.toArray(new String[0]);
        }
        return baseTextures;
    }

    public Paint getPaint(JComponent jComponent) throws Exception {
        if (this.paint == null) {
            switch (this.type) {
                case 1: {
                    if (this.color == null) break;
                    this.paint = this.color;
                    break;
                }
                case 2: {
                    if (this.textureFile != null) {
                        this.paint = this.loadTexture(this.textureFile.toURL(), jComponent);
                        break;
                    }
                    throw new RuntimeException("pas de nom de fichier pour la texture");
                }
                case 3: {
                    if (this.baseTextureName != null) {
                        URL uRL = (class$net$phbwt$jtans$guicommon$Surface == null ? (class$net$phbwt$jtans$guicommon$Surface = Surface.class$("net.phbwt.jtans.guicommon.Surface")) : class$net$phbwt$jtans$guicommon$Surface).getResource("/net/phbwt/jtans/images/" + this.baseTextureName);
                        if (uRL == null) {
                            throw new RuntimeException("pas trouve la texture de base : " + this.baseTextureName);
                        }
                        this.paint = this.loadTexture(uRL, jComponent);
                        break;
                    }
                    throw new RuntimeException("pas de nom de texture de base");
                }
            }
        }
        return this.paint;
    }

    public Paint getPaintNoError(JComponent jComponent) {
        Paint paint;
        try {
            paint = this.getPaint(jComponent);
        }
        catch (Exception exception) {
            System.err.println("*INFO*: pas trouve le paint");
            exception.printStackTrace(System.err);
            paint = Color.black;
        }
        return paint;
    }

    private TexturePaint loadTexture(URL uRL, JComponent jComponent) {
        if ((double)Math.abs(this.brightness - 1.0f) > 0.001 && this.brightOp == null) {
            this.brightOp = new RescaleOp(this.brightness, 0.0f, null);
        }
        Image image = new ImageIcon(uRL).getImage();
        int n = image.getWidth(jComponent);
        int n2 = image.getHeight(jComponent);
        BufferedImage bufferedImage = (BufferedImage)jComponent.createImage(n, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, jComponent);
        if (this.brightOp != null) {
            this.brightOp.filter(bufferedImage, bufferedImage);
        }
        graphics2D.dispose();
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        return new TexturePaint(bufferedImage, rectangle);
    }

    public String toString() {
        return "Surface:type=" + this.type + ":color=" + this.color + ":base=" + this.baseTextureName + ":file=" + this.textureFile + ":bright=" + this.brightness;
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = Surface.getBaseTextures();
            System.err.println("*****");
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println(stringArray2[i]);
            }
            System.err.println("*****");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

