/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.guicommon;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import net.phbwt.jtans.calc.CalcFigure;
import net.phbwt.jtans.guicommon.Config;

public class FigureGroup
implements Serializable,
Config.ConfigItem {
    static final long serialVersionUID = 1L;
    private static final String RESOURCES_PATH = "net/phbwt/jtans/figures";
    public static final int FILE = 1;
    public static final int RESOURCE = 2;
    private int type;
    private File file;
    private String resourceName;
    private transient List fList = null;
    private transient String name = null;
    private static String[] resources = null;
    static /* synthetic */ Class class$net$phbwt$jtans$guicommon$Surface;

    public FigureGroup() {
        this.type = 2;
        this.resourceName = "default.figures";
        this.file = null;
    }

    public FigureGroup(int n, String string, String string2) {
        this.type = n;
        this.resourceName = string;
        this.file = string2 == null ? null : new File(string2);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
        this.fList = null;
        this.name = null;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.fList = null;
        this.name = null;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String string) {
        this.resourceName = string;
        this.fList = null;
        this.name = null;
    }

    public String getName() {
        if (this.name == null) {
            switch (this.type) {
                case 1: {
                    this.name = this.file != null ? this.file.getName() : "no file";
                    break;
                }
                case 2: {
                    this.name = this.resourceName.substring(this.resourceName.lastIndexOf(47) + 1);
                    break;
                }
                default: {
                    System.err.println("*error* : type de FigureList inconnu");
                    this.name = "";
                }
            }
        }
        return this.name;
    }

    public static String[] getResources() {
        if (resources == null) {
            TreeSet<String> treeSet = new TreeSet<String>();
            try {
                String string = "net/phbwt/jtans/figures/figureResourceList.txt";
                Enumeration<URL> enumeration = (class$net$phbwt$jtans$guicommon$Surface == null ? (class$net$phbwt$jtans$guicommon$Surface = FigureGroup.class$("net.phbwt.jtans.guicommon.Surface")) : class$net$phbwt$jtans$guicommon$Surface).getClassLoader().getResources(string);
                while (enumeration.hasMoreElements()) {
                    String string2;
                    InputStream inputStream = enumeration.nextElement().openStream();
                    if (inputStream == null) continue;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if ("".equals(string2 = string2.trim())) continue;
                        treeSet.add(string2);
                    }
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            resources = treeSet.toArray(new String[0]);
        }
        return resources;
    }

    public List getList() throws Exception {
        if (this.fList == null) {
            switch (this.type) {
                case 1: {
                    if (this.file != null) {
                        this.fList = this.loadFigures(this.file.toURL());
                        break;
                    }
                    throw new RuntimeException("pas de fichier");
                }
                case 2: {
                    if (this.resourceName != null) {
                        URL uRL = (class$net$phbwt$jtans$guicommon$Surface == null ? (class$net$phbwt$jtans$guicommon$Surface = FigureGroup.class$("net.phbwt.jtans.guicommon.Surface")) : class$net$phbwt$jtans$guicommon$Surface).getResource("/net/phbwt/jtans/figures/" + this.resourceName);
                        if (uRL == null) {
                            throw new RuntimeException("pas trouve la resource figures : " + this.resourceName);
                        }
                        this.fList = this.loadFigures(uRL);
                        break;
                    }
                    throw new RuntimeException("pas de nom de ressource");
                }
            }
        }
        return this.fList;
    }

    public List getListNoError() {
        ArrayList<CalcFigure.StoredFigure> arrayList;
        try {
            arrayList = this.getList();
        }
        catch (Exception exception) {
            arrayList = new ArrayList<CalcFigure.StoredFigure>();
            arrayList.add(new CalcFigure.StoredFigure());
            this.name = "none";
            System.err.println("*INFO*: pas trouve les figures");
            exception.printStackTrace(System.err);
        }
        return arrayList;
    }

    private List loadFigures(URL uRL) throws IOException {
        long l = System.currentTimeMillis();
        ArrayList<CalcFigure.StoredFigure> arrayList = new ArrayList<CalcFigure.StoredFigure>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.ordinaryChars(43, 57);
        streamTokenizer.wordChars(43, 57);
        streamTokenizer.eolIsSignificant(true);
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            int n = Integer.parseInt(streamTokenizer.sval);
            streamTokenizer.nextToken();
        }
        catch (Exception exception) {
            throw new RuntimeException("bad format line 1 : " + exception);
        }
        for (int i = n - 1; i >= 0; --i) {
            arrayList.add(new CalcFigure.StoredFigure(streamTokenizer));
        }
        ((Reader)bufferedReader).close();
        System.err.println("*INFO*: chargement des figures :" + (System.currentTimeMillis() - l));
        return arrayList;
    }

    public String toString() {
        return "FigureGroup:type=" + this.type + ":resource=" + this.resourceName + ":file=" + this.file;
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = FigureGroup.getResources();
            System.out.println("*****");
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println(stringArray2[i]);
            }
            System.out.println("*****");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

