/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.guicommon;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import net.phbwt.jtans.guicommon.FigureGroup;
import net.phbwt.jtans.guicommon.Surface;
import net.phbwt.jtans.guicommon.Trait;

public class Config
extends Observable
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public static final int ROTATION_CONTINUOUS = 13;
    public static final int ROTATION_STEP_32 = 14;
    public static final int ROTATION_STEP_AUTO = 15;
    private Map properties = new HashMap();
    private Map solvedMap = null;
    private Hint[] hints;
    private transient RenderingHints renderingHints = null;

    public Config() {
        this.addDefaultValues();
    }

    public Config(Config config) {
        this.hints = new Hint[config.hints.length];
        this.updateFromConfig(config);
        this.addDefaultValues();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addDefaultValues();
    }

    private void addDefaultValues() {
        if (this.solvedMap == null) {
            this.solvedMap = new HashMap();
        }
        if (this.hints == null) {
            this.hints = new Hint[0];
        }
        if (this.hints.length < Hint.getTypesNumber()) {
            Hint[] hintArray = new Hint[Hint.getTypesNumber()];
            System.arraycopy(this.hints, 0, hintArray, 0, this.hints.length);
            for (int i = Hint.getTypesNumber() - 1; i >= this.hints.length; --i) {
                hintArray[i] = Hint.newInstance(i);
            }
            this.hints = hintArray;
        }
        if (!this.contains("main.piece.normal")) {
            this.putVal("main.piece.normal", new Surface(1, Color.black, "burtwood.jpg", null, 1.0f));
        }
        if (!this.contains("main.piece.selected")) {
            this.putVal("main.piece.selected", new Surface(1, new Color(100, 100, 100), "burtwood.jpg", null, 1.2f));
        }
        if (!this.contains("main.piece.border")) {
            this.putVal("main.piece.border", new Trait(Color.blue, 1.0f));
        }
        if (!this.contains("main.background")) {
            this.putVal("main.background", new Surface(1, new Color(190, 190, 200), "paper.jpg", null, 1.0f));
        }
        if (!this.contains("main.outline")) {
            this.putVal("main.outline", new Trait(Color.red, 1.0f));
        }
        if (!this.contains("main.rotation")) {
            this.putVal("main.rotation", new Trait(Color.black, 1.0f));
        }
        if (!this.contains("main.piece.selected.alpha")) {
            this.putDouble("main.piece.selected.alpha", 0.5);
        }
        if (!this.contains("small.piece.normal")) {
            this.putVal("small.piece.normal", new Surface(1, Color.black, null, null, 1.0f));
        }
        if (!this.contains("small.piece.selected")) {
            this.putVal("small.piece.selected", new Surface(1, new Color(100, 100, 100), null, null, 1.0f));
        }
        if (!this.contains("small.background.normal")) {
            this.putVal("small.background.normal", new Surface(1, Color.white, null, null, 1.0f));
        }
        if (!this.contains("small.background.solved")) {
            this.putVal("small.background.solved", new Surface(1, new Color(150, 255, 150), null, null, 1.0f));
        }
        if (!this.contains("main.scale")) {
            this.putDouble("main.scale", 0.1);
        }
        if (!this.contains("main.rotationStep")) {
            this.putInt("main.rotationStep", 14);
        }
        if (!this.contains("main.compareAccuracy")) {
            this.putInt("main.compareAccuracy", 17);
        }
        if (!this.contains("main.figureList")) {
            this.putVal("main.figureList", new FigureGroup());
        }
        if (!this.contains("main.showStatus")) {
            this.putBoolean("main.showStatus", true);
        }
    }

    public void updateFromConfig(Config config) {
        for (int i = this.hints.length - 1; i >= 0; --i) {
            this.hints[i] = Hint.newInstance(i, config.hints[i].getSelectedValueIndex());
        }
        try {
            Iterator iterator = config.properties.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                String string = (String)iterator.next();
                Object object2 = config.getVal(string);
                if (object2 instanceof Double) {
                    object = object2;
                } else if (object2 instanceof Integer) {
                    object = object2;
                } else if (object2 instanceof Boolean) {
                    object = object2;
                } else if (object2 instanceof ConfigItem) {
                    object = ((ConfigItem)object2).clone();
                } else {
                    System.err.println("*warning*:type non prevu -> clonage");
                    object = object2.getClass().getMethod("clone", null).invoke(object2, null);
                }
                this.putVal(string, object);
            }
        }
        catch (Exception exception) {
            System.err.println("*error*:Config contenant une valeur non cloneable ?");
            exception.printStackTrace(System.err);
        }
    }

    public void notifyChanges() {
        this.setChanged();
        this.notifyObservers(this);
    }

    public RenderingHints getRenderingHints() {
        if (this.renderingHints == null) {
            this.renderingHints = new RenderingHints(null);
        }
        for (int i = this.hints.length - 1; i >= 0; --i) {
            Hint hint = this.hints[i];
            this.renderingHints.put(hint.getKey(), hint.getRenderingHint());
        }
        return this.renderingHints;
    }

    public Hint getHint(int n) {
        if (n < this.hints.length) {
            return this.hints[n];
        }
        throw new RuntimeException("*error*: Hint inconnu");
    }

    private void putVal(String string, Object object) {
        this.properties.put(string, object);
    }

    private boolean contains(String string) {
        return this.properties.containsKey(string);
    }

    private Object getVal(String string) {
        Object v = this.properties.get(string);
        if (v == null) {
            System.err.println("*error* clef inconnue :" + string);
        }
        return v;
    }

    public Surface getSurface(String string) {
        return (Surface)this.getVal(string);
    }

    public FigureGroup getFigureGroup(String string) {
        return (FigureGroup)this.getVal(string);
    }

    public Trait getTrait(String string) {
        return (Trait)this.getVal(string);
    }

    public int getInt(String string, int n) {
        Integer n2 = (Integer)this.getVal(string);
        if (n2 != null) {
            return n2;
        }
        return n;
    }

    public void putInt(String string, int n) {
        this.putVal(string, new Integer(n));
    }

    public double getDouble(String string, double d) {
        Double d2 = (Double)this.getVal(string);
        if (d2 != null) {
            return d2;
        }
        return d;
    }

    public void putDouble(String string, double d) {
        this.putVal(string, new Double(d));
    }

    public boolean getBoolean(String string, boolean bl) {
        Object object = this.getVal(string);
        return object == null ? bl : Boolean.TRUE.equals(object);
    }

    public void putBoolean(String string, boolean bl) {
        this.putVal(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public Composite getComposite(String string) {
        double d = this.getDouble(string, 1.0);
        if (Math.abs(d - 1.0) > 1.0E-4) {
            return AlphaComposite.getInstance(3, (float)d);
        }
        return null;
    }

    public boolean isSolved(String string, int n) {
        BitSet bitSet = (BitSet)this.solvedMap.get(string);
        return bitSet != null && bitSet.get(n);
    }

    public void setSolved(String string, int n, boolean bl) {
        BitSet bitSet = (BitSet)this.solvedMap.get(string);
        if (bitSet == null) {
            bitSet = new BitSet();
            this.solvedMap.put(string, bitSet);
        }
        if (bl) {
            bitSet.set(n);
        } else {
            bitSet.clear(n);
        }
    }

    public void clearSolved(String string) {
        this.solvedMap.remove(string);
    }

    public void clearAllSolved() {
        this.solvedMap.clear();
    }

    public Object clone() {
        Config config = new Config(this);
        return config;
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append("Config:\n");
        for (int i = this.hints.length - 1; i >= 0; --i) {
            object = this.hints[i];
            stringBuffer.append("hint=" + ((Hint)object).getKey() + "   val=" + ((Hint)object).getRenderingHint());
        }
        Iterator iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            stringBuffer.append("key=" + (String)object + "   val=" + this.properties.get(object) + "\n");
        }
        return stringBuffer.toString();
    }

    public static class Hint
    implements Cloneable,
    Serializable {
        static final long serialVersionUID = 1L;
        private final transient RenderingHints.Key key;
        private final transient String keyName;
        private final transient Object[] values;
        private final transient String[] valueNames;
        private int selectedValueIndex;
        private int type = -1;
        private static final Hint[] baseHints = new Hint[]{new Hint("hint.antialiasing", RenderingHints.KEY_ANTIALIASING, new String[]{"hint.0.default", "hint.0.off", "hint.0.on"}, new Object[]{RenderingHints.VALUE_ANTIALIAS_DEFAULT, RenderingHints.VALUE_ANTIALIAS_OFF, RenderingHints.VALUE_ANTIALIAS_ON}, 0), new Hint("hint.colorRendering", RenderingHints.KEY_COLOR_RENDERING, new String[]{"hint.1.default", "hint.1.speed", "hint.1.quality"}, new Object[]{RenderingHints.VALUE_COLOR_RENDER_DEFAULT, RenderingHints.VALUE_COLOR_RENDER_SPEED, RenderingHints.VALUE_COLOR_RENDER_QUALITY}, 0), new Hint("hint.interpolation", RenderingHints.KEY_INTERPOLATION, new String[]{"hint.2.nearestNeighbor", "hint.2.bilinear", "hint.2.bicubic"}, new Object[]{RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, RenderingHints.VALUE_INTERPOLATION_BILINEAR, RenderingHints.VALUE_INTERPOLATION_BICUBIC}, 0), new Hint("hint.dithering", RenderingHints.KEY_DITHERING, new String[]{"hint.3.Default", "hint.3.Disabled", "hint.3.Enabled"}, new Object[]{RenderingHints.VALUE_DITHER_DEFAULT, RenderingHints.VALUE_DITHER_DISABLE, RenderingHints.VALUE_DITHER_ENABLE}, 0), new Hint("hint.fractionalMetrics", RenderingHints.KEY_FRACTIONALMETRICS, new String[]{"hint.4.default", "hint.4.off", "hint.4.on"}, new Object[]{RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT, RenderingHints.VALUE_FRACTIONALMETRICS_OFF, RenderingHints.VALUE_FRACTIONALMETRICS_ON}, 0), new Hint("hint.rendering", RenderingHints.KEY_RENDERING, new String[]{"hint.5.default", "hint.5.speed", "hint.5.quality"}, new Object[]{RenderingHints.VALUE_RENDER_DEFAULT, RenderingHints.VALUE_RENDER_SPEED, RenderingHints.VALUE_RENDER_QUALITY}, 0), new Hint("hint.alphaInterpolation", RenderingHints.KEY_ALPHA_INTERPOLATION, new String[]{"hint.6.default", "hint.6.speed", "hint.6.quality"}, new Object[]{RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY}, 0)};

        private Hint(String string, RenderingHints.Key key, String[] stringArray, Object[] objectArray, int n) {
            this.key = key;
            this.keyName = string;
            this.values = objectArray;
            this.valueNames = stringArray;
            this.selectedValueIndex = n;
        }

        public String getKeyName() {
            return this.keyName;
        }

        RenderingHints.Key getKey() {
            return this.key;
        }

        public String[] getValueNames() {
            return this.valueNames;
        }

        public int getSelectedValueIndex() {
            return this.selectedValueIndex;
        }

        public void setSelectedValueIndex(int n) {
            this.selectedValueIndex = n;
        }

        public Object getRenderingHint() {
            return this.values[this.selectedValueIndex];
        }

        static Hint newInstance(int n, int n2) {
            Hint hint;
            try {
                hint = (Hint)baseHints[n].clone();
                if (n2 != -1) {
                    hint.setSelectedValueIndex(n2);
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace(System.err);
                throw new RuntimeException("*error*:pb. de clonage d'un Hint");
            }
            hint.type = n;
            return hint;
        }

        static Hint newInstance(int n) {
            return Hint.newInstance(n, -1);
        }

        Object readResolve() throws ObjectStreamException {
            return Hint.newInstance(this.type, this.selectedValueIndex);
        }

        public static int getTypesNumber() {
            return baseHints.length;
        }
    }

    public static interface ConfigItem
    extends Cloneable {
        public Object clone() throws CloneNotSupportedException;
    }
}

