/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.calc;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.phbwt.jtans.calc.CalcFigure;
import net.phbwt.jtans.calc.CalcPiece;
import net.phbwt.jtans.calc.PixelFigure;
import net.phbwt.jtans.calc.PixelPiece;

public class EditableFigure
extends PixelFigure {
    private List shapes;
    private PixelPiece selectedDisplayPiece;
    private PixelPiece previousSelectedPiece = null;
    private boolean isRotStep = true;
    private double stepStart = 0.0;
    private double stepVal = 0.19634954084936207;
    int xMin;
    int xMax;
    int yMin;
    int yMax;
    public static final int SEL_NONE = -1;
    public static final int SEL_ACTUAL = 0;
    public static final int SEL_NEW = 1;
    private Point dumPoint = new Point();

    public EditableFigure(CalcFigure calcFigure) {
        this.calcFig = calcFigure;
        this.shapes = new ArrayList();
        Iterator iterator = this.calcFig.pieceIterator();
        while (iterator.hasNext()) {
            this.shapes.add(new PixelPiece((PixelFigure)this, (CalcPiece)iterator.next()));
        }
        this.selectedDisplayPiece = (PixelPiece)this.shapes.remove(0);
    }

    public void setScale(double d) {
        this.scale = d;
        Iterator iterator = this.shapes.iterator();
        while (iterator.hasNext()) {
            ((PixelPiece)iterator.next()).resetShape();
        }
        this.selectedDisplayPiece.resetShape();
        super.reset();
    }

    public void setLimits(int n, int n2, int n3, int n4) {
        this.xMin = n;
        this.xMax = n3;
        this.yMin = n2;
        this.yMax = n4;
        Iterator iterator = this.shapes.iterator();
        while (iterator.hasNext()) {
            this.ensurePieceIsInLimits((PixelPiece)iterator.next(), 0, 0);
        }
        this.ensurePieceIsInLimits(this.selectedDisplayPiece, 0, 0);
    }

    public void setSteppedRotation(double d, double d2) {
        if (d > 0.0) {
            this.isRotStep = true;
            this.stepStart = d2;
            this.stepVal = d;
            Iterator iterator = this.shapes.iterator();
            while (iterator.hasNext()) {
                PixelPiece pixelPiece = (PixelPiece)iterator.next();
                pixelPiece.setRotation(this.constrainRotation(pixelPiece.getRotation()));
            }
            this.setRotationForSelectedPiece(this.selectedDisplayPiece.getRotation());
        } else {
            this.isRotStep = false;
        }
    }

    public PixelPiece getSelectedPiece() {
        return this.selectedDisplayPiece;
    }

    public PixelPiece getPreviousSelectedPiece() {
        return this.previousSelectedPiece;
    }

    public Iterator pieceIteratorBottomUp() {
        return this.shapes.iterator();
    }

    public Iterator pieceIteratorTopDown() {
        int n = this.shapes.size();
        return new Iterator(n){
            int index;
            private final /* synthetic */ int val$first;
            {
                this.index = this.val$first = n;
            }

            public boolean hasNext() {
                return this.index > 0;
            }

            public Object next() {
                return EditableFigure.this.shapes.get(--this.index);
            }

            public void remove() {
                EditableFigure.this.shapes.remove(this.index);
            }
        };
    }

    public boolean setRotationForSelectedPiece(double d) {
        if (Math.abs((d = this.constrainRotation(d)) - this.selectedDisplayPiece.getRotation()) < 1.0E-5) {
            return false;
        }
        this.selectedDisplayPiece.setRotation(d);
        return true;
    }

    private double constrainRotation(double d) {
        d = CalcPiece.normalizeAngle(d);
        if (this.isRotStep) {
            d -= this.stepStart - this.stepVal / 2.0;
            d -= d % this.stepVal;
            d += this.stepStart;
        }
        return d;
    }

    public void flipSelectedPiece() {
        this.selectedDisplayPiece.flip();
    }

    public Point translateSelectedPiece(int n, int n2) {
        return this.ensurePieceIsInLimits(this.selectedDisplayPiece, n, n2);
    }

    public int selectAt(int n, int n2) {
        double d = (double)(n - this.refX) / this.scale;
        double d2 = (double)(n2 - this.refY) / this.scale;
        if (this.selectedDisplayPiece.contains(d, d2)) {
            return 0;
        }
        Iterator iterator = this.pieceIteratorTopDown();
        while (iterator.hasNext()) {
            PixelPiece pixelPiece = (PixelPiece)iterator.next();
            if (!pixelPiece.contains(d, d2)) continue;
            iterator.remove();
            this.shapes.add(this.selectedDisplayPiece);
            this.previousSelectedPiece = this.selectedDisplayPiece;
            this.selectedDisplayPiece = pixelPiece;
            return 1;
        }
        return -1;
    }

    private Point ensurePieceIsInLimits(PixelPiece pixelPiece, int n, int n2) {
        int n3 = pixelPiece.getPosX();
        int n4 = pixelPiece.getPosY();
        this.dumPoint.x = n3 + n < this.xMin ? this.xMin - n3 : (n3 + n > this.xMax ? this.xMax - n3 : n);
        this.dumPoint.y = n4 + n2 < this.yMin ? this.yMin - n4 : (n4 + n2 > this.yMax ? this.yMax - n4 : n2);
        if (this.dumPoint.x != 0 || this.dumPoint.y != 0) {
            pixelPiece.translate(this.dumPoint.x, this.dumPoint.y);
        }
        return this.dumPoint;
    }
}

