/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.calc;

import java.awt.Shape;
import java.util.Iterator;
import net.phbwt.jtans.calc.CalcFigure;
import net.phbwt.jtans.calc.CalcPiece;
import net.phbwt.jtans.calc.CalcPolyPoints;
import net.phbwt.jtans.calc.PixelFigure;
import net.phbwt.jtans.calc.PixelPiece;

public class DisplayFigure
extends PixelFigure {
    private Iterator selectedPieceIterator = null;
    private PixelPiece selectedDisplayPiece = null;

    public DisplayFigure(CalcFigure calcFigure) {
        this.calcFig = calcFigure;
    }

    public void setRef(int n, int n2, double d) {
        this.refX = n;
        this.refY = n2;
        this.scale = d;
        if (this.selectedDisplayPiece != null) {
            this.selectedDisplayPiece.resetShape();
        }
        super.reset();
    }

    public void setScale(double d) {
        this.setRef(0, 0, d);
    }

    public void unselect() {
        this.selectedPieceIterator = null;
        this.selectedDisplayPiece = null;
    }

    public void selectNext() {
        if (this.selectedPieceIterator == null || !this.selectedPieceIterator.hasNext()) {
            this.selectedPieceIterator = this.calcFig.pieceIterator();
        }
        this.selectedDisplayPiece = new PixelPiece((PixelFigure)this, (CalcPiece)this.selectedPieceIterator.next());
    }

    public void resetCoords(int n, int n2, int n3, int n4) {
        CalcPolyPoints calcPolyPoints = this.calcFig.getMinMax();
        double d = Math.min((double)(n3 - n) / (calcPolyPoints.xpoints[1] - calcPolyPoints.xpoints[0]), (double)(n4 - n2) / (calcPolyPoints.ypoints[1] - calcPolyPoints.ypoints[0]));
        int n5 = (int)(((double)(n3 + n) - (calcPolyPoints.xpoints[1] + calcPolyPoints.xpoints[0]) * d) / 2.0);
        int n6 = (int)(((double)(n4 + n2) - (calcPolyPoints.ypoints[1] + calcPolyPoints.ypoints[0]) * d) / 2.0);
        this.setRef(n5, n6, d);
    }

    public void center(int n, int n2, int n3, int n4) {
        CalcPolyPoints calcPolyPoints = this.calcFig.getMinMax();
        int n5 = (int)(((double)(n3 + n) - (calcPolyPoints.xpoints[1] + calcPolyPoints.xpoints[0]) * this.scale) / 2.0);
        int n6 = (int)(((double)(n4 + n2) - (calcPolyPoints.ypoints[1] + calcPolyPoints.ypoints[0]) * this.scale) / 2.0);
        this.setRef(n5, n6, this.scale);
    }

    public Shape getSelectedPiece() {
        return this.selectedDisplayPiece;
    }

    public String toString() {
        return "DisplayFigure(scale=" + this.scale + ", refX=" + this.refX + ", refY=" + this.refY + ")";
    }
}

