/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.calc;

import java.io.IOException;
import java.io.StreamTokenizer;
import net.phbwt.jtans.calc.CalcFigure;
import net.phbwt.jtans.calc.CalcPieceC;
import net.phbwt.jtans.calc.CalcPieceGT;
import net.phbwt.jtans.calc.CalcPieceMT;
import net.phbwt.jtans.calc.CalcPiecePT;
import net.phbwt.jtans.calc.CalcPieceT;
import net.phbwt.jtans.calc.CalcPolyPoints;

public abstract class CalcPiece {
    protected static final double CL = 1.4142135624;
    protected static final double CC = 0.7071067812;
    public static final double HT = 0.7853981633974483;
    protected CalcFigure figure;
    public double posX;
    public double posY;
    public double rotation;
    public boolean isFlipped;
    protected int tinyTabIndex;
    protected int pieceTinyLastChange;
    protected CalcPolyPoints calcPolygon;
    protected double[] xt;
    protected double[] yt;
    protected int polygonLastChange;
    protected int pieceChangeCount;
    private static final double SMALL_C1 = 0.5;
    private static final double SMALL_C2 = 0.16666666666666;

    protected CalcPiece(double d, double d2, double d3, boolean bl) {
        this.posX = d;
        this.posY = d2;
        this.rotation = d3;
        this.isFlipped = bl;
    }

    protected void init(CalcFigure calcFigure, int n, int n2) {
        this.figure = calcFigure;
        this.tinyTabIndex = this.figure.figureTinyTab.calcIndex(n2);
        this.pieceTinyLastChange = -1;
        this.calcPolygon = new CalcPolyPoints(n);
        this.polygonLastChange = -1;
        this.xt = this.calcPolygon.xpoints;
        this.yt = this.calcPolygon.ypoints;
        this.pieceChangeCount = 0;
    }

    public abstract CalcPolyPoints getPolygon();

    public abstract void putInTinyTab();

    public abstract void setFigure(CalcFigure var1);

    public void setRotation(double d) {
        this.rotation = d;
        ++this.pieceChangeCount;
        ++this.figure.figureChangeCount;
    }

    public void flip() {
        this.isFlipped = !this.isFlipped;
        ++this.pieceChangeCount;
        ++this.figure.figureChangeCount;
    }

    public void setPosition(double d, double d2) {
        this.posX = d;
        this.posY = d2;
        ++this.pieceChangeCount;
        ++this.figure.figureChangeCount;
    }

    public void translate(double d, double d2) {
        this.posX += d;
        this.posY += d2;
        ++this.pieceChangeCount;
        ++this.figure.figureChangeCount;
    }

    public boolean contains(double d, double d2) {
        int n;
        this.calcPolygon = this.getPolygon();
        for (n = 0; n < this.calcPolygon.npoints - 1; ++n) {
            if (!((d - this.xt[n]) * (this.yt[n + 1] - this.yt[n]) - (d2 - this.yt[n]) * (this.xt[n + 1] - this.xt[n]) > 0.0)) continue;
            return false;
        }
        return !((d - this.xt[n]) * (this.yt[0] - this.yt[n]) - (d2 - this.yt[n]) * (this.xt[0] - this.xt[n]) > 0.0);
    }

    protected int putSmallTriangleAt(int n, double d, double d2, double d3) {
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        this.figure.figureTinyTab.putTriangleAt(n++, d + 0.5 * d4 + 0.16666666666666 * d5, d2 + 0.16666666666666 * d4 - 0.5 * d5, CalcPiece.normalizeAngle(d3 + 2.356194490192345));
        this.figure.figureTinyTab.putTriangleAt(n++, d + 0.16666666666666 * d4 + 0.5 * d5, d2 + 0.5 * d4 - 0.16666666666666 * d5, CalcPiece.normalizeAngle(d3 + 3.9269908169872414));
        return n;
    }

    public String toString() {
        return "(" + this.getClass().getName() + ":x=" + this.posX + ":y=" + this.posY + ":r=" + this.rotation + ":f=" + this.isFlipped + ")";
    }

    public static double normalizeAngle(double d) {
        if ((d %= Math.PI * 2) < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    StoredPiece getStoredPiece() {
        return new StoredPiece(this);
    }

    public static class StoredPiece {
        private double posX;
        private double posY;
        private double rotation;
        private boolean isFlipped;
        private byte type;

        private StoredPiece(CalcPiece calcPiece) {
            this.posX = calcPiece.posX;
            this.posY = calcPiece.posY;
            this.rotation = calcPiece.rotation;
            this.isFlipped = calcPiece.isFlipped;
            if (calcPiece instanceof CalcPieceGT) {
                this.type = 0;
            } else if (calcPiece instanceof CalcPieceMT) {
                this.type = 1;
            } else if (calcPiece instanceof CalcPieceC) {
                this.type = (byte)2;
            } else if (calcPiece instanceof CalcPieceT) {
                this.type = (byte)3;
            } else if (calcPiece instanceof CalcPiecePT) {
                this.type = (byte)4;
            }
        }

        CalcPiece getCalcPiece() {
            CalcPiece calcPiece;
            switch (this.type) {
                case 0: {
                    calcPiece = new CalcPieceGT(this.posX, this.posY, this.rotation, this.isFlipped);
                    break;
                }
                case 1: {
                    calcPiece = new CalcPieceMT(this.posX, this.posY, this.rotation, this.isFlipped);
                    break;
                }
                case 2: {
                    calcPiece = new CalcPieceC(this.posX, this.posY, this.rotation, this.isFlipped);
                    break;
                }
                case 3: {
                    calcPiece = new CalcPieceT(this.posX, this.posY, this.rotation, this.isFlipped);
                    break;
                }
                case 4: {
                    calcPiece = new CalcPiecePT(this.posX, this.posY, this.rotation, this.isFlipped);
                    break;
                }
                default: {
                    throw new RuntimeException("shouldn't occur");
                }
            }
            return calcPiece;
        }

        StoredPiece(StreamTokenizer streamTokenizer) throws IOException {
            if (streamTokenizer.nextToken() != -3 || !"p".equals(streamTokenizer.sval)) {
                throw new RuntimeException("bad piece format : line=" + streamTokenizer.lineno());
            }
            try {
                streamTokenizer.nextToken();
                this.type = Byte.parseByte(streamTokenizer.sval);
                streamTokenizer.nextToken();
                this.isFlipped = Integer.parseInt(streamTokenizer.sval) == 1;
                streamTokenizer.nextToken();
                this.posX = Double.parseDouble(streamTokenizer.sval);
                streamTokenizer.nextToken();
                this.posY = Double.parseDouble(streamTokenizer.sval);
                streamTokenizer.nextToken();
                this.rotation = CalcPiece.normalizeAngle((double)Integer.parseInt(streamTokenizer.sval) * 2.0 * Math.PI / 65536.0);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("bad piece format : line = " + streamTokenizer.lineno());
            }
            if (streamTokenizer.nextToken() != 10) {
                throw new RuntimeException("bad piece : expecting eol : line=" + streamTokenizer.lineno());
            }
        }

        public String toString() {
            return "p " + this.type + (this.isFlipped ? " 1 " : " 0 ") + this.posX + " " + this.posY + " " + Math.round(CalcPiece.normalizeAngle(this.rotation) * 32768.0 / Math.PI) + "\n";
        }
    }
}

