/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.Archive;
import org.jrobin.core.Header;
import org.jrobin.core.RrdAllocator;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdDouble;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdLong;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;

public class ArcState
implements RrdUpdater {
    private Archive parentArc;
    private RrdDouble accumValue;
    private RrdLong nanSteps;

    ArcState(Archive parentArc, boolean shouldInitialize) throws IOException {
        this.parentArc = parentArc;
        this.accumValue = new RrdDouble(this);
        this.nanSteps = new RrdLong(this);
        if (shouldInitialize) {
            Header header = parentArc.getParentDb().getHeader();
            long step = header.getStep();
            long lastUpdateTime = header.getLastUpdateTime();
            long arcStep = parentArc.getArcStep();
            long initNanSteps = (Util.normalize(lastUpdateTime, step) - Util.normalize(lastUpdateTime, arcStep)) / step;
            this.accumValue.set(Double.NaN);
            this.nanSteps.set(initNanSteps);
        }
    }

    String dump() throws IOException {
        return "accumValue:" + this.accumValue.get() + " nanSteps:" + this.nanSteps.get() + "\n";
    }

    void setNanSteps(long value) throws IOException {
        this.nanSteps.set(value);
    }

    public long getNanSteps() throws IOException {
        return this.nanSteps.get();
    }

    void setAccumValue(double value) throws IOException {
        this.accumValue.set(value);
    }

    public double getAccumValue() throws IOException {
        return this.accumValue.get();
    }

    public Archive getParent() {
        return this.parentArc;
    }

    void appendXml(XmlWriter writer) throws IOException {
        writer.startTag("ds");
        writer.writeTag("value", this.accumValue.get());
        writer.writeTag("unknown_datapoints", this.nanSteps.get());
        writer.closeTag();
    }

    public void copyStateTo(RrdUpdater other) throws IOException, RrdException {
        if (!(other instanceof ArcState)) {
            throw new RrdException("Cannot copy ArcState object to " + other.getClass().getName());
        }
        ArcState arcState = (ArcState)other;
        arcState.accumValue.set(this.accumValue.get());
        arcState.nanSteps.set(this.nanSteps.get());
    }

    public RrdBackend getRrdBackend() {
        return this.parentArc.getRrdBackend();
    }

    public RrdAllocator getRrdAllocator() {
        return this.parentArc.getRrdAllocator();
    }
}

