/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.imageio.ImageIO;
import org.jrobin.graph.GifEncoder;
import org.jrobin.graph.PathIterator;

class ImageWorker {
    private static final String DUMMY_TEXT = "Dummy";
    private BufferedImage img;
    private Graphics2D gd;
    private int imgWidth;
    private int imgHeight;
    private AffineTransform aftInitial;

    ImageWorker(int width, int height) {
        this.resize(width, height);
    }

    void resize(int width, int height) {
        if (this.gd != null) {
            this.gd.dispose();
        }
        this.imgWidth = width;
        this.imgHeight = height;
        this.img = new BufferedImage(width, height, 1);
        this.gd = this.img.createGraphics();
        this.aftInitial = this.gd.getTransform();
        this.setAntiAliasing(false);
    }

    void clip(int x, int y, int width, int height) {
        this.gd.setClip(x, y, width, height);
    }

    void transform(int x, int y, double angle) {
        this.gd.translate(x, y);
        this.gd.rotate(angle);
    }

    void reset() {
        this.gd.setTransform(this.aftInitial);
        this.gd.setClip(0, 0, this.imgWidth, this.imgHeight);
    }

    void fillRect(int x, int y, int width, int height, Paint paint) {
        this.gd.setPaint(paint);
        this.gd.fillRect(x, y, width, height);
    }

    void fillPolygon(int[] x, int[] y, Paint paint) {
        this.gd.setPaint(paint);
        this.gd.fillPolygon(x, y, x.length);
    }

    void fillPolygon(double[] x, double yBottom, double[] yTop, Paint paint) {
        this.gd.setPaint(paint);
        PathIterator path = new PathIterator(yTop);
        int[] pos = path.getNextPath();
        while (pos != null) {
            int start = pos[0];
            int end = pos[1];
            int n = end - start;
            int[] xDev = new int[n + 2];
            int[] yDev = new int[n + 2];
            int i = start;
            while (i < end) {
                xDev[i - start] = (int)x[i];
                yDev[i - start] = (int)yTop[i];
                ++i;
            }
            xDev[n] = xDev[n - 1];
            xDev[n + 1] = xDev[0];
            int n2 = (int)yBottom;
            yDev[n + 1] = n2;
            yDev[n] = n2;
            this.gd.fillPolygon(xDev, yDev, xDev.length);
            this.gd.drawPolygon(xDev, yDev, xDev.length);
            pos = path.getNextPath();
        }
    }

    void fillPolygon(double[] x, double[] yBottom, double[] yTop, Paint paint) {
        this.gd.setPaint(paint);
        PathIterator path = new PathIterator(yTop);
        int[] pos = path.getNextPath();
        while (pos != null) {
            int start = pos[0];
            int end = pos[1];
            int n = end - start;
            int[] xDev = new int[n * 2];
            int[] yDev = new int[n * 2];
            int i = start;
            while (i < end) {
                int ix1 = i - start;
                int ix2 = n * 2 - 1 - i + start;
                xDev[ix1] = xDev[ix2] = (int)x[i];
                yDev[ix1] = (int)yTop[i];
                yDev[ix2] = (int)yBottom[i];
                ++i;
            }
            this.gd.fillPolygon(xDev, yDev, xDev.length);
            this.gd.drawPolygon(xDev, yDev, xDev.length);
            pos = path.getNextPath();
        }
    }

    void drawLine(int x1, int y1, int x2, int y2, Paint paint, Stroke stroke) {
        this.gd.setStroke(stroke);
        this.gd.setPaint(paint);
        this.gd.drawLine(x1, y1, x2, y2);
    }

    void drawPolyline(int[] x, int[] y, Paint paint, Stroke stroke) {
        this.gd.setStroke(stroke);
        this.gd.setPaint(paint);
        this.gd.drawPolyline(x, y, x.length);
    }

    void drawPolyline(double[] x, double[] y, Paint paint, Stroke stroke) {
        this.gd.setPaint(paint);
        this.gd.setStroke(stroke);
        PathIterator path = new PathIterator(y);
        int[] pos = path.getNextPath();
        while (pos != null) {
            int start = pos[0];
            int end = pos[1];
            int[] xDev = new int[end - start];
            int[] yDev = new int[end - start];
            int i = start;
            while (i < end) {
                xDev[i - start] = (int)x[i];
                yDev[i - start] = (int)y[i];
                ++i;
            }
            this.gd.drawPolyline(xDev, yDev, xDev.length);
            pos = path.getNextPath();
        }
    }

    void drawString(String text, int x, int y, Font font, Paint paint) {
        this.gd.setFont(font);
        this.gd.setPaint(paint);
        this.gd.drawString(text, x, y);
    }

    double getFontAscent(Font font) {
        LineMetrics lm = font.getLineMetrics(DUMMY_TEXT, this.gd.getFontRenderContext());
        return lm.getAscent();
    }

    double getFontHeight(Font font) {
        LineMetrics lm = font.getLineMetrics(DUMMY_TEXT, this.gd.getFontRenderContext());
        return lm.getAscent() + lm.getDescent();
    }

    double getStringWidth(String text, Font font) {
        return font.getStringBounds(text, 0, text.length(), this.gd.getFontRenderContext()).getBounds().getWidth();
    }

    void setAntiAliasing(boolean enable) {
        this.gd.setRenderingHint(RenderingHints.KEY_ANTIALIASING, enable ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.gd.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.gd.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    void dispose() {
        this.gd.dispose();
    }

    void saveImage(OutputStream stream, String type, float quality) throws IOException {
        if (type.equalsIgnoreCase("png")) {
            ImageIO.write((RenderedImage)this.img, "png", stream);
        } else if (type.equalsIgnoreCase("gif")) {
            GifEncoder gifEncoder = new GifEncoder(this.img);
            gifEncoder.encode(stream);
        } else if (type.equalsIgnoreCase("jpg") || type.equalsIgnoreCase("jpeg")) {
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)stream);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(this.img);
            param.setQuality(quality, false);
            encoder.setJPEGEncodeParam(param);
            encoder.encode(this.img);
        } else {
            throw new IOException("Unsupported image format: " + type);
        }
        stream.flush();
    }

    byte[] saveImage(String path, String type, float quality) throws IOException {
        byte[] bytes = this.getImageBytes(type, quality);
        RandomAccessFile f = new RandomAccessFile(path, "rw");
        try {
            f.write(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            f.close();
        }
    }

    byte[] getImageBytes(String type, float quality) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.saveImage(stream, type, quality);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        finally {
            stream.close();
        }
    }

    public void loadImage(String imageFile) throws IOException {
        BufferedImage wpImage = ImageIO.read(new File(imageFile));
        TexturePaint paint = new TexturePaint(wpImage, new Rectangle(0, 0, wpImage.getWidth(), wpImage.getHeight()));
        this.gd.setPaint(paint);
        this.gd.fillRect(0, 0, wpImage.getWidth(), wpImage.getHeight());
    }
}

