/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.data;

import java.util.Calendar;
import java.util.Date;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.data.Plottable;

public class LinearInterpolator
extends Plottable {
    public static final int INTERPOLATE_LEFT = 0;
    public static final int INTERPOLATE_RIGHT = 1;
    public static final int INTERPOLATE_LINEAR = 2;
    public static final int INTERPOLATE_REGRESSION = 3;
    private int lastIndexUsed = 0;
    private int interpolationMethod = 2;
    private long[] timestamps;
    private double[] values;
    double b0 = Double.NaN;
    double b1 = Double.NaN;

    public LinearInterpolator(long[] timestamps, double[] values) throws RrdException {
        this.timestamps = timestamps;
        this.values = values;
        this.validate();
    }

    public LinearInterpolator(Date[] dates, double[] values) throws RrdException {
        this.values = values;
        this.timestamps = new long[dates.length];
        int i = 0;
        while (i < dates.length) {
            this.timestamps[i] = Util.getTimestamp(dates[i]);
            ++i;
        }
        this.validate();
    }

    public LinearInterpolator(Calendar[] dates, double[] values) throws RrdException {
        this.values = values;
        this.timestamps = new long[dates.length];
        int i = 0;
        while (i < dates.length) {
            this.timestamps[i] = Util.getTimestamp(dates[i]);
            ++i;
        }
        this.validate();
    }

    private void validate() throws RrdException {
        boolean ok = true;
        if (this.timestamps.length != this.values.length || this.timestamps.length < 2) {
            ok = false;
        }
        int i = 0;
        while (i < this.timestamps.length - 1 && ok) {
            if (this.timestamps[i] >= this.timestamps[i + 1]) {
                ok = false;
            }
            ++i;
        }
        if (!ok) {
            throw new RrdException("Invalid plottable data supplied");
        }
    }

    public void setInterpolationMethod(int interpolationMethod) {
        switch (interpolationMethod) {
            case 3: {
                this.calculateBestFitLine();
            }
            case 0: 
            case 1: 
            case 2: {
                this.interpolationMethod = interpolationMethod;
                break;
            }
            default: {
                this.interpolationMethod = 2;
            }
        }
    }

    private void calculateBestFitLine() {
        int count = this.timestamps.length;
        int validCount = 0;
        double ts = 0.0;
        double vs = 0.0;
        int i = 0;
        while (i < count) {
            if (!Double.isNaN(this.values[i])) {
                ts += (double)this.timestamps[i];
                vs += this.values[i];
                ++validCount;
            }
            ++i;
        }
        if (validCount <= 1) {
            this.b1 = Double.NaN;
            this.b0 = Double.NaN;
            return;
        }
        ts /= (double)validCount;
        vs /= (double)validCount;
        double s1 = 0.0;
        double s2 = 0.0;
        int i2 = 0;
        while (i2 < count) {
            if (!Double.isNaN(this.values[i2])) {
                double dt = (double)this.timestamps[i2] - ts;
                double dv = this.values[i2] - vs;
                s1 += dt * dv;
                s2 += dt * dt;
            }
            ++i2;
        }
        this.b1 = s1 / s2;
        this.b0 = vs - this.b1 * ts;
    }

    public double getValue(long timestamp) {
        if (this.interpolationMethod == 3) {
            return this.b0 + this.b1 * (double)timestamp;
        }
        int count = this.timestamps.length;
        if (timestamp < this.timestamps[0] || timestamp > this.timestamps[count - 1]) {
            return Double.NaN;
        }
        int startIndex = this.lastIndexUsed;
        if (timestamp < this.timestamps[this.lastIndexUsed]) {
            startIndex = 0;
        }
        int i = startIndex;
        while (i < count) {
            if (this.timestamps[i] == timestamp) {
                return this.values[i];
            }
            if (i < count - 1 && this.timestamps[i] < timestamp && timestamp < this.timestamps[i + 1]) {
                this.lastIndexUsed = i;
                switch (this.interpolationMethod) {
                    case 0: {
                        return this.values[i];
                    }
                    case 1: {
                        return this.values[i + 1];
                    }
                    case 2: {
                        double slope = (this.values[i + 1] - this.values[i]) / (double)(this.timestamps[i + 1] - this.timestamps[i]);
                        return this.values[i] + slope * (double)(timestamp - this.timestamps[i]);
                    }
                }
                return Double.NaN;
            }
            ++i;
        }
        return Double.NaN;
    }
}

