/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Font;
import java.awt.Paint;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.TimeAxisSetting;

class TimeAxis
implements RrdGraphConstants {
    private static final TimeAxisSetting[] tickSettings = new TimeAxisSetting[]{new TimeAxisSetting(0L, 13, 30, 12, 5, 12, 5, 0, "HH:mm"), new TimeAxisSetting(2L, 12, 1, 12, 5, 12, 5, 0, "HH:mm"), new TimeAxisSetting(5L, 12, 2, 12, 10, 12, 10, 0, "HH:mm"), new TimeAxisSetting(10L, 12, 5, 12, 20, 12, 20, 0, "HH:mm"), new TimeAxisSetting(30L, 12, 10, 11, 1, 11, 1, 0, "HH:mm"), new TimeAxisSetting(60L, 12, 30, 11, 2, 11, 2, 0, "HH:mm"), new TimeAxisSetting(180L, 11, 1, 11, 6, 11, 6, 0, "HH:mm"), new TimeAxisSetting(600L, 11, 6, 5, 1, 5, 1, 86400, "EEE"), new TimeAxisSetting(1800L, 11, 12, 5, 1, 5, 2, 86400, "EEE"), new TimeAxisSetting(3600L, 5, 1, 3, 1, 3, 1, 604800, "'Week 'w"), new TimeAxisSetting(10800L, 3, 1, 2, 1, 3, 2, 604800, "'Week 'w"), new TimeAxisSetting(21600L, 2, 1, 2, 1, 2, 1, 2592000, "MMM"), new TimeAxisSetting(172800L, 2, 1, 2, 3, 2, 3, 2592000, "MMM"), new TimeAxisSetting(864000L, 1, 1, 1, 1, 1, 1, 31536000, "yy"), new TimeAxisSetting(-1L, 2, 0, 2, 0, 2, 0, 0, "")};
    private TimeAxisSetting tickSetting;
    private RrdGraph rrdGraph;
    private double secPerPix;
    private Calendar calendar;

    TimeAxis(RrdGraph rrdGraph) {
        this.rrdGraph = rrdGraph;
        if (rrdGraph.im.xsize > 0) {
            this.secPerPix = (double)(rrdGraph.im.end - rrdGraph.im.start) / Double.valueOf(rrdGraph.im.xsize);
        }
        this.calendar = Calendar.getInstance(Locale.getDefault());
        this.calendar.setFirstDayOfWeek(rrdGraph.gdef.firstDayOfWeek);
    }

    void draw() {
        this.chooseTickSettings();
        if (this.tickSetting == null) {
            return;
        }
        this.drawMinor();
        this.drawMajor();
        this.drawLabels();
    }

    private void drawMinor() {
        if (!this.rrdGraph.gdef.noMinorGrid) {
            this.adjustStartingTime(this.tickSetting.minorUnit, this.tickSetting.minorUnitCount);
            Paint color = this.rrdGraph.gdef.colors[4];
            int y0 = this.rrdGraph.im.yorigin;
            int y1 = y0 - this.rrdGraph.im.ysize;
            int status = this.getTimeShift();
            while (status <= 0) {
                if (status == 0) {
                    long time = this.calendar.getTime().getTime() / 1000L;
                    int x = this.rrdGraph.mapper.xtr(time);
                    this.rrdGraph.worker.drawLine(x, y0 - 1, x, y0 + 1, color, TICK_STROKE);
                    this.rrdGraph.worker.drawLine(x, y0, x, y1, color, GRID_STROKE);
                }
                this.findNextTime(this.tickSetting.minorUnit, this.tickSetting.minorUnitCount);
                status = this.getTimeShift();
            }
        }
    }

    private void drawMajor() {
        this.adjustStartingTime(this.tickSetting.majorUnit, this.tickSetting.majorUnitCount);
        Paint color = this.rrdGraph.gdef.colors[5];
        int y0 = this.rrdGraph.im.yorigin;
        int y1 = y0 - this.rrdGraph.im.ysize;
        int status = this.getTimeShift();
        while (status <= 0) {
            if (status == 0) {
                long time = this.calendar.getTime().getTime() / 1000L;
                int x = this.rrdGraph.mapper.xtr(time);
                this.rrdGraph.worker.drawLine(x, y0 - 2, x, y0 + 2, color, TICK_STROKE);
                this.rrdGraph.worker.drawLine(x, y0, x, y1, color, GRID_STROKE);
            }
            this.findNextTime(this.tickSetting.majorUnit, this.tickSetting.majorUnitCount);
            status = this.getTimeShift();
        }
    }

    private void drawLabels() {
        String labelFormat = this.tickSetting.format.replaceAll("([^%]|^)%([^%t])", "$1%t$2");
        Font font = this.rrdGraph.gdef.smallFont;
        Paint color = this.rrdGraph.gdef.colors[6];
        this.adjustStartingTime(this.tickSetting.labelUnit, this.tickSetting.labelUnitCount);
        int y = this.rrdGraph.im.yorigin + (int)this.rrdGraph.worker.getFontHeight(font) + 2;
        int status = this.getTimeShift();
        while (status <= 0) {
            int labelWidth;
            int x2;
            String label = TimeAxis.formatLabel(labelFormat, this.calendar.getTime());
            long time = this.calendar.getTime().getTime() / 1000L;
            int x1 = this.rrdGraph.mapper.xtr(time);
            int x = x1 + ((x2 = this.rrdGraph.mapper.xtr(time + (long)this.tickSetting.labelSpan)) - x1 - (labelWidth = (int)this.rrdGraph.worker.getStringWidth(label, font))) / 2;
            if (x >= this.rrdGraph.im.xorigin && x + labelWidth <= this.rrdGraph.im.xorigin + this.rrdGraph.im.xsize) {
                this.rrdGraph.worker.drawString(label, x, y, font, color);
            }
            this.findNextTime(this.tickSetting.labelUnit, this.tickSetting.labelUnitCount);
            status = this.getTimeShift();
        }
    }

    private static String formatLabel(String format, Date date) {
        if (format.contains("%")) {
            return String.format(format, date);
        }
        return new SimpleDateFormat(format).format(date);
    }

    private void findNextTime(int timeUnit, int timeUnitCount) {
        switch (timeUnit) {
            case 13: {
                this.calendar.add(13, timeUnitCount);
                break;
            }
            case 12: {
                this.calendar.add(12, timeUnitCount);
                break;
            }
            case 11: {
                this.calendar.add(11, timeUnitCount);
                break;
            }
            case 5: {
                this.calendar.add(5, timeUnitCount);
                break;
            }
            case 3: {
                this.calendar.add(5, 7 * timeUnitCount);
                break;
            }
            case 2: {
                this.calendar.add(2, timeUnitCount);
                break;
            }
            case 1: {
                this.calendar.add(1, timeUnitCount);
            }
        }
    }

    private int getTimeShift() {
        long time = this.calendar.getTime().getTime() / 1000L;
        return time < this.rrdGraph.im.start ? -1 : (time > this.rrdGraph.im.end ? 1 : 0);
    }

    private void adjustStartingTime(int timeUnit, int timeUnitCount) {
        this.calendar.setTime(new Date(this.rrdGraph.im.start * 1000L));
        switch (timeUnit) {
            case 13: {
                this.calendar.add(13, -(this.calendar.get(13) % timeUnitCount));
                break;
            }
            case 12: {
                this.calendar.set(13, 0);
                this.calendar.add(12, -(this.calendar.get(12) % timeUnitCount));
                break;
            }
            case 11: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.add(11, -(this.calendar.get(11) % timeUnitCount));
                break;
            }
            case 5: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.set(11, 0);
                break;
            }
            case 3: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.set(11, 0);
                int diffDays = this.calendar.get(7) - this.calendar.getFirstDayOfWeek();
                if (diffDays < 0) {
                    diffDays += 7;
                }
                this.calendar.add(5, -diffDays);
                break;
            }
            case 2: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.set(11, 0);
                this.calendar.set(5, 1);
                this.calendar.add(2, -(this.calendar.get(2) % timeUnitCount));
                break;
            }
            case 1: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.set(11, 0);
                this.calendar.set(5, 1);
                this.calendar.set(2, 0);
                this.calendar.add(1, -(this.calendar.get(1) % timeUnitCount));
            }
        }
    }

    private void chooseTickSettings() {
        if (this.rrdGraph.gdef.timeAxisSetting != null) {
            this.tickSetting = new TimeAxisSetting(this.rrdGraph.gdef.timeAxisSetting);
        } else {
            int i = 0;
            while (TimeAxis.tickSettings[i].secPerPix >= 0L && this.secPerPix > (double)TimeAxis.tickSettings[i].secPerPix) {
                this.tickSetting = tickSettings[i];
                ++i;
            }
        }
    }
}

