/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.timespec;

import org.jrobin.core.timespec.TimeToken;

class TimeScanner {
    private String dateString;
    private int pos;
    private int pos_save;
    private TimeToken token;
    private TimeToken token_save;
    static final TimeToken[] WORDS = new TimeToken[]{new TimeToken("midnight", 1), new TimeToken("noon", 2), new TimeToken("teatime", 3), new TimeToken("am", 5), new TimeToken("pm", 4), new TimeToken("tomorrow", 8), new TimeToken("yesterday", 6), new TimeToken("today", 7), new TimeToken("now", 9), new TimeToken("n", 9), new TimeToken("start", 10), new TimeToken("s", 10), new TimeToken("end", 11), new TimeToken("e", 11), new TimeToken("jan", 28), new TimeToken("feb", 29), new TimeToken("mar", 30), new TimeToken("apr", 31), new TimeToken("may", 32), new TimeToken("jun", 33), new TimeToken("jul", 34), new TimeToken("aug", 35), new TimeToken("sep", 36), new TimeToken("oct", 37), new TimeToken("nov", 38), new TimeToken("dec", 39), new TimeToken("january", 28), new TimeToken("february", 29), new TimeToken("march", 30), new TimeToken("april", 31), new TimeToken("may", 32), new TimeToken("june", 33), new TimeToken("july", 34), new TimeToken("august", 35), new TimeToken("september", 36), new TimeToken("october", 37), new TimeToken("november", 38), new TimeToken("december", 39), new TimeToken("sunday", 40), new TimeToken("sun", 40), new TimeToken("monday", 41), new TimeToken("mon", 41), new TimeToken("tuesday", 42), new TimeToken("tue", 42), new TimeToken("wednesday", 43), new TimeToken("wed", 43), new TimeToken("thursday", 44), new TimeToken("thu", 44), new TimeToken("friday", 45), new TimeToken("fri", 45), new TimeToken("saturday", 46), new TimeToken("sat", 46), new TimeToken(null, 0)};
    static TimeToken[] MULTIPLIERS = new TimeToken[]{new TimeToken("second", 12), new TimeToken("seconds", 12), new TimeToken("sec", 12), new TimeToken("s", 12), new TimeToken("minute", 13), new TimeToken("minutes", 13), new TimeToken("min", 13), new TimeToken("m", 19), new TimeToken("hour", 14), new TimeToken("hours", 14), new TimeToken("hr", 14), new TimeToken("h", 14), new TimeToken("day", 15), new TimeToken("days", 15), new TimeToken("d", 15), new TimeToken("week", 16), new TimeToken("weeks", 16), new TimeToken("wk", 16), new TimeToken("w", 16), new TimeToken("month", 17), new TimeToken("months", 17), new TimeToken("mon", 17), new TimeToken("year", 18), new TimeToken("years", 18), new TimeToken("yr", 18), new TimeToken("y", 18), new TimeToken(null, 0)};
    TimeToken[] specials = WORDS;

    public TimeScanner(String dateString) {
        this.dateString = dateString;
    }

    void setContext(boolean parsingWords) {
        this.specials = parsingWords ? WORDS : MULTIPLIERS;
    }

    TimeToken nextToken() {
        StringBuffer buffer = new StringBuffer("");
        while (this.pos < this.dateString.length()) {
            char c;
            if (Character.isWhitespace(c = this.dateString.charAt(this.pos++)) || c == '_' || c == ',') continue;
            buffer.append(c);
            if (Character.isDigit(c)) {
                char next;
                while (this.pos < this.dateString.length() && Character.isDigit(next = this.dateString.charAt(this.pos))) {
                    buffer.append(next);
                    ++this.pos;
                }
                String value = buffer.toString();
                this.token = new TimeToken(value, 20);
                return this.token;
            }
            if (Character.isLetter(c)) {
                char next;
                while (this.pos < this.dateString.length() && Character.isLetter(next = this.dateString.charAt(this.pos))) {
                    buffer.append(next);
                    ++this.pos;
                }
                String value = buffer.toString();
                this.token = new TimeToken(value, this.parseToken(value));
                return this.token;
            }
            switch (c) {
                case ':': {
                    this.token = new TimeToken(":", 24);
                    return this.token;
                }
                case '.': {
                    this.token = new TimeToken(".", 23);
                    return this.token;
                }
                case '+': {
                    this.token = new TimeToken("+", 21);
                    return this.token;
                }
                case '-': {
                    this.token = new TimeToken("-", 22);
                    return this.token;
                }
                case '/': {
                    this.token = new TimeToken("/", 25);
                    return this.token;
                }
            }
            --this.pos;
            this.token = new TimeToken(null, -1);
            return this.token;
        }
        this.token = new TimeToken(null, -1);
        return this.token;
    }

    TimeToken resolveMonthsMinutes(int newId) {
        assert (this.token.id == 19);
        assert (newId == 17 || newId == 13);
        this.token = new TimeToken(this.token.value, newId);
        return this.token;
    }

    void saveState() {
        this.token_save = this.token;
        this.pos_save = this.pos;
    }

    TimeToken restoreState() {
        this.pos = this.pos_save;
        this.token = this.token_save;
        return this.token;
    }

    private int parseToken(String arg) {
        int i = 0;
        while (this.specials[i].value != null) {
            if (this.specials[i].value.equalsIgnoreCase(arg)) {
                return this.specials[i].id;
            }
            ++i;
        }
        return 26;
    }
}

