/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jrobin.core.RrdException;
import org.jrobin.core.jrrd.Constants;

public class RRDFile
implements Constants {
    boolean bigEndian;
    boolean debug;
    int alignment;
    RandomAccessFile ras;
    byte[] buffer;

    RRDFile(String name) throws IOException, RrdException {
        this(new File(name));
    }

    RRDFile(File file) throws IOException, RrdException {
        this.ras = new RandomAccessFile(file, "r");
        this.buffer = new byte[128];
        this.debug = false;
        this.initDataLayout(file);
    }

    private void initDataLayout(File file) throws IOException, RrdException {
        if (file.exists()) {
            int bytes = this.ras.read(this.buffer, 0, 24);
            if (bytes < 24) {
                throw new RrdException("Invalid RRD file");
            }
            int index = this.indexOf(FLOAT_COOKIE_BIG_ENDIAN, this.buffer);
            if (index != -1) {
                this.bigEndian = true;
            } else {
                index = this.indexOf(FLOAT_COOKIE_LITTLE_ENDIAN, this.buffer);
                if (index != -1) {
                    this.bigEndian = false;
                } else {
                    throw new RrdException("Invalid RRD file");
                }
            }
            switch (index) {
                case 12: {
                    this.alignment = 4;
                    break;
                }
                case 16: {
                    this.alignment = 8;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported architecture - neither 32-bit nor 64-bit, or maybe the file is corrupt");
                }
            }
        }
        this.ras.seek(0L);
    }

    private int indexOf(byte[] pattern, byte[] array) {
        return new String(array).indexOf(new String(pattern));
    }

    boolean isBigEndian() {
        return this.bigEndian;
    }

    int getAlignment() {
        return this.alignment;
    }

    double readDouble() throws IOException, RrdException {
        if (this.debug) {
            System.out.print("Read 8 bytes (Double) from offset " + this.ras.getFilePointer() + ":");
        }
        byte[] tx = new byte[8];
        if (this.ras.read(this.buffer, 0, 8) != 8) {
            throw new RrdException("Invalid RRD file");
        }
        if (this.bigEndian) {
            tx = this.buffer;
        } else {
            for (int i = 0; i < 8; ++i) {
                tx[7 - i] = this.buffer[i];
            }
        }
        DataInputStream reverseDis = new DataInputStream(new ByteArrayInputStream(tx));
        Double result = reverseDis.readDouble();
        if (this.debug) {
            System.out.println(result);
        }
        return result;
    }

    int readInt() throws IOException, RrdException {
        return this.readInt(false);
    }

    int readInt(boolean dump) throws IOException, RrdException {
        if (this.debug) {
            System.out.print("Read " + this.alignment + " bytes (int) from offset " + this.ras.getFilePointer() + ":");
        }
        if (this.ras.read(this.buffer, 0, this.alignment) != this.alignment) {
            throw new RrdException("Invalid RRD file");
        }
        int value = this.bigEndian ? (this.alignment == 8 ? 0xFF & this.buffer[7] | (0xFF & this.buffer[6]) << 8 | (0xFF & this.buffer[5]) << 16 | (0xFF & this.buffer[4]) << 24 : 0xFF & this.buffer[3] | (0xFF & this.buffer[2]) << 8 | (0xFF & this.buffer[1]) << 16 | (0xFF & this.buffer[0]) << 24) : 0xFF & this.buffer[0] | (0xFF & this.buffer[1]) << 8 | (0xFF & this.buffer[2]) << 16 | (0xFF & this.buffer[3]) << 24;
        if (this.debug) {
            System.out.println(value);
        }
        return value;
    }

    String readString(int maxLength) throws IOException, RrdException {
        if (this.debug) {
            System.out.print("Read " + maxLength + " bytes (string) from offset " + this.ras.getFilePointer() + ":");
        }
        if ((maxLength = this.ras.read(this.buffer, 0, maxLength)) == -1) {
            throw new RrdException("Invalid RRD file");
        }
        String result = new String(this.buffer, 0, maxLength).trim();
        if (this.debug) {
            System.out.println(result + ":");
        }
        return result;
    }

    void skipBytes(int n) throws IOException {
        int bytesSkipped = this.ras.skipBytes(n);
        if (this.debug) {
            System.out.println("Skipping " + bytesSkipped + " bytes");
        }
    }

    int align(int boundary) throws IOException {
        int skip = (int)((long)boundary - this.ras.getFilePointer() % (long)boundary) % boundary;
        if (skip != 0) {
            skip = this.ras.skipBytes(skip);
        }
        if (this.debug) {
            System.out.println("Aligning to boundary " + boundary + ".  Offset is now " + this.ras.getFilePointer());
        }
        return skip;
    }

    int align() throws IOException {
        return this.align(this.alignment);
    }

    long info() throws IOException {
        return this.ras.getFilePointer();
    }

    long getFilePointer() throws IOException {
        return this.ras.getFilePointer();
    }

    void close() throws IOException {
        this.ras.close();
    }
}

