/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.viewmaker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBView;
import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.images.Images;
import pilotdb.ui.util.FlatJButton;

public class ViewListPanel
extends JPanel
implements ActionListener {
    Thread viewWatchingThread = null;
    boolean viewWatcherKeepRunning = true;
    Vector actionListeners = new Vector();
    JList jlViews = null;
    JScrollPane jspViews = null;
    JButton jbDone = null;
    JPanel jpOkCancel = null;
    JButton jbEdit = null;
    JButton jbDelete = null;
    JButton jbNew = null;
    PilotDBDatabase db = null;
    ViewListModel listModel = null;
    Application application = null;

    public ViewListPanel(Application app) {
        this.application = app;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent arg0) {
        String selectedViewName;
        Object source = arg0.getSource();
        if (source == this.getJbDone()) {
            this.viewWatcherKeepRunning = false;
            if (this.actionListeners != null) {
                Vector vector = this.actionListeners;
                synchronized (vector) {
                    int i = 0;
                    while (i < this.actionListeners.size()) {
                        ActionListener al = (ActionListener)this.actionListeners.get(i);
                        ActionEvent ae = new ActionEvent(this, 0, "done");
                        al.actionPerformed(ae);
                        ++i;
                    }
                }
            }
        } else if (source == this.getJbNew()) {
            Command c = new Command(this, "cmd-show-view-maker-gui", null);
            this.application.postEvent(c);
        } else if (source == this.getJbEdit()) {
            String selectedViewName2 = (String)this.jlViews.getSelectedValue();
            if (selectedViewName2 != null) {
                PilotDBView view = this.db.getView(selectedViewName2);
                Command c = new Command(this, "cmd-show-view-maker-gui", view);
                this.application.postEvent(c);
            }
        } else if (source == this.getJbDelete() && (selectedViewName = (String)this.jlViews.getSelectedValue()) != null) {
            this.db.removeView(selectedViewName);
            this.db.markAsDirty();
        }
    }

    public void setDatabase(PilotDBDatabase db) {
        this.db = db;
        this.listModel = new ViewListModel(db);
        this.getJlViews().setModel(this.listModel);
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.getJspViews(), gbc);
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        this.add((Component)this.getJbNew(), gbc);
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        this.add((Component)this.getJbEdit(), gbc);
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        this.add((Component)this.getJbDelete(), gbc);
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)new Box.Filler(new Dimension(1, 1), new Dimension(1, 1), new Dimension(1000, 1000)), gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.gridy = 5;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 2;
        this.add((Component)this.getJpOkCancel(), gbc);
    }

    public JButton getJbDone() {
        if (this.jbDone == null) {
            this.jbDone = new FlatJButton("Done", Images.OK_ICON);
            this.jbDone.addActionListener(this);
        }
        return this.jbDone;
    }

    public JButton getJbDelete() {
        if (this.jbDelete == null) {
            this.jbDelete = new FlatJButton("Delete", Images.GENERIC_DELETE_ICON);
            this.jbDelete.addActionListener(this);
        }
        return this.jbDelete;
    }

    public JButton getJbEdit() {
        if (this.jbEdit == null) {
            this.jbEdit = new FlatJButton("Edit", Images.EDIT_ICON);
            this.jbEdit.addActionListener(this);
        }
        return this.jbEdit;
    }

    public JButton getJbNew() {
        if (this.jbNew == null) {
            this.jbNew = new FlatJButton("New", Images.ADD_VIEW_ICON);
            this.jbNew.addActionListener(this);
        }
        return this.jbNew;
    }

    public JList getJlViews() {
        if (this.jlViews == null) {
            this.jlViews = new JList();
        }
        return this.jlViews;
    }

    public JPanel getJpOkCancel() {
        if (this.jpOkCancel == null) {
            this.jpOkCancel = new JPanel(new FlowLayout(2));
            this.jpOkCancel.add(this.getJbDone());
            this.jpOkCancel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        }
        return this.jpOkCancel;
    }

    public JScrollPane getJspViews() {
        if (this.jspViews == null) {
            this.jspViews = new JScrollPane(this.getJlViews());
            this.jspViews.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        }
        return this.jspViews;
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    class ViewListModel
    implements ListModel {
        PilotDBDatabase db = null;
        Object selected = null;
        List ldls = new LinkedList();
        int viewCount = 0;

        public ViewListModel(PilotDBDatabase db) {
            this.db = db;
            this.viewCount = db.getViewCount();
            Runnable r = new Runnable(this){
                final /* synthetic */ ViewListModel this$1;
                {
                    this.this$1 = viewListModel;
                }

                public void run() {
                    while (ViewListModel.access$0((ViewListModel)this.this$1).viewWatcherKeepRunning) {
                        this.this$1.getSize();
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    System.out.println("OK, view wather stopping");
                }
            };
            ViewListPanel.this.viewWatchingThread = new Thread(r);
            ViewListPanel.this.viewWatchingThread.setDaemon(true);
            ViewListPanel.this.viewWatchingThread.start();
        }

        public void fireEvent() {
            int i = 0;
            while (i < this.ldls.size()) {
                ListDataListener l = (ListDataListener)this.ldls.get(i);
                l.contentsChanged(new ListDataEvent(this, 0, 0, 0));
                ++i;
            }
        }

        public void addListDataListener(ListDataListener arg0) {
            this.ldls.add(arg0);
        }

        public Object getElementAt(int arg0) {
            int newCount = this.db.getViewCount();
            if (newCount != this.viewCount) {
                this.viewCount = newCount;
                this.fireEvent();
            }
            return this.db.getView(arg0).getName();
        }

        public int getSize() {
            int newCount = this.db.getViewCount();
            if (newCount != this.viewCount) {
                this.viewCount = newCount;
                this.fireEvent();
            }
            return this.db.getViewCount();
        }

        public void removeListDataListener(ListDataListener arg0) {
            this.ldls.remove(arg0);
        }

        static /* synthetic */ ViewListPanel access$0(ViewListModel viewListModel) {
            return viewListModel.ViewListPanel.this;
        }
    }
}

