/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.viewmaker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import pilotdb.ui.images.Images;
import pilotdb.ui.util.FlatJButton;
import pilotdb.ui.util.FlatTableCellRenderer;
import pilotdb.ui.util.UIBanner;
import pilotdb.ui.viewmaker.DBViewMakerModel;
import pilotdb.ui.viewmaker.DBViewMakerTableModel;

public class DBViewMakerPanel
extends JPanel
implements ActionListener {
    public static final int RESPONSE_OK = 0;
    public static final int RESPONSE_CANCEL = 1;
    private transient Vector actionListeners;
    DBViewMakerModel model = new DBViewMakerModel();
    DBViewMakerTableModel tableModel = new DBViewMakerTableModel();
    JScrollPane jsp;
    JTable jtblFieldView;
    JTextField jtfViewName;
    JButton jbOk;
    JButton jbCancel;
    JButton jbMoveUp;
    JButton jbMoveDown;

    public DBViewMakerPanel() {
        this.uiInit();
    }

    public DBViewMakerModel getModel() {
        return this.model;
    }

    public void setModel(DBViewMakerModel model) {
        this.model = model;
        this.tableModel.setModel(model);
        this.jtfViewName.setText(model.getName());
        this.jtblFieldView.setRowSelectionInterval(0, 0);
    }

    private void uiInit() {
        this.jbOk = new FlatJButton("OK", Images.OK_ICON);
        this.jbCancel = new FlatJButton("Cancel", Images.CANCEL_ICON);
        this.jbMoveUp = new FlatJButton("Up", Images.ARROW_UP_ICON);
        this.jbMoveDown = new FlatJButton("Down", Images.ARROW_DOWN_ICON);
        this.jtfViewName = new JTextField(25);
        this.jtfViewName.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.tableModel.setModel(this.model);
        this.jtblFieldView = new JTable(this.tableModel);
        FlatTableCellRenderer ftcr = new FlatTableCellRenderer();
        ftcr.setBackground(Color.black);
        ftcr.setForeground(Color.white);
        ftcr.setHorizontalAlignment(2);
        this.jtblFieldView.getTableHeader().setDefaultRenderer(ftcr);
        this.jsp = new JScrollPane(this.jtblFieldView);
        this.jsp.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setLayout(new BorderLayout(10, 10));
        FlowLayout fl = new FlowLayout(0, 10, 10);
        UIBanner banner = new UIBanner("Create a View", 410, null);
        JPanel tmp = new JPanel(new BorderLayout());
        tmp.add((Component)banner, "North");
        JPanel tmp2 = new JPanel(fl);
        JLabel tmplabel = new JLabel("View Title : ");
        tmp2.add(tmplabel);
        tmp2.add(this.jtfViewName);
        tmp.add((Component)tmp2, "Center");
        this.add((Component)tmp, "North");
        tmp = new JPanel(null);
        tmp.setSize(400, 175);
        tmp.setPreferredSize(new Dimension(400, 175));
        this.jsp.setBounds(10, 10, 250, 150);
        this.jbMoveUp.setBounds(270, 55, 75, 25);
        tmp.add(this.jbMoveUp);
        this.jbMoveDown.setBounds(270, 90, 75, 25);
        tmp.add(this.jbMoveDown);
        tmp.add(this.jsp);
        this.add((Component)tmp, "Center");
        tmp = new JPanel(new FlowLayout(2));
        tmp.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jbOk.setPreferredSize(new Dimension(75, 25));
        this.jbCancel.setPreferredSize(new Dimension(75, 25));
        tmp.add(this.jbOk);
        tmp.add(this.jbCancel);
        this.add((Component)tmp, "South");
        this.jbOk.addActionListener(this);
        this.jbCancel.addActionListener(this);
        this.jbMoveDown.addActionListener(this);
        this.jbMoveUp.addActionListener(this);
        this.jtblFieldView.setRowSelectionInterval(0, 0);
        this.jtblFieldView.setAutoResizeMode(0);
        this.jtblFieldView.setGridColor(new Color(153, 153, 153));
        this.jtblFieldView.setSelectionBackground(SystemColor.textHighlight);
        this.jtblFieldView.setSelectionForeground(SystemColor.textHighlightText);
        if (this.model != null) {
            this.jtfViewName.setText(this.model.getName());
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.jbCancel) {
            this.onCancel(ae);
        } else if (source == this.jbOk) {
            this.onOk(ae);
        } else if (source == this.jbMoveDown) {
            this.onMoveDown(ae);
        } else if (source == this.jbMoveUp) {
            this.onMoveUp(ae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCancel(ActionEvent evt) {
        if (this.actionListeners != null) {
            Vector vector = this.actionListeners;
            synchronized (vector) {
                int i = 0;
                while (i < this.actionListeners.size()) {
                    ActionListener al = (ActionListener)this.actionListeners.get(i);
                    ActionEvent ae = new ActionEvent(this, 1, "cancel");
                    al.actionPerformed(ae);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onOk(ActionEvent evt) {
        this.model.setName(this.jtfViewName.getText());
        if (this.actionListeners != null) {
            Vector vector = this.actionListeners;
            synchronized (vector) {
                int i = 0;
                while (i < this.actionListeners.size()) {
                    ActionListener al = (ActionListener)this.actionListeners.get(i);
                    ActionEvent ae = new ActionEvent(this, 0, "ok");
                    al.actionPerformed(ae);
                    ++i;
                }
            }
        }
    }

    void onMoveDown(ActionEvent evt) {
        int selectedRowIndex = this.jtblFieldView.getSelectedRow();
        if (selectedRowIndex == -1) {
            return;
        }
        this.tableModel.moveDown(selectedRowIndex);
        this.jtblFieldView.setRowSelectionInterval(selectedRowIndex + 1, selectedRowIndex + 1);
    }

    void onMoveUp(ActionEvent evt) {
        int selectedRowIndex = this.jtblFieldView.getSelectedRow();
        if (selectedRowIndex == -1) {
            return;
        }
        this.tableModel.moveUp(selectedRowIndex);
        this.jtblFieldView.setRowSelectionInterval(selectedRowIndex - 1, selectedRowIndex - 1);
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }
}

