/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import pilotdb.ui.util.Style;
import pilotdb.ui.util.StyleSheet;

public class StyleSheetParser {
    final byte STYLE_NAME = 0;
    final byte ATTR_VALUE = 1;
    final byte ATTR_NAME = (byte)2;
    final byte IN_COMMENT = (byte)3;
    int streamPosition = 0;
    char[] char_buffer = new char[2048];
    int bufferPosition = 0;
    StyleSheet css;
    StringBuffer streamContents = new StringBuffer(4096);
    StringBuffer buffer = new StringBuffer();
    protected Style style = this.createStyle();
    String cAttrName;
    String cAttrValue;
    byte comment_state;
    byte state = 0;

    private char peekNext() {
        return this.char_buffer[this.bufferPosition + 1];
    }

    public void parse(InputStream is, StyleSheet css) throws IOException, ParseException {
        this.css = css;
        InputStreamReader reader = new InputStreamReader(is);
        int read = 0;
        while ((read = reader.read(this.char_buffer)) > 0) {
            this.bufferPosition = 0;
            while (this.bufferPosition < read) {
                ++this.streamPosition;
                this.streamContents.append(this.char_buffer[this.bufferPosition]);
                this.handleCharacter(this.char_buffer[this.bufferPosition]);
                ++this.bufferPosition;
            }
        }
        reader.close();
    }

    private void handleCharacter(char c) throws ParseException {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                this.tokenWhiteSpace();
                break;
            }
            case '/': {
                this.tokenForwardSlash();
                break;
            }
            case '*': {
                this.tokenAsterisk();
                break;
            }
            case '{': {
                this.tokenLeftCurly();
                break;
            }
            case '}': {
                this.tokenRightCurly();
                break;
            }
            case ':': {
                this.tokenColon();
                break;
            }
            case ';': {
                this.tokenSemicolon();
                break;
            }
            default: {
                this.tokenChar(c);
            }
        }
    }

    private void tokenWhiteSpace() throws ParseException {
        switch (this.state) {
            case 1: {
                this.buffer.append(' ');
            }
        }
    }

    private void tokenForwardSlash() throws ParseException {
        switch (this.state) {
            case 3: {
                break;
            }
            default: {
                if (this.peekNext() == '*') {
                    ++this.bufferPosition;
                    this.comment_state = this.state;
                    this.state = (byte)3;
                    break;
                }
                this.tokenChar('/');
            }
        }
    }

    private void tokenAsterisk() throws ParseException {
        switch (this.state) {
            case 3: {
                if (this.peekNext() != '/') break;
                ++this.bufferPosition;
                this.state = this.comment_state;
                break;
            }
            default: {
                this.tokenChar('*');
            }
        }
    }

    protected Style createStyle() {
        return new Style();
    }

    private void tokenLeftCurly() throws ParseException {
        switch (this.state) {
            case 3: {
                break;
            }
            case 0: {
                String stylename = this.buffer();
                this.style = this.createStyle();
                this.style.setId(stylename);
                this.state = (byte)2;
                break;
            }
            default: {
                this.buffer.append("{");
            }
        }
    }

    private void tokenRightCurly() throws ParseException {
        switch (this.state) {
            case 3: {
                break;
            }
            case 2: {
                this.css.registerStyle(this.style);
                this.style = new Style();
                this.state = 0;
                break;
            }
            default: {
                this.buffer.append("}");
            }
        }
    }

    private void tokenColon() throws ParseException {
        switch (this.state) {
            case 3: {
                break;
            }
            case 2: {
                this.cAttrName = this.buffer();
                this.state = 1;
                break;
            }
            case 1: {
                this.buffer.append(':');
                break;
            }
            default: {
                throw new ParseException(this.makeUsefulParseMesssage(), this.streamPosition);
            }
        }
    }

    private void tokenSemicolon() throws ParseException {
        switch (this.state) {
            case 3: {
                break;
            }
            case 1: {
                this.cAttrValue = this.buffer();
                this.handleAttribute();
                this.state = (byte)2;
                break;
            }
            default: {
                throw new ParseException(this.makeUsefulParseMesssage(), this.streamPosition);
            }
        }
    }

    private void tokenChar(char c) throws ParseException {
        switch (this.state) {
            case 3: {
                break;
            }
            default: {
                this.buffer.append(c);
            }
        }
    }

    private String buffer() {
        String b = this.buffer.toString();
        b = b.trim();
        this.clearBuffer();
        return b;
    }

    private void clearBuffer() {
        this.buffer.delete(0, this.buffer.length());
    }

    private Style style() {
        return this.style;
    }

    protected void handleAttribute() throws ParseException {
        String aname = this.cAttrName;
        String avalue = this.cAttrValue;
        this.cAttrValue = null;
        this.cAttrName = null;
        this.style.addValue(aname, avalue);
    }

    protected String makeUsefulParseMesssage() {
        return this.makeUsefulParseMesssage(this.streamPosition);
    }

    protected String makeUsefulParseMesssage(int offset) {
        StringBuffer sb = new StringBuffer(this.streamContents.toString());
        String s = sb.toString();
        int idx = 0;
        while ((idx = s.indexOf(10, idx + 1)) != -1) {
            sb.replace(idx, idx + 1, "~");
        }
        while ((idx = s.indexOf(13, idx + 1)) != -1) {
            sb.replace(idx, idx + 1, "~");
        }
        while ((idx = s.indexOf(9, idx + 1)) != -1) {
            sb.replace(idx, idx + 1, "~");
        }
        StringBuffer sb2 = new StringBuffer(sb.length());
        int i = 0;
        while (i < offset - 1) {
            sb2.append(' ');
            ++i;
        }
        sb2.append('^');
        sb.append("\n");
        sb.append(sb2.toString());
        return sb.toString();
    }
}

