/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Style {
    private String id;
    boolean isNullStyle = false;
    Map map = new TreeMap();
    public static final Style NULL = new Style(true);

    public Style(boolean isNull) {
        this.isNullStyle = isNull;
    }

    public Style() {
    }

    public void write(OutputStream os) throws IOException {
        if (this.isNullStyle) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\n" + this.id + " {");
        Iterator iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String val = (String)this.map.get(key);
            sb.append("\n    " + key + ":" + val + ";");
        }
        sb.append("\n}");
        os.write(sb.toString().getBytes());
    }

    public void addValue(String name, int val) {
        if (this.isNullStyle) {
            return;
        }
        this.map.put(name, String.valueOf(val));
    }

    public void addValue(String name, boolean val) {
        if (this.isNullStyle) {
            return;
        }
        this.map.put(name, String.valueOf(val));
    }

    public void addValue(String name, String value) {
        if (this.isNullStyle) {
            return;
        }
        if (value == null) {
            return;
        }
        this.map.put(name, value);
    }

    public String getValue(String name, String def) {
        if (this.isNullStyle) {
            return def;
        }
        if (!this.map.containsKey(name)) {
            return def;
        }
        return (String)this.map.get(name);
    }

    public boolean getValue(String name, boolean def) {
        if (this.isNullStyle) {
            return def;
        }
        String v = (String)this.map.get(name);
        if (v == null) {
            return def;
        }
        return "|Y|YES|T|TRUE|T|F|".indexOf("|" + (v = v.toUpperCase()) + "|") > -1;
    }

    public int getValue(String name, String[] list, int def) {
        if (this.isNullStyle) {
            return def;
        }
        String val = (String)this.map.get(name);
        if (val == null) {
            return def;
        }
        int i = 0;
        while (i < list.length) {
            if (list[i].equals(val)) {
                return i;
            }
            ++i;
        }
        return def;
    }

    public int getValue(String name, int def) {
        if (this.isNullStyle) {
            return def;
        }
        String val = (String)this.map.get(name);
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            return def;
        }
    }

    public String getId() {
        if (this.isNullStyle) {
            return null;
        }
        return this.id;
    }

    public void setId(String newId) {
        if (this.isNullStyle) {
            return;
        }
        this.id = newId;
    }

    public String toString() {
        return String.valueOf(this.id) + "{ }";
    }
}

