/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.tablemaker;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import pilotdb.PilotDBField;
import pilotdb.PilotDBTime;
import pilotdb.ui.tablemaker.PropsEditor;

public class TimePropsPanel
extends JPanel
implements PropsEditor {
    PilotDBField field;
    JRadioButton jrb1 = new JRadioButton("Use Current Time");
    JRadioButton jrb2 = new JRadioButton("None");
    JRadioButton jrb3 = new JRadioButton("(hh:mm - 24 hour)");
    JTextField jtfH = new JTextField();
    JTextField jtfM = new JTextField();
    JLabel jl1 = new JLabel(":");

    public TimePropsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTableField(PilotDBField field) {
        this.field = field;
        if (field.isTimeUseCurrent()) {
            this.jrb1.setSelected(true);
        } else if (field.getTimeDefault() != null) {
            this.jrb3.setSelected(true);
            this.jtfH.setText(String.valueOf(field.getTimeDefault().getHour()));
            this.jtfM.setText(String.valueOf(field.getTimeDefault().getMinute()));
        } else {
            this.jrb2.setSelected(true);
        }
    }

    public void startEditing() {
    }

    public void stopEditing() {
        if (this.field != null) {
            this.field.setTimeUseCurrent(false);
            this.field.setTimeDefault(null);
            if (this.jrb1.isSelected()) {
                this.field.setTimeUseCurrent(true);
            } else if (!this.jrb2.isSelected()) {
                try {
                    int hour = Integer.parseInt(this.jtfH.getText());
                    int minute = Integer.parseInt(this.jtfM.getText());
                    if (hour < 0 || hour > 23 || minute < 0 || minute > 59) {
                        throw new Exception("Invalid time values");
                    }
                    this.field.setTimeDefault(new PilotDBTime(hour, minute));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void cancelEditing() {
        if (this.field != null) {
            this.setTableField(this.field);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.jrb1.setBounds(10, 10, 130, 20);
        this.jrb2.setBounds(10, 30, 130, 20);
        this.jrb3.setBounds(10, 50, 130, 20);
        int x = 10;
        this.jtfH.setBounds(x, 70, 45, 25);
        this.jl1.setBounds((x += 30) + 5, 70, 10, 25);
        this.jtfM.setBounds(x += 10, 70, 30, 25);
        x += 30;
        this.jtfH.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtfM.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.add((Component)this.jrb1, null);
        this.add((Component)this.jrb2, null);
        this.add((Component)this.jrb3, null);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrb1);
        buttonGroup.add(this.jrb2);
        buttonGroup.add(this.jrb3);
        this.add((Component)this.jtfH, null);
        this.add((Component)this.jtfM, null);
        this.add((Component)this.jl1, null);
        this.jrb1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                switch (ie.getStateChange()) {
                    case 1: {
                        TimePropsPanel.this.onCurrent(true);
                        break;
                    }
                    case 2: {
                        TimePropsPanel.this.onCurrent(false);
                    }
                }
            }
        });
        this.jrb2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                switch (ie.getStateChange()) {
                    case 1: {
                        TimePropsPanel.this.onNone(true);
                        break;
                    }
                    case 2: {
                        TimePropsPanel.this.onNone(false);
                    }
                }
            }
        });
        this.jrb3.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                switch (ie.getStateChange()) {
                    case 1: {
                        TimePropsPanel.this.onCustom(true);
                        break;
                    }
                    case 2: {
                        TimePropsPanel.this.onCustom(false);
                    }
                }
            }
        });
        this.jrb2.setSelected(true);
    }

    void onCurrent(boolean selected) {
        if (selected) {
            this.jtfH.setEnabled(false);
            this.jtfM.setEnabled(false);
        }
    }

    void onNone(boolean selected) {
        if (selected) {
            this.jtfH.setEnabled(false);
            this.jtfM.setEnabled(false);
        }
    }

    void onCustom(boolean selected) {
        if (selected) {
            this.jtfH.setEnabled(true);
            this.jtfM.setEnabled(true);
        }
    }

    public String getInvalidReason() {
        return null;
    }

    public boolean validateData() {
        return true;
    }
}

