/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.tablemaker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import pilotdb.PilotDBField;
import pilotdb.calc.EvaluationContext;
import pilotdb.calc.InvalidCodeException;
import pilotdb.calc.LispCodeExpressionParser;
import pilotdb.ui.tablemaker.PropsEditor;

public class ScriptPropsPanel
extends JPanel
implements PropsEditor {
    PilotDBField field;
    JLabel jLabel1;
    JTextArea jta;
    String error = null;

    public ScriptPropsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTableField(PilotDBField field) {
        this.field = field;
        this.validateData();
    }

    public void startEditing() {
        EvaluationContext ctx = new EvaluationContext();
        ctx.setSchema(this.field.getSchema());
        StringBuffer sb = new StringBuffer();
        if (this.field.getScript() != null) {
            this.field.getScript().toScript(ctx, sb);
        }
        this.jta.setText(sb.toString());
        this.validateData();
    }

    public void stopEditing() {
        if (this.field != null) {
            String script = this.jta.getText();
            try {
                this.field.setScript(script);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void cancelEditing() {
        if (this.field != null) {
            EvaluationContext ctx = new EvaluationContext();
            ctx.setSchema(this.field.getSchema());
            StringBuffer sb = new StringBuffer();
            this.field.getScript().toScript(ctx, sb);
            this.jta.setText(sb.toString());
        }
    }

    private void jbInit() throws Exception {
        this.jLabel1 = new JLabel();
        this.jta = new JTextArea();
        this.jta.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setLayout(null);
        this.jLabel1.setText("Script ");
        this.jLabel1.setBounds(new Rectangle(10, 13, 130, 17));
        this.jta.setBounds(new Rectangle(10, 40, 130, 70));
        this.jta.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.jta, null);
    }

    public String getInvalidReason() {
        return null;
    }

    public boolean validateData() {
        String scriptText = this.jta.getText();
        try {
            LispCodeExpressionParser parser = new LispCodeExpressionParser();
            parser.parse(null, scriptText);
            this.field.setValid(true);
            this.jta.setForeground(Color.black);
            return true;
        }
        catch (InvalidCodeException ice) {
            this.error = ice.getMessage();
            this.field.setValid(false);
            this.jta.setForeground(Color.red);
            return false;
        }
    }
}

