/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.tablemaker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBField;
import pilotdb.ui.Application;
import pilotdb.ui.images.Images;
import pilotdb.ui.tablemaker.DatePropsPanel;
import pilotdb.ui.tablemaker.FloatPropsPanel;
import pilotdb.ui.tablemaker.IntPropsPanel;
import pilotdb.ui.tablemaker.LinkPropsPanel;
import pilotdb.ui.tablemaker.LinkedPropsPanel;
import pilotdb.ui.tablemaker.ListPropsPanel;
import pilotdb.ui.tablemaker.PropsEditor;
import pilotdb.ui.tablemaker.SchemaEditModel;
import pilotdb.ui.tablemaker.SchemaTableModel;
import pilotdb.ui.tablemaker.ScriptPropsPanel;
import pilotdb.ui.tablemaker.StringPropsPanel;
import pilotdb.ui.tablemaker.TimePropsPanel;
import pilotdb.ui.util.FlatJButton;
import pilotdb.ui.util.FlatTableCellRenderer;
import pilotdb.ui.util.UIBanner;

public class SchemaEditorPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final int RESPONSE_OK = 0;
    public static final int RESPONSE_CANCEL = 1;
    private transient Vector actionListeners;
    SchemaEditModel model = new SchemaEditModel();
    SchemaTableModel _tableModel;
    private JTextPane _jtp;
    private JScrollPane _jspJtp;
    private JPanel _jpButtons;
    private JPanel _jpDbName;
    private JLabel _jlDbName;
    private JPanel _jpMoveButtons;
    private JPanel _jpCenter;
    PropsEditor editor;
    JScrollPane _jspFieldList;
    JPanel _jpFieldProperties;
    JTable _jtblFieldView;
    JTextField _jtfDbName;
    JButton _jbOk;
    JButton _jbCancel;
    JButton _jbMoveUp;
    JButton _jbMoveDown;
    JButton _jbAddRowBefore;
    JButton _jbAddRowAfter;
    JButton _jbDeleteRow;
    Application bridge = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SchemaTableModel getTableModel() {
        if (this._tableModel == null) {
            this._tableModel = new SchemaTableModel();
            this._tableModel.setModel(this.model);
        }
        return this._tableModel;
    }

    private JScrollPane getErrorScrollPane() {
        if (this._jspJtp == null) {
            this._jspJtp = new JScrollPane(this.getErrorTextPane());
            this._jspJtp.setPreferredSize(new Dimension(600, 50));
            this._jspJtp.setBorder(null);
        }
        return this._jspJtp;
    }

    private JTextPane getErrorTextPane() {
        if (this._jtp == null) {
            this._jtp = new JTextPane();
            this._jtp.setBackground(SystemColor.control);
            this._jtp.setOpaque(true);
            this._jtp.setEditable(false);
            this._jtp.setFocusable(false);
        }
        return this._jtp;
    }

    public SchemaEditorPanel(Application bridge, PilotDBDatabase db) {
        this.bridge = bridge;
        this.model = new SchemaEditModel(db);
        this.uiInit();
        this.initListeners();
    }

    public SchemaEditorPanel(Application bridge) {
        this.bridge = bridge;
        this.uiInit();
        this.initListeners();
        this.model.createDefaultField();
        this.model.createDefaultField();
        this.model.createDefaultField();
        this.getDatabaseNameField().setText("New Database");
    }

    public SchemaEditModel getModel() {
        return this.model;
    }

    public void clear() {
        this.setModel(new SchemaEditModel());
    }

    public void setModel(SchemaEditModel model) {
        this.model = model;
        this.getTableModel().setModel(model);
        this.getDatabaseNameField().setText(model.getName());
        if (model.getFieldCount() > 0) {
            this.getJtblFieldView().setRowSelectionInterval(0, 0);
        }
        this.checkValidity();
    }

    private JButton getJbOk() {
        if (this._jbOk == null) {
            this._jbOk = new FlatJButton();
            this._jbOk.setIcon(Images.OK_ICON);
            this._jbOk.setText("ok");
            this._jbOk.setPreferredSize(new Dimension(75, 25));
        }
        return this._jbOk;
    }

    private JButton getJbCancel() {
        if (this._jbCancel == null) {
            this._jbCancel = new FlatJButton();
            this._jbCancel.setIcon(Images.CANCEL_ICON);
            this._jbCancel.setText("cancel");
            this._jbCancel.setPreferredSize(new Dimension(75, 25));
        }
        return this._jbCancel;
    }

    private JLabel getDatabaseNameLabel() {
        if (this._jlDbName == null) {
            this._jlDbName = new JLabel("Database Name : ");
        }
        return this._jlDbName;
    }

    private JTextField getDatabaseNameField() {
        if (this._jtfDbName == null) {
            this._jtfDbName = new JTextField("                       ");
            this._jtfDbName.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            this._jtfDbName.setText(null);
            if (this.model != null) {
                this._jtfDbName.setText(this.model.getName());
            }
        }
        return this._jtfDbName;
    }

    private JPanel getDatabaseNamePanel() {
        if (this._jpDbName == null) {
            GridBagLayout gbl = new GridBagLayout();
            this._jpDbName = new JPanel(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.anchor = 17;
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            this._jpDbName.add((Component)this.getDatabaseNameLabel(), gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.anchor = 17;
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.fill = 2;
            gbc.weightx = 50.0;
            gbc.weighty = 0.0;
            this._jpDbName.add((Component)this.getDatabaseNameField(), gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.anchor = 13;
            gbc.gridx = 3;
            gbc.gridy = 1;
            gbc.weightx = 100.0;
            gbc.weighty = 0.0;
            this._jpDbName.add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(10, 10), new Dimension(640, 480)), gbc);
            this._jpDbName.setPreferredSize(new Dimension(640, 30));
            this._jpDbName.setOpaque(true);
        }
        return this._jpDbName;
    }

    private JPanel getButtonPanel() {
        if (this._jpButtons == null) {
            this._jpButtons = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            this._jpButtons.setLayout(gbl);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.anchor = 17;
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 1;
            gbc.weightx = 90.0;
            gbc.weighty = 100.0;
            JLabel f = new JLabel();
            f.setOpaque(true);
            this._jpButtons.add((Component)f, gbc);
            gbc.weightx = 5.0;
            gbc.gridx = 2;
            this._jpButtons.add((Component)this.getJbOk(), gbc);
            gbc.gridx = 3;
            this._jpButtons.add((Component)this.getJbCancel(), gbc);
        }
        return this._jpButtons;
    }

    private JButton getJbMoveUp() {
        if (this._jbMoveUp == null) {
            this._jbMoveUp = new FlatJButton();
            this._jbMoveUp.setIcon(Images.ARROW_UP_ICON);
            this._jbMoveUp.setText("move up");
            this._jbMoveUp.setHorizontalAlignment(2);
        }
        return this._jbMoveUp;
    }

    private JButton getJbMoveDown() {
        if (this._jbMoveDown == null) {
            this._jbMoveDown = new FlatJButton();
            this._jbMoveDown.setIcon(Images.ARROW_DOWN_ICON);
            this._jbMoveDown.setText("move down");
            this._jbMoveDown.setHorizontalAlignment(2);
        }
        return this._jbMoveDown;
    }

    private JButton getJbAddRowBefore() {
        if (this._jbAddRowBefore == null) {
            this._jbAddRowBefore = new FlatJButton();
            this._jbAddRowBefore.setIcon(Images.GENERIC_ADD_ICON);
            this._jbAddRowBefore.setText("add before");
            this._jbAddRowBefore.setHorizontalAlignment(2);
        }
        return this._jbAddRowBefore;
    }

    private JButton getJbAddRowAfter() {
        if (this._jbAddRowAfter == null) {
            this._jbAddRowAfter = new FlatJButton();
            this._jbAddRowAfter.setIcon(Images.GENERIC_ADD_ICON);
            this._jbAddRowAfter.setText("add after");
            this._jbAddRowAfter.setHorizontalAlignment(2);
        }
        return this._jbAddRowAfter;
    }

    private JButton getJbDeleteRow() {
        if (this._jbDeleteRow == null) {
            this._jbDeleteRow = new FlatJButton();
            this._jbDeleteRow.setIcon(Images.GENERIC_DELETE_ICON);
            this._jbDeleteRow.setText("remove field");
            this._jbDeleteRow.setHorizontalAlignment(2);
        }
        return this._jbDeleteRow;
    }

    private JPanel getMoveButtonsPanel() {
        if (this._jpMoveButtons == null) {
            this._jpMoveButtons = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 2;
            gbc.anchor = 11;
            this._jpMoveButtons.add((Component)this.getJbMoveUp(), gbc);
            gbc.gridy = 2;
            this._jpMoveButtons.add((Component)this.getJbMoveDown(), gbc);
            gbc.gridy = 3;
            this._jpMoveButtons.add((Component)this.getJbAddRowBefore(), gbc);
            gbc.gridy = 4;
            this._jpMoveButtons.add((Component)this.getJbAddRowAfter(), gbc);
            gbc.gridy = 5;
            this._jpMoveButtons.add((Component)this.getJbDeleteRow(), gbc);
        }
        return this._jpMoveButtons;
    }

    private JPanel getCenterPanel() {
        if (this._jpCenter == null) {
            this._jpCenter = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            this._jpCenter.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.anchor = 17;
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 1;
            gbc.weightx = 50.0;
            gbc.weighty = 100.0;
            this._jpCenter.add((Component)this.getJspFieldList(), gbc);
            gbc.weightx = 0.0;
            gbc.gridx = 2;
            this._jpCenter.add((Component)this.getMoveButtonsPanel(), gbc);
            gbc.weightx = 50.0;
            gbc.gridx = 3;
            this._jpCenter.add((Component)this.getFieldPropertiesPanel(), gbc);
        }
        return this._jpCenter;
    }

    private JPanel getFieldPropertiesPanel() {
        if (this._jpFieldProperties == null) {
            this._jpFieldProperties = new JPanel(new BorderLayout(10, 10));
            this._jpFieldProperties.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        }
        return this._jpFieldProperties;
    }

    private JTable getJtblFieldView() {
        if (this._jtblFieldView == null) {
            this._jtblFieldView = new JTable(this.getTableModel());
            FlatTableCellRenderer ftcr = new FlatTableCellRenderer();
            ftcr.setBackground(SystemColor.activeCaption);
            ftcr.setForeground(SystemColor.activeCaptionText);
            ftcr.setHorizontalAlignment(2);
            this._jtblFieldView.getTableHeader().setDefaultRenderer(ftcr);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this._jtblFieldView.getDefaultEditor(clazz).addCellEditorListener(new CellEditorListener(){

                public void editingCanceled(ChangeEvent ce) {
                }

                public void editingStopped(ChangeEvent ce) {
                    SchemaEditorPanel.this.tableRowChanged();
                }
            });
            JComboBox<String> jcb = new JComboBox<String>(PilotDBField.FIELD_TYPE_NAMES);
            jcb.setAlignmentX(2.0f);
            jcb.setBorder(null);
            DefaultCellEditor cellEditor = new DefaultCellEditor(jcb);
            cellEditor.addCellEditorListener(new CellEditorListener(){

                public void editingCanceled(ChangeEvent ce) {
                }

                public void editingStopped(ChangeEvent ce) {
                    SchemaEditorPanel.this.tableRowChanged();
                }
            });
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this._jtblFieldView.setDefaultEditor(clazz2, cellEditor);
            this._jtblFieldView.setSelectionMode(0);
            this._jtblFieldView.getSelectionModel().addListSelectionListener(this);
        }
        return this._jtblFieldView;
    }

    private JScrollPane getJspFieldList() {
        if (this._jspFieldList == null) {
            this._jspFieldList = new JScrollPane(this.getJtblFieldView());
            this._jspFieldList.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        }
        return this._jspFieldList;
    }

    private void uiInit() {
        JPanel jpFields = new JPanel();
        jpFields.setLayout(new BorderLayout());
        jpFields.add((Component)this.getDatabaseNamePanel(), "North");
        jpFields.add((Component)this.getCenterPanel(), "Center");
        jpFields.add((Component)this.getErrorScrollPane(), "South");
        UIBanner banner = new UIBanner("Create a new Database", 550, null);
        this.setLayout(new BorderLayout());
        this.add((Component)banner, "North");
        this.add((Component)jpFields, "Center");
        this.add((Component)this.getButtonPanel(), "South");
        this.setPreferredSize(new Dimension(640, 480));
    }

    private void initListeners() {
        this.getJbOk().addActionListener(this);
        this.getJbCancel().addActionListener(this);
        this.getJbMoveDown().addActionListener(this);
        this.getJbAddRowBefore().addActionListener(this);
        this.getJbAddRowAfter().addActionListener(this);
        this.getJbDeleteRow().addActionListener(this);
        this.getJbMoveUp().addActionListener(this);
        this.getDatabaseNameField().getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent arg0) {
                SchemaEditorPanel.this.updateDbName();
                SchemaEditorPanel.this.checkValidity();
            }

            public void removeUpdate(DocumentEvent arg0) {
                SchemaEditorPanel.this.updateDbName();
                SchemaEditorPanel.this.checkValidity();
            }

            public void changedUpdate(DocumentEvent arg0) {
                SchemaEditorPanel.this.updateDbName();
                SchemaEditorPanel.this.checkValidity();
            }
        });
    }

    private void updateDbName() {
        this.model.setName(this.getDatabaseNameField().getText());
    }

    public void checkValidity() {
        this.getErrorTextPane().setText("");
        this.getJbOk().setEnabled(this.model.isValidSchema());
        String[] s = this.model.getValidationErrors();
        SimpleAttributeSet redtext = new SimpleAttributeSet();
        StyleConstants.setBold(redtext, true);
        StyleConstants.setForeground(redtext, Color.red);
        StyleConstants.setFontSize(redtext, 10);
        int i = 0;
        while (i < s.length) {
            try {
                this.getErrorTextPane().getDocument().insertString(0, s[i].concat("\n"), redtext);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object source;
        if (this.editor != null) {
            this.editor.stopEditing();
            this.editor.validateData();
        }
        if ((source = ae.getSource()) == this.getJbCancel()) {
            this.onCancel(ae);
        } else if (source == this.getJbOk()) {
            this.onOk(ae);
        } else if (source == this.getJbMoveDown()) {
            this.onMoveDown(ae);
        } else if (source == this.getJbMoveUp()) {
            this.onMoveUp(ae);
        } else if (source == this.getJbAddRowAfter()) {
            this.onAddRow(ae, 1);
        } else if (source == this.getJbAddRowBefore()) {
            this.onAddRow(ae, 0);
        } else if (source == this.getJbDeleteRow()) {
            this.onDeleteRow(ae);
        }
        this.checkValidity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCancel(ActionEvent evt) {
        if (this.actionListeners != null) {
            Vector vector = this.actionListeners;
            synchronized (vector) {
                int i = 0;
                while (i < this.actionListeners.size()) {
                    ActionListener al = (ActionListener)this.actionListeners.get(i);
                    ActionEvent ae = new ActionEvent(this, 1, "cancel");
                    al.actionPerformed(ae);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onOk(ActionEvent evt) {
        this.model.setName(this.getDatabaseNameField().getText());
        if (this.actionListeners != null) {
            Vector vector = this.actionListeners;
            synchronized (vector) {
                int i = 0;
                while (i < this.actionListeners.size()) {
                    ActionListener al = (ActionListener)this.actionListeners.get(i);
                    ActionEvent ae = new ActionEvent(this, 0, "ok");
                    al.actionPerformed(ae);
                    ++i;
                }
            }
        }
    }

    void onDeleteRow(ActionEvent ae) {
        int row = this.getJtblFieldView().getSelectedRow();
        if (row > -1) {
            this.getTableModel().deleteRow(row);
        }
    }

    void onAddRow(ActionEvent ae, int relPos) {
        int selected = this.getJtblFieldView().getSelectedRow();
        if (selected == -1) {
            selected = 0;
        }
        int row = selected + relPos;
        if (this.getTableModel().getRowCount() == 0) {
            row = 0;
        } else if (row < 0) {
            row = 0;
        }
        row = this.getTableModel().createDefaultRow(row);
        this.getJtblFieldView().setRowSelectionInterval(row, row);
    }

    void onMoveDown(ActionEvent evt) {
        int selectedRowIndex = this.getJtblFieldView().getSelectedRow();
        if (selectedRowIndex == -1) {
            return;
        }
        this.getTableModel().moveDown(selectedRowIndex);
        this.getJtblFieldView().setRowSelectionInterval(selectedRowIndex + 1, selectedRowIndex + 1);
    }

    void onMoveUp(ActionEvent evt) {
        int selectedRowIndex = this.getJtblFieldView().getSelectedRow();
        if (selectedRowIndex == -1) {
            return;
        }
        this.getTableModel().moveUp(selectedRowIndex);
        this.getJtblFieldView().setRowSelectionInterval(selectedRowIndex - 1, selectedRowIndex - 1);
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.tableRowChanged();
        }
    }

    void tableRowChanged() {
        if (this.editor != null) {
            this.editor.validateData();
            this.editor.stopEditing();
        }
        this.getFieldPropertiesPanel().setVisible(false);
        this.getFieldPropertiesPanel().removeAll();
        int newIndex = this.getJtblFieldView().getSelectedRow();
        if (newIndex > -1) {
            PilotDBField field = this.getTableModel().getModel().getTableField(newIndex);
            switch (field.getType()) {
                case 0: {
                    this.editor = new StringPropsPanel();
                    break;
                }
                case 2: {
                    this.editor = new IntPropsPanel();
                    break;
                }
                case 8: {
                    this.editor = new FloatPropsPanel();
                    break;
                }
                case 3: {
                    this.editor = new DatePropsPanel();
                    break;
                }
                case 4: {
                    this.editor = new TimePropsPanel();
                    break;
                }
                case 6: {
                    this.editor = new ListPropsPanel();
                    break;
                }
                case 7: {
                    try {
                        this.editor = new LinkPropsPanel(this.bridge.getCurrentEnvironment());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "Unable to load databases");
                        e.printStackTrace();
                    }
                    break;
                }
                case 10: {
                    try {
                        this.editor = new LinkedPropsPanel(this.bridge.getCurrentEnvironment());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "Unable to load databases");
                        e.printStackTrace();
                    }
                    break;
                }
                case 9: {
                    this.editor = new ScriptPropsPanel();
                    break;
                }
                default: {
                    this.editor = null;
                }
            }
            if (this.editor != null) {
                this.editor.setTableField(field);
                this.editor.startEditing();
                this.getFieldPropertiesPanel().add((Component)((JComponent)((Object)this.editor)), "Center");
            }
            this.getFieldPropertiesPanel().setVisible(true);
        }
        this.checkValidity();
    }
}

