/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.tablemaker;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import pilotdb.PilotDBField;
import pilotdb.ui.images.Images;
import pilotdb.ui.tablemaker.PropsEditor;
import pilotdb.ui.util.FlatJButton;

public class ListPropsPanel
extends JPanel
implements PropsEditor,
ActionListener {
    PilotDBField field;
    JLabel jl1 = new JLabel("Options");
    DefaultListModel dlm = new DefaultListModel();
    JList jlist = new JList(this.dlm);
    JScrollPane jsp = new JScrollPane(this.jlist);
    JButton jbAdd = new FlatJButton(Images.GENERIC_ADD_ICON);
    JButton jbRemove = new FlatJButton(Images.GENERIC_DELETE_ICON);
    JButton jbUp = new FlatJButton(Images.ARROW_UP_ICON);
    JButton jbDown = new FlatJButton(Images.ARROW_DOWN_ICON);
    JTextField jtf1 = new JTextField();

    public ListPropsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.jbUp) {
            this.onUp();
        } else if (source == this.jbDown) {
            this.onDown();
        } else if (source == this.jbAdd) {
            this.onAdd();
        } else if (source == this.jbRemove) {
            this.onRemove();
        }
    }

    private void onDown() {
        int fromIdx = this.jlist.getSelectedIndex();
        if (fromIdx == -1) {
            return;
        }
        if (fromIdx == this.dlm.getSize() - 1) {
            return;
        }
        int toIdx = fromIdx + 1;
        Object obj = this.dlm.remove(fromIdx);
        this.dlm.add(toIdx, obj);
        this.jlist.setSelectedIndex(toIdx);
    }

    private void onUp() {
        int fromIdx = this.jlist.getSelectedIndex();
        if (fromIdx == 0) {
            return;
        }
        if (fromIdx == -1) {
            return;
        }
        int toIdx = fromIdx - 1;
        Object obj = this.dlm.remove(fromIdx);
        this.dlm.add(toIdx, obj);
        this.jlist.setSelectedIndex(toIdx);
    }

    private void onAdd() {
        String s = this.jtf1.getText();
        if ((s = s.trim()).length() > 0) {
            this.dlm.addElement(s);
        }
        this.jtf1.setText("");
    }

    private void onRemove() {
        int listSize;
        int newIndex;
        System.out.println("remove");
        int index = this.jlist.getSelectedIndex();
        if (index != -1) {
            this.dlm.remove(index);
        }
        if ((newIndex = index) == (listSize = this.dlm.getSize())) {
            newIndex = listSize - 1;
        } else if (listSize == 0) {
            newIndex = -1;
        }
        this.jlist.setSelectedIndex(newIndex);
    }

    public void setTableField(PilotDBField field) {
        this.field = field;
        int c = field.getListChoices().size();
        int i = 0;
        while (i < c) {
            this.dlm.add(i, field.getListChoices().get(i));
            ++i;
        }
    }

    public void startEditing() {
    }

    public void stopEditing() {
        if (this.field != null) {
            int i = 0;
            int size = this.dlm.getSize();
            LinkedList al = new LinkedList();
            while (i < size) {
                al.add(i, this.dlm.get(i));
                ++i;
            }
            this.field.getListChoices().clear();
            this.field.getListChoices().addAll(al);
        }
    }

    public void cancelEditing() {
        if (this.field != null) {
            this.setTableField(this.field);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.jl1.setBounds(10, 5, 130, 20);
        this.jsp.setBounds(10, 20, 100, 60);
        this.jbAdd.setBounds(10, 85, 20, 20);
        this.jbRemove.setBounds(90, 85, 20, 20);
        this.jbUp.setBounds(120, 30, 20, 20);
        this.jbDown.setBounds(120, 50, 20, 20);
        this.jtf1.setBounds(10, 110, 130, 20);
        this.jtf1.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.add(this.jl1);
        this.add(this.jsp);
        this.add(this.jbAdd);
        this.add(this.jbRemove);
        this.add(this.jbUp);
        this.add(this.jbDown);
        this.add(this.jtf1);
        this.jbAdd.addActionListener(this);
        this.jbDown.addActionListener(this);
        this.jbUp.addActionListener(this);
        this.jbRemove.addActionListener(this);
    }

    public String getInvalidReason() {
        return null;
    }

    public boolean validateData() {
        return true;
    }
}

