/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.tablemaker;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBField;
import pilotdb.ui.tablemaker.PropsEditor;

public class DatePropsPanel
extends JPanel
implements PropsEditor {
    PilotDBField field;
    JRadioButton jrb1 = new JRadioButton("Use Current Date");
    JRadioButton jrb2 = new JRadioButton("None");
    JRadioButton jrb3 = new JRadioButton("(yyyy/mm/dd)");
    JTextField jtfY = new JTextField();
    JTextField jtfM = new JTextField();
    JTextField jtfD = new JTextField();
    JLabel jl1 = new JLabel("/");
    JLabel jl2 = new JLabel("/");

    public DatePropsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTableField(PilotDBField field) {
        this.field = field;
        if (field.isDateUseCurrent()) {
            this.jrb1.setSelected(true);
        } else if (field.getDateDefault() != null) {
            this.jrb3.setSelected(true);
            this.jtfY.setText(String.valueOf(field.getDateDefault().getYear()));
            this.jtfM.setText(String.valueOf(field.getDateDefault().getMonth()));
            this.jtfD.setText(String.valueOf(field.getDateDefault().getDate()));
        } else {
            this.jrb2.setSelected(true);
        }
    }

    public void startEditing() {
    }

    public void stopEditing() {
        if (this.field != null) {
            this.field.setDateUseCurrent(false);
            this.field.setDateDefault(null);
            if (this.jrb1.isSelected()) {
                this.field.setDateUseCurrent(true);
            } else if (!this.jrb2.isSelected()) {
                try {
                    int year = Integer.parseInt(this.jtfY.getText());
                    int month = Integer.parseInt(this.jtfM.getText());
                    int date = Integer.parseInt(this.jtfD.getText());
                    if (date < 1 || date > 31 || month < 1 || month > 12 || year < 0 || year > 9999) {
                        throw new Exception("Invalid date values");
                    }
                    this.field.setDateDefault(new PilotDBDate(year, month, date));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void cancelEditing() {
        if (this.field != null) {
            this.setTableField(this.field);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.jrb1.setBounds(10, 10, 130, 20);
        this.jrb2.setBounds(10, 30, 130, 20);
        this.jrb3.setBounds(10, 50, 130, 20);
        int x = 10;
        this.jtfY.setBounds(x, 70, 45, 25);
        this.jtfY.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jl1.setBounds((x += 45) + 5, 70, 10, 25);
        this.jtfM.setBounds(x += 10, 70, 30, 25);
        this.jtfM.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jl2.setBounds((x += 30) + 5, 70, 10, 25);
        this.jtfD.setBounds(x += 10, 70, 30, 25);
        this.jtfD.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.add((Component)this.jrb1, null);
        this.add((Component)this.jrb2, null);
        this.add((Component)this.jrb3, null);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrb1);
        buttonGroup.add(this.jrb2);
        buttonGroup.add(this.jrb3);
        this.add((Component)this.jtfY, null);
        this.add((Component)this.jtfM, null);
        this.add((Component)this.jtfD, null);
        this.add((Component)this.jl1, null);
        this.add((Component)this.jl2, null);
        this.jrb1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                switch (ie.getStateChange()) {
                    case 1: {
                        DatePropsPanel.this.onCurrent(true);
                        break;
                    }
                    case 2: {
                        DatePropsPanel.this.onCurrent(false);
                    }
                }
            }
        });
        this.jrb2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                switch (ie.getStateChange()) {
                    case 1: {
                        DatePropsPanel.this.onNone(true);
                        break;
                    }
                    case 2: {
                        DatePropsPanel.this.onNone(false);
                    }
                }
            }
        });
        this.jrb3.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                switch (ie.getStateChange()) {
                    case 1: {
                        DatePropsPanel.this.onCustom(true);
                        break;
                    }
                    case 2: {
                        DatePropsPanel.this.onCustom(false);
                    }
                }
            }
        });
        this.jrb2.setSelected(true);
    }

    void onCurrent(boolean selected) {
        if (selected) {
            this.jtfY.setEnabled(false);
            this.jtfM.setEnabled(false);
            this.jtfD.setEnabled(false);
        }
    }

    void onNone(boolean selected) {
        if (selected) {
            this.jtfY.setEnabled(false);
            this.jtfM.setEnabled(false);
            this.jtfD.setEnabled(false);
        }
    }

    void onCustom(boolean selected) {
        if (selected) {
            this.jtfY.setEnabled(true);
            this.jtfM.setEnabled(true);
            this.jtfD.setEnabled(true);
        }
    }

    public String getInvalidReason() {
        return null;
    }

    public boolean validateData() {
        return true;
    }
}

