/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.sortdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import pilotdb.PilotDBDatabase;
import pilotdb.ui.Application;
import pilotdb.ui.images.Images;
import pilotdb.ui.sortdialog.SortPanel;
import pilotdb.ui.util.FlatJButton;

public class SortDialog
extends JDialog
implements ActionListener {
    JButton jbOk;
    JButton jbCancel;
    SortPanel ppanel;
    PilotDBDatabase database = null;

    public SortDialog(Application app) {
        super(app.getMainWindow(), "user preferences", true);
        this.setDefaultCloseOperation(2);
        this.ppanel = new SortPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.ppanel, "Center");
        this.pack();
        this.jbOk = new FlatJButton("ok", Images.OK_ICON);
        this.jbCancel = new FlatJButton("cancel", Images.CANCEL_ICON);
        this.jbOk.setPreferredSize(new Dimension(60, 30));
        this.jbCancel.setPreferredSize(new Dimension(60, 30));
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout(2));
        jp.add(this.jbOk);
        jp.add(this.jbCancel);
        this.jbOk.addActionListener(this);
        this.jbCancel.addActionListener(this);
        this.getContentPane().add((Component)jp, "South");
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        this.setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
    }

    public void setDatabase(PilotDBDatabase db) {
        this.database = db;
        this.ppanel.setDatabase(db);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.jbOk) {
            int findex = this.ppanel.getFieldIndex();
            boolean asc = this.ppanel.isAscending();
            this.database.sort(findex, !asc);
        }
        this.setVisible(false);
        this.dispose();
    }
}

