/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBTime;
import pilotdb.ui.Application;
import pilotdb.ui.Messages;
import pilotdb.ui.recordsetview.EditorComponent;
import pilotdb.ui.util.UnderlineLabel;

public class TimeEditor
extends JPanel
implements EditorComponent {
    JTextField jtfHour = new JTextField();
    JTextField jtfMinute = new JTextField();
    UnderlineLabel jlTime = new UnderlineLabel();

    public TimeEditor() {
        this.jtfHour.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtfMinute.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setLayout(null);
        this.jlTime.setHorizontalAlignment(2);
        this.jtfHour.setBounds(0, 0, 40, 20);
        this.jtfMinute.setBounds(45, 0, 40, 20);
        this.jlTime.setBounds(0, 0, 85, 20);
        this.jlTime.setDrawLineFullWidth(true);
        this.add(this.jtfHour);
        this.add(this.jtfMinute);
        this.add(this.jlTime);
        this.setPreferredSize(new Dimension(150, 25));
    }

    public Component getEditorComponent() {
        return this.jtfHour;
    }

    public boolean isValid() {
        try {
            String hour = this.jtfHour.getText();
            String minute = this.jtfMinute.getText();
            new PilotDBTime(String.valueOf(hour) + ":" + minute);
            this.jtfHour.setForeground(Color.black);
            this.jtfMinute.setForeground(Color.black);
            return true;
        }
        catch (Exception e) {
            this.jtfHour.setForeground(Color.red);
            this.jtfMinute.setForeground(Color.red);
            return false;
        }
    }

    public String getInvalidReason() {
        return String.valueOf(Messages.getString("TimeEditor.InvalidTimeValue")) + this.getName();
    }

    public void display(PilotDBRecord record, int fieldIndex) throws Exception {
        PilotDBTime theTime = record.getTime(fieldIndex);
        if (theTime == null) {
            return;
        }
        this.jlTime.setText(theTime.toString());
        this.jtfHour.setVisible(false);
        this.jtfMinute.setVisible(false);
        this.jlTime.setVisible(true);
    }

    public void stopEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.jtfHour.setEnabled(false);
        this.jtfMinute.setEnabled(false);
        String hour = this.jtfHour.getText();
        String minute = this.jtfMinute.getText();
        PilotDBTime newTime = new PilotDBTime(String.valueOf(hour) + ":" + minute);
        record.setTime(fieldIndex, newTime);
    }

    public void startEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.jlTime.setVisible(false);
        this.jtfHour.setEnabled(true);
        this.jtfMinute.setEnabled(true);
        this.jtfHour.setVisible(true);
        this.jtfMinute.setVisible(true);
        PilotDBTime theTime = record.getTime(fieldIndex);
        if (theTime == null) {
            return;
        }
        this.jtfHour.setText(String.valueOf(theTime.getHour()));
        this.jtfMinute.setText(String.valueOf(theTime.getMinute()));
    }

    public void cancelEditing(PilotDBRecord record, int fieldIndex) {
        this.jtfHour.setEnabled(false);
        this.jtfMinute.setEnabled(false);
        try {
            PilotDBTime theTime = record.getTime(fieldIndex);
            if (theTime == null) {
                return;
            }
            this.jtfHour.setText(String.valueOf(theTime.getHour()));
            this.jtfMinute.setText(String.valueOf(theTime.getMinute()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBridge(Application bridge) {
    }
}

