/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.images.Images;
import pilotdb.ui.recordsetview.EditorComponent;
import pilotdb.ui.recordsetview.NoteEditor;
import pilotdb.ui.util.FlatJButton;
import pilotdb.ui.util.UnderlineLabel;

public class NoteTitleEditor
extends JPanel
implements EditorComponent {
    JTextField jtf = new JTextField();
    UnderlineLabel jl = new UnderlineLabel();
    JButton jb = new FlatJButton();
    NoteEditor noteEditor = null;
    Application bridge = null;
    boolean editing = false;
    String note = null;

    public NoteTitleEditor() {
        this.jtf.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setLayout(null);
        this.jl.setDrawLineFullWidth(true);
        this.jtf.setBounds(0, 0, 150, 20);
        this.jl.setBounds(0, 0, 150, 20);
        this.jb.setBounds(150, 0, 20, 20);
        this.jb.setIcon(Images.NOTE_ICON);
        this.jb.setBorder(null);
        this.add(this.jtf);
        this.add(this.jl);
        this.add(this.jb);
        this.setPreferredSize(new Dimension(170, 20));
        this.jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                NoteTitleEditor.this.showNote();
            }
        });
    }

    public void showNote() {
        if (this.noteEditor == null) {
            this.noteEditor = new NoteEditor(this.bridge);
        }
        this.noteEditor.setEditable(this.editing);
        this.noteEditor.setNote(this.note);
        this.noteEditor.setVisible(true);
        if (this.editing) {
            this.note = this.noteEditor.getNote();
            if (this.noteEditor.getUseFirstLineForTitle()) {
                String note = this.noteEditor.getNote();
                int idx = note.indexOf("\n");
                if (idx < 0 || idx > 31) {
                    int titleLen = (int)Math.min(31.0, (double)note.length());
                    String title = note.substring(0, titleLen);
                    this.jtf.setText(title);
                } else {
                    this.jtf.setText(note.substring(0, idx));
                }
            }
        }
    }

    public boolean isValid() {
        return true;
    }

    public Component getEditorComponent() {
        return this;
    }

    public String getInvalidReason() {
        return null;
    }

    public void display(PilotDBRecord record, int fieldIndex) throws Exception {
        this.editing = false;
        this.note = record.getNote(fieldIndex);
        String val = record.getNoteTitle(fieldIndex);
        if (val == null) {
            return;
        }
        this.jl.setText(val);
        this.jtf.setVisible(false);
        this.jl.setVisible(true);
    }

    public void stopEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.editing = false;
        this.jtf.setEnabled(false);
        String s = this.jtf.getText();
        record.setNoteTitle(fieldIndex, s);
        if (this.note == null) {
            this.note = s;
        }
        record.setNote(fieldIndex, this.note);
    }

    public void startEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.editing = true;
        this.note = record.getNote(fieldIndex);
        this.jl.setVisible(false);
        this.jtf.setEnabled(true);
        this.jtf.setVisible(true);
        String val = record.getNoteTitle(fieldIndex);
        if (val == null) {
            return;
        }
        this.jtf.setText(val);
    }

    public void cancelEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.editing = false;
        this.note = record.getNote(fieldIndex);
        this.jtf.setEnabled(false);
        String string = record.getNoteTitle(fieldIndex);
        if (string == null) {
            return;
        }
        this.jtf.setText(string);
    }

    public void setBridge(Application bridge) {
        this.bridge = bridge;
    }
}

