/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBView;
import pilotdb.ui.Application;
import pilotdb.ui.Messages;
import pilotdb.ui.recordsetview.RecordsetTableModel;
import pilotdb.ui.util.FlatTableCellRenderer;
import pilotdb.ui.util.UIBanner;

public class LinkRecordSelector
extends JDialog {
    PilotDBDatabase linkDatabase;
    Application bridge;
    RecordsetTableModel tableModel = new RecordsetTableModel();
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable jTable1 = new JTable();
    JPanel jPanel1 = new JPanel();
    UIBanner uibanner = new UIBanner(Messages.getString("LinkRecordSelector.SelectRecord"), 500, null);
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    Border border1;
    Border border2;
    Border border3;
    JComboBox jcbViews = new JComboBox();
    JLabel jLabel1 = new JLabel();
    Border border4;
    private transient Vector actionListeners;
    private transient Vector propertyChangeListeners;

    public LinkRecordSelector(Application bridge) {
        super(bridge.getMainWindow(), Messages.getString("LinkRecordSelector.SelectRecord2"), true);
        this.bridge = bridge;
        this.tableModel.setCommandConduit(bridge);
        this.border1 = BorderFactory.createEmptyBorder();
        this.border2 = BorderFactory.createEmptyBorder();
        this.border3 = BorderFactory.createEmptyBorder();
        this.border4 = BorderFactory.createEmptyBorder();
        this.getContentPane().setLayout(this.borderLayout1);
        this.jTable1.setAutoResizeMode(0);
        this.jTable1.setModel(this.tableModel);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.flowLayout1.setVgap(0);
        this.jLabel1.setDisplayedMnemonic('V');
        this.jLabel1.setLabelFor(this.jcbViews);
        this.jLabel1.setText(Messages.getString("LinkRecordSelector.View"));
        this.jcbViews.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                LinkRecordSelector.this.onViewChange(e);
            }
        });
        this.jTable1.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getClickCount() > 1) {
                    LinkRecordSelector.this.onTableDoubleClick();
                }
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }
        });
        this.jPanel1.add((Component)this.uibanner, "Center");
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jLabel1, null);
        this.jPanel2.add((Component)this.jcbViews, null);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jTable1, null);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.setSize(400, 200);
        FlatTableCellRenderer ftcr = new FlatTableCellRenderer();
        ftcr.setBackground(Color.black);
        ftcr.setForeground(Color.white);
        ftcr.setHorizontalAlignment(2);
        this.jTable1.getTableHeader().setDefaultRenderer(ftcr);
    }

    public Application getBridge() {
        return this.bridge;
    }

    public PilotDBDatabase getLinkDatabase() {
        return this.linkDatabase;
    }

    public void setLinkDatabase(PilotDBDatabase linkDatabase) {
        this.linkDatabase = linkDatabase;
    }

    public PilotDBRecord getSelectedRecord() {
        int selectedRow = this.jTable1.getSelectedRow();
        if (selectedRow < 0) {
            return null;
        }
        PilotDBRecord record = (PilotDBRecord)this.tableModel.getDatabase().getRecord(selectedRow);
        return record;
    }

    public void setDatabase(PilotDBDatabase db) {
        this.tableModel.setDatabase(db);
        Iterator iter = db.getViews().iterator();
        this.jcbViews.removeAllItems();
        this.jcbViews.addItem(Messages.getString("LinkRecordSelector.AllFields"));
        while (iter.hasNext()) {
            PilotDBView view = (PilotDBView)iter.next();
            this.jcbViews.addItem(view.getName());
        }
        this.uibanner.setText(db.getTitle());
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((ActionListener)listeners.elementAt(i)).actionPerformed(e);
                ++i;
            }
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
        if (this.propertyChangeListeners != null && this.propertyChangeListeners.contains(l)) {
            Vector v = (Vector)this.propertyChangeListeners.clone();
            v.removeElement(l);
            this.propertyChangeListeners = v;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        Vector v;
        super.addPropertyChangeListener(l);
        Vector vector = v = this.propertyChangeListeners == null ? new Vector(2) : (Vector)this.propertyChangeListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.propertyChangeListeners = v;
        }
    }

    protected void firePropertyChange(PropertyChangeEvent e) {
        if (this.propertyChangeListeners != null) {
            Vector listeners = this.propertyChangeListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((PropertyChangeListener)listeners.elementAt(i)).propertyChange(e);
                ++i;
            }
        }
    }

    void onViewChange(ItemEvent e) {
        if (this.jcbViews.getSelectedIndex() == 0) {
            this.tableModel.setViewName(null);
        } else {
            String viewName = this.jcbViews.getSelectedItem().toString();
            this.tableModel.setViewName(viewName);
            PilotDBView v = this.tableModel.getDatabase().getView(viewName);
            int i = 0;
            while (i < v.getColumnCount()) {
                this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(v.getColumn(i).getFieldWidth());
                ++i;
            }
        }
    }

    private void onTableDoubleClick() {
        int selectedRow = this.jTable1.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        this.setVisible(false);
    }
}

