/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBEnvironment;
import pilotdb.PilotDBField;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.recordsetview.EditorComponent;
import pilotdb.ui.recordsetview.LinkRecordSelector;
import pilotdb.ui.util.FlatJButton;
import pilotdb.ui.util.UnderlineLabel;

public class LinkEditor
extends JPanel
implements EditorComponent {
    LinkRecordSelector recordSelector;
    int linkColumn = -1;
    Application bridge;
    PilotDBRecord record;
    int fieldIndex = -1;
    UnderlineLabel jl = new UnderlineLabel();
    JButton jb = new FlatJButton();

    public LinkEditor() {
        this.setLayout(null);
        this.jl.setBounds(0, 0, 225, 20);
        this.add(this.jl);
        this.jl.setDrawLineFullWidth(true);
        this.jb.setBounds(0, 0, 225, 20);
        this.jb.setHorizontalAlignment(2);
        this.add(this.jb);
        this.setPreferredSize(new Dimension(225, 20));
        this.jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                LinkEditor.this.onButtonClick();
            }
        });
    }

    public void setBridge(Application bridge) {
        this.bridge = bridge;
    }

    private void onButtonClick() {
        try {
            if (this.recordSelector == null) {
                this.recordSelector = new LinkRecordSelector(this.bridge);
                PilotDBField thisField = this.record.getSchema().getField(this.fieldIndex);
                String linkDbName = thisField.getLinkDbName();
                this.linkColumn = thisField.getLinkColumnNumber();
                PilotDBEnvironment env = PilotDBEnvironment.getEnvironment((PilotDBDatabase)this.record.getDatabase());
                PilotDBDatabase linkDb = env.getDatabaseByTitle(linkDbName);
                this.recordSelector.setDatabase(linkDb);
            }
            this.recordSelector.setVisible(true);
            PilotDBRecord rec = this.recordSelector.getSelectedRecord();
            if (rec == null) {
                return;
            }
            this.jb.setText(String.valueOf(rec.getObject(this.linkColumn)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return true;
    }

    public Component getEditorComponent() {
        return this;
    }

    public String getInvalidReason() {
        return null;
    }

    public void display(PilotDBRecord record, int fieldIndex) throws Exception {
        this.record = record;
        this.fieldIndex = fieldIndex;
        String val = record.getLinkText(fieldIndex);
        if (val == null) {
            return;
        }
        this.jl.setText(val);
        this.jb.setVisible(false);
        this.jl.setVisible(true);
    }

    public void stopEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.record = record;
        this.fieldIndex = fieldIndex;
        this.jb.setEnabled(false);
        String s = this.jb.getText();
        record.setLink(fieldIndex, s);
    }

    public void startEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.record = record;
        this.fieldIndex = fieldIndex;
        this.jl.setVisible(false);
        this.jb.setEnabled(true);
        this.jb.setVisible(true);
        String val = record.getLinkText(fieldIndex);
        if (val == null) {
            return;
        }
        this.jb.setText(val);
    }

    public void cancelEditing(PilotDBRecord record, int fieldIndex) {
        this.record = record;
        this.fieldIndex = fieldIndex;
        this.jb.setEnabled(false);
        try {
            String string = record.getLinkText(fieldIndex);
            if (string == null) {
                return;
            }
            this.jb.setText(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

