/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.Messages;
import pilotdb.ui.recordsetview.EditorComponent;
import pilotdb.ui.util.UnderlineLabel;

public class IntegerEditor
extends JPanel
implements EditorComponent {
    JTextField jtf = new JTextField();
    UnderlineLabel jl = new UnderlineLabel();

    public IntegerEditor() {
        this.jtf.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setLayout(null);
        this.jl.setHorizontalAlignment(2);
        this.jtf.setBounds(0, 0, 150, 20);
        this.jl.setBounds(0, 0, 150, 20);
        this.add(this.jtf);
        this.add(this.jl);
        this.jl.setDrawLineFullWidth(true);
        this.setPreferredSize(new Dimension(150, 25));
    }

    public boolean isValid() {
        try {
            Integer.parseInt(this.jtf.getText());
            this.jtf.setForeground(Color.black);
            return true;
        }
        catch (Exception e) {
            this.jtf.setForeground(Color.red);
            return false;
        }
    }

    public Component getEditorComponent() {
        return this.jtf;
    }

    public String getInvalidReason() {
        return String.valueOf(Messages.getString("IntegerEditor.InvalidIntegerValue")) + this.getName();
    }

    public void display(PilotDBRecord record, int fieldIndex) throws Exception {
        int val = record.getInteger(fieldIndex);
        this.jl.setText(String.valueOf(val));
        this.jtf.setVisible(false);
        this.jl.setVisible(true);
    }

    public void stopEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.jtf.setEnabled(false);
        String s = this.jtf.getText();
        record.setInteger(fieldIndex, Integer.parseInt(s));
    }

    public void startEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.jl.setVisible(false);
        this.jtf.setEnabled(true);
        this.jtf.setVisible(true);
        int i = record.getInteger(fieldIndex);
        this.jtf.setText(String.valueOf(i));
    }

    public void cancelEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.jtf.setEnabled(false);
        int i = record.getInteger(fieldIndex);
        this.jtf.setText(String.valueOf(i));
    }

    public void setBridge(Application bridge) {
    }
}

