/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBField;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBSchema;
import pilotdb.ui.Application;
import pilotdb.ui.Messages;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.CommandHandlerSupport;
import pilotdb.ui.images.Images;
import pilotdb.ui.recordsetview.BooleanEditor;
import pilotdb.ui.recordsetview.CalculatedEditor;
import pilotdb.ui.recordsetview.DateEditor;
import pilotdb.ui.recordsetview.EditorComponent;
import pilotdb.ui.recordsetview.FloatEditor;
import pilotdb.ui.recordsetview.IntegerEditor;
import pilotdb.ui.recordsetview.LinkEditor;
import pilotdb.ui.recordsetview.LinkedEditor;
import pilotdb.ui.recordsetview.ListEditor;
import pilotdb.ui.recordsetview.NoteTitleEditor;
import pilotdb.ui.recordsetview.RecordsetTableModel;
import pilotdb.ui.recordsetview.StringEditor;
import pilotdb.ui.recordsetview.TimeEditor;
import pilotdb.ui.util.FlatJButton;
import pilotdb.ui.util.UIBanner;

public class DynamicFormPanel
extends JPanel {
    Icon saveIcon = Images.SAVE_ICON;
    Icon undoIcon = Images.UNDO_ICON;
    EditorComponent[] editorComponents = null;
    PilotDBRecord record;
    CommandHandlerSupport support = new CommandHandlerSupport();
    Application bridge = null;
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    RecordsetTableModel tableModel = new RecordsetTableModel();
    private transient Vector actionListeners;
    private transient Vector propertyChangeListeners;
    JPanel jPanel1 = new JPanel();
    UIBanner uibanner = new UIBanner(Messages.getString("DynamicFormPanel.TableData"), 500, null);
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jpDynamic = new JPanel();
    JLabel jlRecordOf = new JLabel();
    FlowLayout flowLayout1 = new FlowLayout(0, 0, 0);
    boolean editing = false;
    JButton jbFirst = new FlatJButton();
    JButton jbLast = new FlatJButton();
    JButton jbNext = new FlatJButton();
    JButton jbPrevious = new FlatJButton();
    JPanel jpRecordOf = new JPanel();

    public DynamicFormPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startEditing() throws Exception {
        this.editing = true;
        int i = 0;
        while (i < this.editorComponents.length) {
            this.editorComponents[i].startEditing(this.record, i);
            ++i;
        }
        this.updateNavigationButtons();
    }

    private void updateNavigationButtons() {
        int pos = this.record.getDatabase().indexOf(this.record);
        int count = this.record.getDatabase().getRecordCount();
        this.jbFirst.setEnabled(this.editing ? false : pos > 0);
        this.jbPrevious.setEnabled(this.editing ? false : pos > 0);
        this.jbNext.setEnabled(this.editing ? false : pos < count - 1);
        this.jbLast.setEnabled(this.editing ? false : pos < count - 1);
    }

    private void cancelEditing() throws Exception {
        this.editing = false;
        int i = 0;
        while (i < this.editorComponents.length) {
            this.editorComponents[i].cancelEditing(this.record, i);
            ++i;
        }
        this.updateNavigationButtons();
    }

    private boolean stopEditing() throws Exception {
        boolean valid = true;
        LinkedList<String> errors = new LinkedList<String>();
        int i = 0;
        while (i < this.editorComponents.length) {
            valid = this.editorComponents[i].isValid();
            if (!valid) {
                this.editorComponents[i].getEditorComponent().requestFocus();
                errors.add(this.editorComponents[i].getInvalidReason());
                valid = false;
            }
            ++i;
        }
        if (!valid) {
            String unable = Messages.getString("DynamicFormPanel.UnableToSaveRecordDueTo");
            int i2 = 0;
            while (i2 < errors.size()) {
                unable = String.valueOf(unable) + "\n" + errors.get(i2);
                ++i2;
            }
            Command errorCommand = new Command(this, "cmd-show-error", unable);
            this.getBridge().postEvent(errorCommand);
            return false;
        }
        this.editing = false;
        i = 0;
        while (i < this.editorComponents.length) {
            this.editorComponents[i].stopEditing(this.record, i);
            ++i;
        }
        this.updateNavigationButtons();
        return true;
    }

    private void display() throws Exception {
        this.editing = false;
        int i = 0;
        while (i < this.editorComponents.length) {
            this.editorComponents[i].display(this.record, i);
            ++i;
        }
        this.updateNavigationButtons();
    }

    private void buildDynamic() {
        PilotDBSchema schema = this.record.getSchema();
        this.editorComponents = new EditorComponent[schema.getFieldCount()];
        this.jpDynamic.removeAll();
        this.jScrollPane1.getViewport().remove(this.jpDynamic);
        this.jpDynamic = new JPanel();
        this.jpDynamic.setLayout(null);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int maxWidth = this.getMaxFieldNameLength(schema, fm);
        maxWidth += 10;
        int leftMargin = 10;
        int top = 10;
        int widestComponent = 0;
        int i = 0;
        while (i < schema.getFieldCount()) {
            PilotDBField field = schema.getField(i);
            JLabel jl = new JLabel(String.valueOf(field.getName()) + " :");
            jl.setHorizontalAlignment(4);
            this.editorComponents[i] = this.createComponentForField(field);
            this.editorComponents[i].setBridge(this.bridge);
            this.editorComponents[i].setName(field.getName());
            Dimension d = this.editorComponents[i].getPreferredSize();
            jl.setBounds(leftMargin, top, maxWidth, 20);
            this.editorComponents[i].setBounds(leftMargin * 2 + maxWidth, top, d.width, d.height);
            widestComponent = Math.max(widestComponent, d.width);
            top = top + d.height + 20;
            this.jpDynamic.add((JComponent)((Object)this.editorComponents[i]));
            this.jpDynamic.add(jl);
            ++i;
        }
        this.jpDynamic.setVisible(true);
        Dimension d = new Dimension(maxWidth + leftMargin * 3 + widestComponent, top);
        this.jpDynamic.setPreferredSize(d);
        this.jpDynamic.setSize(d);
        this.jScrollPane1.getViewport().add(this.jpDynamic);
    }

    public int getMaxFieldNameLength(PilotDBSchema schema, FontMetrics fm) {
        int width = 0;
        int i = 0;
        while (i < schema.getFieldCount()) {
            width = Math.max(width, fm.stringWidth(schema.getField(i).getName()));
            ++i;
        }
        return width;
    }

    private EditorComponent createComponentForField(PilotDBField field) {
        switch (field.getType()) {
            case 1: {
                return new BooleanEditor();
            }
            case 3: {
                return new DateEditor();
            }
            case 4: {
                return new TimeEditor();
            }
            case 6: {
                return new ListEditor();
            }
            case 5: {
                return new NoteTitleEditor();
            }
            case 10: {
                return new LinkedEditor();
            }
            case 0: {
                return new StringEditor();
            }
            case 8: {
                return new FloatEditor();
            }
            case 2: {
                return new IntegerEditor();
            }
            case 7: {
                return new LinkEditor();
            }
            case 9: {
                return new CalculatedEditor();
            }
        }
        return null;
    }

    public void setRecord(PilotDBRecord record) {
        this.record = record;
        this.uibanner.setText(record.getDatabase().getTitle());
        this.buildDynamic();
        try {
            this.display();
        }
        catch (Exception e) {
            this.bridge.postEvent(new Command(this, "cmd-log-exception", e));
        }
        this.updateRecordOf();
        this.updateNavigationButtons();
    }

    public void setBridge(Application bridge) {
        this.bridge = bridge;
        this.tableModel.setCommandConduit(bridge);
    }

    public Application getBridge() {
        return this.bridge;
    }

    private void updateRecordOf() {
        this.jlRecordOf.setText("Record " + (1 + this.record.getDatabase().indexOf(this.record)) + " of " + this.record.getDatabase().getRecordCount());
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jPanel1.setLayout(this.borderLayout2);
        this.setPreferredSize(new Dimension(400, 350));
        this.jbFirst.setBounds(0, 40, 25, 25);
        this.jbFirst.setText("<<");
        this.jpRecordOf.add(this.jbFirst);
        this.jbPrevious.setBounds(25, 40, 25, 25);
        this.jbPrevious.setText("<");
        this.jpRecordOf.add(this.jbPrevious);
        this.jlRecordOf.setBounds(50, 40, 100, 25);
        this.jpRecordOf.add(this.jlRecordOf);
        this.jbNext.setBounds(150, 40, 25, 25);
        this.jbNext.setText(">");
        this.jpRecordOf.add(this.jbNext);
        this.jbLast.setBounds(175, 40, 25, 25);
        this.jbLast.setText(">>");
        this.jpRecordOf.add(this.jbLast);
        this.add((Component)this.jpRecordOf, "South");
        this.jbNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PilotDBRecord next = DynamicFormPanel.this.next();
                if (next == null) {
                    return;
                }
                DynamicFormPanel.this.setRecord(next);
            }
        });
        this.jbPrevious.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PilotDBRecord previous = DynamicFormPanel.this.previous();
                if (previous == null) {
                    return;
                }
                DynamicFormPanel.this.setRecord(previous);
            }
        });
        this.jbFirst.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PilotDBRecord first = DynamicFormPanel.this.first();
                if (first == null) {
                    return;
                }
                DynamicFormPanel.this.setRecord(first);
            }
        });
        this.jbLast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PilotDBRecord last = DynamicFormPanel.this.last();
                if (last == null) {
                    return;
                }
                DynamicFormPanel.this.setRecord(last);
            }
        });
        this.add((Component)this.uibanner, "North");
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jpDynamic, null);
    }

    public PilotDBRecord next() {
        int position = this.record.getDatabase().indexOf(this.record);
        if (position == this.record.getDatabase().getRecordCount() - 1) {
            return null;
        }
        return (PilotDBRecord)this.record.getDatabase().getRecord(position + 1);
    }

    public PilotDBRecord last() {
        return (PilotDBRecord)this.record.getDatabase().getRecord(this.record.getDatabase().getRecordCount() - 1);
    }

    public PilotDBRecord first() {
        return (PilotDBRecord)this.record.getDatabase().getRecord(0);
    }

    public PilotDBRecord previous() {
        int position = this.record.getDatabase().indexOf(this.record);
        if (position == 0) {
            return null;
        }
        return (PilotDBRecord)this.record.getDatabase().getRecord(position - 1);
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((ActionListener)listeners.elementAt(i)).actionPerformed(e);
                ++i;
            }
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
        if (this.propertyChangeListeners != null && this.propertyChangeListeners.contains(l)) {
            Vector v = (Vector)this.propertyChangeListeners.clone();
            v.removeElement(l);
            this.propertyChangeListeners = v;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        Vector v;
        super.addPropertyChangeListener(l);
        Vector vector = v = this.propertyChangeListeners == null ? new Vector(2) : (Vector)this.propertyChangeListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.propertyChangeListeners = v;
        }
    }

    protected void firePropertyChange(PropertyChangeEvent e) {
        if (this.propertyChangeListeners != null) {
            Vector listeners = this.propertyChangeListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((PropertyChangeListener)listeners.elementAt(i)).propertyChange(e);
                ++i;
            }
        }
    }

    void jbUndo_actionPerformed(ActionEvent e) {
        try {
            this.cancelEditing();
            this.display();
        }
        catch (Exception ex) {
            this.bridge.postEvent(new Command(this, "cmd-log-exception", ex));
        }
    }

    void jbDelete_actionPerformed(ActionEvent e) {
        int response = JOptionPane.showConfirmDialog(this, Messages.getString("DynamicFormPanel.DeleteThisRecordConfirm"), Messages.getString("DynamicFormPanel.DeleteRecord"), 0);
        if (response == 1) {
            return;
        }
        PilotDBDatabase db = this.record.getDb();
        int idx = db.indexOf(this.record);
        int cnt = db.getRecordCount();
        db.deleteRecord(this.record);
        Command c = new Command(this, "msg-deleted-record", this.record);
        this.getBridge().postEvent(c);
        if (cnt > 1) {
            if (idx == cnt - 1) {
                idx = cnt - 2;
            }
            try {
                this.record = (PilotDBRecord)db.getRecord(idx);
                this.display();
            }
            catch (Exception ioe) {
                this.bridge.postEvent(new Command(this, "cmd-log-exception", ioe));
                this.fireActionPerformed(new ActionEvent(this, 1001, "cmd-close-window"));
            }
        } else {
            this.record = null;
            this.fireActionPerformed(new ActionEvent(this, 1001, "cmd-close-window"));
        }
        this.editing = false;
    }

    void jbSave_actionPerformed(ActionEvent e) {
        try {
            if (this.stopEditing()) {
                this.editing = false;
                this.display();
                Command c = new Command(this, "msg-changed-record", this.record);
                this.getBridge().postEvent(c);
            }
        }
        catch (Exception ex) {
            this.bridge.postEvent(new Command(this, "cmd-log-exception", ex));
        }
    }

    public void edit() {
        this.jbEdit_actionPerformed(null);
        Command c = new Command(this, "msg-windowstate-changed", this);
        this.getBridge().postEvent(c);
    }

    void jbEdit_actionPerformed(ActionEvent e) {
        this.editing = true;
        try {
            this.startEditing();
            if (this.editorComponents.length > 0) {
                ((JComponent)((Object)this.editorComponents[0])).requestFocus();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isEditing() {
        return this.editing;
    }

    public PilotDBRecord getRecord() {
        return this.record;
    }

    void jbCopy_actionPerformed(ActionEvent e) {
        try {
            PilotDBRecord newRecord = ((PilotDBDatabase)this.record.getDatabase()).createRecord();
            this.startEditing();
            this.record = newRecord;
            this.stopEditing();
            Command c = new Command(this, "msg-added-record", this.record);
            this.getBridge().postEvent(c);
            this.startEditing();
            JOptionPane.showMessageDialog(this, Messages.getString("DynamicFormPanel.RecordCopiedClickOK"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void copy() {
        if (!this.isEditing()) {
            this.jbCopy_actionPerformed(null);
        }
        Command c = new Command(this, "msg-windowstate-changed", this);
        this.getBridge().postEvent(c);
    }

    public void delete() {
        if (!this.isEditing()) {
            this.jbDelete_actionPerformed(null);
        }
        Command c = new Command(this, "msg-windowstate-changed", this);
        this.getBridge().postEvent(c);
    }

    public void save() {
        if (this.isEditing()) {
            this.jbSave_actionPerformed(null);
        }
        Command c = new Command(this, "msg-windowstate-changed", this);
        this.getBridge().postEvent(c);
    }

    public void undo() {
        if (this.isEditing()) {
            this.jbUndo_actionPerformed(null);
        }
        Command c = new Command(this, "msg-windowstate-changed", this);
        this.getBridge().postEvent(c);
    }
}

