/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.Messages;
import pilotdb.ui.command.Command;
import pilotdb.ui.images.Images;
import pilotdb.ui.recordsetview.DynamicFormPanel;

public class DynamicForm
extends JInternalFrame
implements ActionListener {
    DynamicFormPanel dynamicFormPanel = new DynamicFormPanel();
    Application bridge;

    public DynamicForm(Application bridge) {
        super(Messages.getString("DynamicForm.EditRecord"));
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setClosable(true);
        this.setResizable(true);
        this.setFrameIcon(Images.DYNAMIC_FORM_ICON);
        this.getContentPane().add(this.dynamicFormPanel);
        this.setLocation(10, 10);
        this.setSize(350, 275);
        this.setDefaultCloseOperation(2);
        this.bridge = bridge;
        bridge.getMainWindow().getDesktop().add(this);
        this.dynamicFormPanel.setBridge(bridge);
        this.dynamicFormPanel.addActionListener(this);
        this.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameOpened(InternalFrameEvent arg0) {
            }

            public void internalFrameClosing(InternalFrameEvent arg0) {
            }

            public void internalFrameClosed(InternalFrameEvent arg0) {
            }

            public void internalFrameIconified(InternalFrameEvent arg0) {
            }

            public void internalFrameDeiconified(InternalFrameEvent arg0) {
            }

            public void internalFrameActivated(InternalFrameEvent arg0) {
                DynamicForm.this.onActivated();
            }

            public void internalFrameDeactivated(InternalFrameEvent arg0) {
            }
        });
        this.setVisible(true);
    }

    public void onActivated() {
        Command ce = new Command(this, "cmd-log-debug", "dynamic form activated");
        this.bridge.postEvent(ce);
        if (this.getRecord() != null) {
            PilotDBDatabase db = (PilotDBDatabase)this.getRecord().getDatabase();
            Command c = new Command(this, "msg-selected-database", db);
            this.bridge.postEvent(c);
        }
        Command c = new Command(this, "msg-window-activated", this);
        this.bridge.postEvent(c);
        c = new Command(this, "msg-windowstate-changed", this);
        this.bridge.postEvent(c);
    }

    public void setRecord(PilotDBRecord record) {
        this.dynamicFormPanel.setRecord(record);
        this.setTitle(String.valueOf(record.getDatabase().getTitle()) + Messages.getString("DynamicForm.Form"));
    }

    public PilotDBRecord getRecord() {
        return this.dynamicFormPanel.getRecord();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("cmd-close-window")) {
            this.setVisible(false);
            this.bridge.getMainWindow().getDesktop().remove(this);
        }
    }

    public boolean isEditing() {
        return this.dynamicFormPanel.isEditing();
    }

    public void edit() {
        this.dynamicFormPanel.edit();
    }

    public void save() {
        this.dynamicFormPanel.save();
    }

    public void undo() {
        this.dynamicFormPanel.undo();
    }

    public void copy() {
        this.dynamicFormPanel.copy();
    }

    public void delete() {
        this.dynamicFormPanel.delete();
    }
}

