/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.recordsetview;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.images.Images;
import pilotdb.ui.recordsetview.EditorComponent;

public class BooleanEditor
extends JPanel
implements EditorComponent {
    JCheckBox check = new JCheckBox();
    Icon checkboxCheckedIcon = Images.CHECKBOX_CHECKED_ICON;
    Icon checkboxNotCheckedIcon = Images.CHECKBOX_UNCHECKED_ICON;

    public BooleanEditor() {
        this.check.setSelectedIcon(this.checkboxCheckedIcon);
        this.check.setIcon(this.checkboxNotCheckedIcon);
        this.setLayout(null);
        this.check.setBounds(0, 0, 150, 20);
        this.add(this.check);
        this.setPreferredSize(new Dimension(150, 25));
    }

    public Component getEditorComponent() {
        return this;
    }

    public boolean isValid() {
        return true;
    }

    public String getInvalidReason() {
        return null;
    }

    public void display(PilotDBRecord record, int fieldIndex) throws Exception {
        this.check.setEnabled(false);
        boolean b = record.getBoolean(fieldIndex);
        this.check.setSelected(b);
    }

    public void stopEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        record.setBoolean(fieldIndex, this.check.isSelected());
        this.check.setEnabled(false);
    }

    public void startEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.check.setEnabled(true);
        boolean b = record.getBoolean(fieldIndex);
        this.check.setSelected(b);
    }

    public void cancelEditing(PilotDBRecord record, int fieldIndex) throws Exception {
        this.check.setEnabled(false);
        boolean b = record.getBoolean(fieldIndex);
        this.check.setSelected(b);
    }

    public void setBridge(Application bridge) {
    }
}

