/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.databaselist;

import javax.swing.table.AbstractTableModel;
import pilotdb.PilotDBAppInfo;
import pilotdb.PilotDBDatabase;

public class DbPropertiesModel
extends AbstractTableModel {
    private PilotDBDatabase database;
    private String[] columnNames = new String[]{"property", "value"};
    private String[] propertyNames = new String[]{"title", "version", "created", "last modification", "last backup", "type", "creator", "global find enabled", "read only", "protected by password"};

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.propertyNames[row];
        }
        switch (row) {
            case 0: {
                return this.database.getTitle();
            }
            case 1: {
                return String.valueOf(this.database.getVersion());
            }
            case 2: {
                return this.database.getCreationDate().toDate();
            }
            case 3: {
                return this.database.getLastModificationDate().toDate();
            }
            case 4: {
                return this.database.getLastBackupDate().toDate();
            }
            case 5: {
                return this.database.getType();
            }
            case 6: {
                return this.database.getCreator();
            }
            case 7: {
                return new Boolean(((PilotDBAppInfo)this.database.getAppInfo()).isGlobalFindEnable());
            }
            case 8: {
                return new Boolean(((PilotDBAppInfo)this.database.getAppInfo()).isReadOnly());
            }
            case 9: {
                return new Boolean(((PilotDBAppInfo)this.database.getAppInfo()).isProtected());
            }
        }
        throw new RuntimeException("invalid row");
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        if (this.database == null) {
            return 0;
        }
        return this.propertyNames.length;
    }

    public PilotDBDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(PilotDBDatabase database) {
        this.database = database;
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 0) {
            return false;
        }
        return row == 7 || row == 8;
    }

    public void setValueAt(Object arg0, int row, int column) {
        if (column == 0) {
            return;
        }
        if (row == 7) {
            Boolean globalFind = Boolean.valueOf(String.valueOf(arg0));
            ((PilotDBAppInfo)this.database.getAppInfo()).setGlobalFindEnable(globalFind);
        } else if (row == 8) {
            Boolean readOnly = Boolean.valueOf(String.valueOf(arg0));
            ((PilotDBAppInfo)this.database.getAppInfo()).setReadOnly(readOnly);
        } else if (row == 9) {
            Boolean prot = Boolean.valueOf(String.valueOf(arg0));
            ((PilotDBAppInfo)this.database.getAppInfo()).setProtected(prot);
        }
    }

    public String getColumnName(int arg0) {
        return this.columnNames[arg0];
    }
}

